/*
 Navicat Premium Data Transfer

 Source Server         : 新照明平台
 Source Server Type    : PostgreSQL
 Source Server Version : 90518
 Source Host           : 192.168.22.162:5432
 Source Catalog        : slmp
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 90518
 File Encoding         : 65001

 Date: 01/07/2022 19:06:12
*/

-- ----------------------------
-- Table structure for slmp_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device";
CREATE TABLE "public"."slmp_device" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_device"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_device"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_device"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_device"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_device"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_device"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_device"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_device"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_device"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_device"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_device"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_device"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_device"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_device"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_device"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_device"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_device"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_device"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_device"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_device"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_device"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_device"."group_ids" IS '组ID集合,多个用逗号分隔';

-- ----------------------------
-- Table structure for slmp_managed_object
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_managed_object";
CREATE TABLE "public"."slmp_managed_object" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_managed_object"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_managed_object"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_managed_object"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_managed_object"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_managed_object"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_managed_object"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_managed_object"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_managed_object"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_managed_object"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_managed_object"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_managed_object"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_managed_object"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_managed_object"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_managed_object"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_managed_object"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_managed_object"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_managed_object"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_managed_object"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_managed_object"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_managed_object"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_managed_object"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_managed_object"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_managed_object"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_managed_object"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_managed_object"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_managed_object"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_managed_object"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_managed_object"."attach_url" IS '附件地址';
COMMENT ON TABLE "public"."slmp_managed_object" IS '用户表';

-- ----------------------------
-- Table structure for blade_attach
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_attach";
CREATE TABLE "public"."blade_attach" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "link" varchar(1000) COLLATE "pg_catalog"."default",
  "domain" varchar(500) COLLATE "pg_catalog"."default",
  "name" varchar(500) COLLATE "pg_catalog"."default",
  "original_name" varchar(500) COLLATE "pg_catalog"."default",
  "extension" varchar(12) COLLATE "pg_catalog"."default",
  "attach_size" int8,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_attach"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_attach"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_attach"."link" IS '附件地址';
COMMENT ON COLUMN "public"."blade_attach"."domain" IS '附件域名';
COMMENT ON COLUMN "public"."blade_attach"."name" IS '附件名称';
COMMENT ON COLUMN "public"."blade_attach"."original_name" IS '附件原名';
COMMENT ON COLUMN "public"."blade_attach"."extension" IS '附件拓展名';
COMMENT ON COLUMN "public"."blade_attach"."attach_size" IS '附件大小';
COMMENT ON COLUMN "public"."blade_attach"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_attach"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_attach"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_attach"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_attach"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_attach"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_attach"."is_deleted" IS '是否已删除';

-- ----------------------------
-- Table structure for blade_client
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_client";
CREATE TABLE "public"."blade_client" (
  "id" int8 NOT NULL,
  "client_id" varchar(48) COLLATE "pg_catalog"."default" NOT NULL,
  "client_secret" varchar(256) COLLATE "pg_catalog"."default" NOT NULL,
  "resource_ids" varchar(256) COLLATE "pg_catalog"."default",
  "scope" varchar(256) COLLATE "pg_catalog"."default" NOT NULL,
  "authorized_grant_types" varchar(256) COLLATE "pg_catalog"."default" NOT NULL,
  "web_server_redirect_uri" varchar(256) COLLATE "pg_catalog"."default",
  "authorities" varchar(256) COLLATE "pg_catalog"."default",
  "access_token_validity" int4 NOT NULL,
  "refresh_token_validity" int4 NOT NULL,
  "additional_information" varchar(4096) COLLATE "pg_catalog"."default",
  "autoapprove" varchar(256) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4 NOT NULL,
  "is_deleted" int4 NOT NULL
)
;
COMMENT ON COLUMN "public"."blade_client"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_client"."client_id" IS '客户端id';
COMMENT ON COLUMN "public"."blade_client"."client_secret" IS '客户端密钥';
COMMENT ON COLUMN "public"."blade_client"."resource_ids" IS '资源集合';
COMMENT ON COLUMN "public"."blade_client"."scope" IS '授权范围';
COMMENT ON COLUMN "public"."blade_client"."authorized_grant_types" IS '授权类型';
COMMENT ON COLUMN "public"."blade_client"."web_server_redirect_uri" IS '回调地址';
COMMENT ON COLUMN "public"."blade_client"."authorities" IS '权限';
COMMENT ON COLUMN "public"."blade_client"."access_token_validity" IS '令牌过期秒数';
COMMENT ON COLUMN "public"."blade_client"."refresh_token_validity" IS '刷新令牌过期秒数';
COMMENT ON COLUMN "public"."blade_client"."additional_information" IS '附加说明';
COMMENT ON COLUMN "public"."blade_client"."autoapprove" IS '自动授权';
COMMENT ON COLUMN "public"."blade_client"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_client"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_client"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_client"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_client"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_client"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_client"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_client" IS '客户端表';

-- ----------------------------
-- Table structure for blade_code
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_code";
CREATE TABLE "public"."blade_code" (
  "id" int8 NOT NULL,
  "datasource_id" int8,
  "service_name" varchar(64) COLLATE "pg_catalog"."default",
  "code_name" varchar(64) COLLATE "pg_catalog"."default",
  "table_name" varchar(64) COLLATE "pg_catalog"."default",
  "table_prefix" varchar(64) COLLATE "pg_catalog"."default",
  "pk_name" varchar(32) COLLATE "pg_catalog"."default",
  "package_name" varchar(500) COLLATE "pg_catalog"."default",
  "base_mode" int2,
  "wrap_mode" int2,
  "api_path" varchar(2000) COLLATE "pg_catalog"."default",
  "web_path" varchar(2000) COLLATE "pg_catalog"."default",
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_code"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_code"."datasource_id" IS '数据源主键';
COMMENT ON COLUMN "public"."blade_code"."service_name" IS '服务名称';
COMMENT ON COLUMN "public"."blade_code"."code_name" IS '模块名称';
COMMENT ON COLUMN "public"."blade_code"."table_name" IS '表名';
COMMENT ON COLUMN "public"."blade_code"."table_prefix" IS '表前缀';
COMMENT ON COLUMN "public"."blade_code"."pk_name" IS '主键名';
COMMENT ON COLUMN "public"."blade_code"."package_name" IS '后端包名';
COMMENT ON COLUMN "public"."blade_code"."base_mode" IS '基础业务模式';
COMMENT ON COLUMN "public"."blade_code"."wrap_mode" IS '包装器模式';
COMMENT ON COLUMN "public"."blade_code"."api_path" IS '后端路径';
COMMENT ON COLUMN "public"."blade_code"."web_path" IS '前端路径';
COMMENT ON COLUMN "public"."blade_code"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_code" IS '代码生成表';

-- ----------------------------
-- Table structure for blade_datasource
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_datasource";
CREATE TABLE "public"."blade_datasource" (
  "id" int8 NOT NULL,
  "name" varchar(100) COLLATE "pg_catalog"."default",
  "driver_class" varchar(100) COLLATE "pg_catalog"."default",
  "url" varchar(500) COLLATE "pg_catalog"."default",
  "username" varchar(45) COLLATE "pg_catalog"."default",
  "password" varchar(45) COLLATE "pg_catalog"."default",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_datasource"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_datasource"."name" IS '名称';
COMMENT ON COLUMN "public"."blade_datasource"."driver_class" IS '驱动类';
COMMENT ON COLUMN "public"."blade_datasource"."url" IS '链接地址';
COMMENT ON COLUMN "public"."blade_datasource"."username" IS '用户名';
COMMENT ON COLUMN "public"."blade_datasource"."password" IS '密码';
COMMENT ON COLUMN "public"."blade_datasource"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_datasource"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_datasource"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_datasource"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_datasource"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_datasource"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_datasource"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_datasource"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_datasource" IS '数据源配置表';

-- ----------------------------
-- Table structure for blade_dept
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_dept";
CREATE TABLE "public"."blade_dept" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "ancestors" varchar(2000) COLLATE "pg_catalog"."default",
  "dept_category" int4,
  "dept_name" varchar(45) COLLATE "pg_catalog"."default",
  "full_name" varchar(45) COLLATE "pg_catalog"."default",
  "sort" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_dept"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_dept"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_dept"."parent_id" IS '父主键';
COMMENT ON COLUMN "public"."blade_dept"."ancestors" IS '祖级列表';
COMMENT ON COLUMN "public"."blade_dept"."dept_category" IS '部门类型';
COMMENT ON COLUMN "public"."blade_dept"."dept_name" IS '部门名';
COMMENT ON COLUMN "public"."blade_dept"."full_name" IS '部门全称';
COMMENT ON COLUMN "public"."blade_dept"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_dept"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_dept"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_dept" IS '机构表';

-- ----------------------------
-- Table structure for blade_dict
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_dict";
CREATE TABLE "public"."blade_dict" (
  "id" int8 NOT NULL,
  "parent_id" int8,
  "code" varchar(255) COLLATE "pg_catalog"."default",
  "dict_key" varchar(255) COLLATE "pg_catalog"."default",
  "dict_value" varchar(255) COLLATE "pg_catalog"."default",
  "sort" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "is_sealed" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_dict"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_dict"."parent_id" IS '父主键';
COMMENT ON COLUMN "public"."blade_dict"."code" IS '字典码';
COMMENT ON COLUMN "public"."blade_dict"."dict_key" IS '字典值';
COMMENT ON COLUMN "public"."blade_dict"."dict_value" IS '字典名称';
COMMENT ON COLUMN "public"."blade_dict"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_dict"."remark" IS '字典备注';
COMMENT ON COLUMN "public"."blade_dict"."is_sealed" IS '是否已封存';
COMMENT ON COLUMN "public"."blade_dict"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_dict" IS '字典表';

-- ----------------------------
-- Table structure for blade_dict_biz
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_dict_biz";
CREATE TABLE "public"."blade_dict_biz" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "code" varchar(255) COLLATE "pg_catalog"."default",
  "dict_key" varchar(255) COLLATE "pg_catalog"."default",
  "dict_value" varchar(255) COLLATE "pg_catalog"."default",
  "sort" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "is_sealed" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_dict_biz"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_dict_biz"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_dict_biz"."parent_id" IS '父主键';
COMMENT ON COLUMN "public"."blade_dict_biz"."code" IS '字典码';
COMMENT ON COLUMN "public"."blade_dict_biz"."dict_key" IS '字典值';
COMMENT ON COLUMN "public"."blade_dict_biz"."dict_value" IS '字典名称';
COMMENT ON COLUMN "public"."blade_dict_biz"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_dict_biz"."remark" IS '字典备注';
COMMENT ON COLUMN "public"."blade_dict_biz"."is_sealed" IS '是否已封存';
COMMENT ON COLUMN "public"."blade_dict_biz"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_dict_biz" IS '业务字典表';

-- ----------------------------
-- Table structure for blade_log_api
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_log_api";
CREATE TABLE "public"."blade_log_api" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "service_id" varchar(32) COLLATE "pg_catalog"."default",
  "server_host" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "env" varchar(255) COLLATE "pg_catalog"."default",
  "type" char(1) COLLATE "pg_catalog"."default",
  "title" varchar(255) COLLATE "pg_catalog"."default",
  "method" varchar(10) COLLATE "pg_catalog"."default",
  "request_uri" varchar(255) COLLATE "pg_catalog"."default",
  "user_agent" varchar(1000) COLLATE "pg_catalog"."default",
  "remote_ip" varchar(255) COLLATE "pg_catalog"."default",
  "method_class" varchar(255) COLLATE "pg_catalog"."default",
  "method_name" varchar(255) COLLATE "pg_catalog"."default",
  "params" text COLLATE "pg_catalog"."default",
  "time" varchar(64) COLLATE "pg_catalog"."default",
  "create_by" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."blade_log_api"."id" IS '编号';
COMMENT ON COLUMN "public"."blade_log_api"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_log_api"."service_id" IS '服务ID';
COMMENT ON COLUMN "public"."blade_log_api"."server_host" IS '服务器名';
COMMENT ON COLUMN "public"."blade_log_api"."server_ip" IS '服务器IP地址';
COMMENT ON COLUMN "public"."blade_log_api"."env" IS '服务器环境';
COMMENT ON COLUMN "public"."blade_log_api"."type" IS '日志类型';
COMMENT ON COLUMN "public"."blade_log_api"."title" IS '日志标题';
COMMENT ON COLUMN "public"."blade_log_api"."method" IS '操作方式';
COMMENT ON COLUMN "public"."blade_log_api"."request_uri" IS '请求URI';
COMMENT ON COLUMN "public"."blade_log_api"."user_agent" IS '用户代理';
COMMENT ON COLUMN "public"."blade_log_api"."remote_ip" IS '操作IP地址';
COMMENT ON COLUMN "public"."blade_log_api"."method_class" IS '方法类';
COMMENT ON COLUMN "public"."blade_log_api"."method_name" IS '方法名';
COMMENT ON COLUMN "public"."blade_log_api"."params" IS '操作提交的数据';
COMMENT ON COLUMN "public"."blade_log_api"."time" IS '执行时间';
COMMENT ON COLUMN "public"."blade_log_api"."create_by" IS '创建者';
COMMENT ON COLUMN "public"."blade_log_api"."create_time" IS '创建时间';
COMMENT ON TABLE "public"."blade_log_api" IS '接口日志表';

-- ----------------------------
-- Table structure for blade_log_error
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_log_error";
CREATE TABLE "public"."blade_log_error" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "service_id" varchar(32) COLLATE "pg_catalog"."default",
  "server_host" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "env" varchar(255) COLLATE "pg_catalog"."default",
  "method" varchar(10) COLLATE "pg_catalog"."default",
  "request_uri" varchar(255) COLLATE "pg_catalog"."default",
  "user_agent" varchar(1000) COLLATE "pg_catalog"."default",
  "stack_trace" text COLLATE "pg_catalog"."default",
  "exception_name" varchar(255) COLLATE "pg_catalog"."default",
  "message" text COLLATE "pg_catalog"."default",
  "line_number" int4,
  "remote_ip" varchar(255) COLLATE "pg_catalog"."default",
  "method_class" varchar(255) COLLATE "pg_catalog"."default",
  "file_name" varchar(1000) COLLATE "pg_catalog"."default",
  "method_name" varchar(255) COLLATE "pg_catalog"."default",
  "params" text COLLATE "pg_catalog"."default",
  "create_by" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."blade_log_error"."id" IS '编号';
COMMENT ON COLUMN "public"."blade_log_error"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_log_error"."service_id" IS '服务ID';
COMMENT ON COLUMN "public"."blade_log_error"."server_host" IS '服务器名';
COMMENT ON COLUMN "public"."blade_log_error"."server_ip" IS '服务器IP地址';
COMMENT ON COLUMN "public"."blade_log_error"."env" IS '系统环境';
COMMENT ON COLUMN "public"."blade_log_error"."method" IS '操作方式';
COMMENT ON COLUMN "public"."blade_log_error"."request_uri" IS '请求URI';
COMMENT ON COLUMN "public"."blade_log_error"."user_agent" IS '用户代理';
COMMENT ON COLUMN "public"."blade_log_error"."stack_trace" IS '堆栈';
COMMENT ON COLUMN "public"."blade_log_error"."exception_name" IS '异常名';
COMMENT ON COLUMN "public"."blade_log_error"."message" IS '异常信息';
COMMENT ON COLUMN "public"."blade_log_error"."line_number" IS '错误行数';
COMMENT ON COLUMN "public"."blade_log_error"."remote_ip" IS '操作IP地址';
COMMENT ON COLUMN "public"."blade_log_error"."method_class" IS '方法类';
COMMENT ON COLUMN "public"."blade_log_error"."file_name" IS '文件名';
COMMENT ON COLUMN "public"."blade_log_error"."method_name" IS '方法名';
COMMENT ON COLUMN "public"."blade_log_error"."params" IS '操作提交的数据';
COMMENT ON COLUMN "public"."blade_log_error"."create_by" IS '创建者';
COMMENT ON COLUMN "public"."blade_log_error"."create_time" IS '创建时间';
COMMENT ON TABLE "public"."blade_log_error" IS '错误日志表';

-- ----------------------------
-- Table structure for blade_log_usual
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_log_usual";
CREATE TABLE "public"."blade_log_usual" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "service_id" varchar(32) COLLATE "pg_catalog"."default",
  "server_host" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "env" varchar(255) COLLATE "pg_catalog"."default",
  "log_level" varchar(10) COLLATE "pg_catalog"."default",
  "log_id" varchar(100) COLLATE "pg_catalog"."default",
  "log_data" text COLLATE "pg_catalog"."default",
  "method" varchar(10) COLLATE "pg_catalog"."default",
  "request_uri" varchar(255) COLLATE "pg_catalog"."default",
  "remote_ip" varchar(255) COLLATE "pg_catalog"."default",
  "method_class" varchar(255) COLLATE "pg_catalog"."default",
  "method_name" varchar(255) COLLATE "pg_catalog"."default",
  "user_agent" varchar(1000) COLLATE "pg_catalog"."default",
  "params" text COLLATE "pg_catalog"."default",
  "create_by" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."blade_log_usual"."id" IS '编号';
COMMENT ON COLUMN "public"."blade_log_usual"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_log_usual"."service_id" IS '服务ID';
COMMENT ON COLUMN "public"."blade_log_usual"."server_host" IS '服务器名';
COMMENT ON COLUMN "public"."blade_log_usual"."server_ip" IS '服务器IP地址';
COMMENT ON COLUMN "public"."blade_log_usual"."env" IS '系统环境';
COMMENT ON COLUMN "public"."blade_log_usual"."log_level" IS '日志级别';
COMMENT ON COLUMN "public"."blade_log_usual"."log_id" IS '日志业务id';
COMMENT ON COLUMN "public"."blade_log_usual"."log_data" IS '日志数据';
COMMENT ON COLUMN "public"."blade_log_usual"."method" IS '操作方式';
COMMENT ON COLUMN "public"."blade_log_usual"."request_uri" IS '请求URI';
COMMENT ON COLUMN "public"."blade_log_usual"."remote_ip" IS '操作IP地址';
COMMENT ON COLUMN "public"."blade_log_usual"."method_class" IS '方法类';
COMMENT ON COLUMN "public"."blade_log_usual"."method_name" IS '方法名';
COMMENT ON COLUMN "public"."blade_log_usual"."user_agent" IS '用户代理';
COMMENT ON COLUMN "public"."blade_log_usual"."params" IS '操作提交的数据';
COMMENT ON COLUMN "public"."blade_log_usual"."create_by" IS '创建者';
COMMENT ON COLUMN "public"."blade_log_usual"."create_time" IS '创建时间';
COMMENT ON TABLE "public"."blade_log_usual" IS '通用日志表';

-- ----------------------------
-- Table structure for blade_menu
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_menu";
CREATE TABLE "public"."blade_menu" (
  "id" int8 NOT NULL,
  "parent_id" int8,
  "code" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "alias" varchar(255) COLLATE "pg_catalog"."default",
  "path" varchar(255) COLLATE "pg_catalog"."default",
  "source" varchar(255) COLLATE "pg_catalog"."default",
  "sort" int4,
  "category" int4,
  "action" int4,
  "is_open" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_menu"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_menu"."parent_id" IS '父级菜单';
COMMENT ON COLUMN "public"."blade_menu"."code" IS '菜单编号';
COMMENT ON COLUMN "public"."blade_menu"."name" IS '菜单名称';
COMMENT ON COLUMN "public"."blade_menu"."alias" IS '菜单别名';
COMMENT ON COLUMN "public"."blade_menu"."path" IS '请求地址';
COMMENT ON COLUMN "public"."blade_menu"."source" IS '菜单资源';
COMMENT ON COLUMN "public"."blade_menu"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_menu"."category" IS '菜单类型';
COMMENT ON COLUMN "public"."blade_menu"."action" IS '操作按钮类型';
COMMENT ON COLUMN "public"."blade_menu"."is_open" IS '是否打开新页面';
COMMENT ON COLUMN "public"."blade_menu"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_menu"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_menu" IS '菜单表';

-- ----------------------------
-- Table structure for blade_notice
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_notice";
CREATE TABLE "public"."blade_notice" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "title" varchar(255) COLLATE "pg_catalog"."default",
  "category" int4,
  "release_time" timestamp(6),
  "content" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_notice"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_notice"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_notice"."title" IS '标题';
COMMENT ON COLUMN "public"."blade_notice"."category" IS '类型';
COMMENT ON COLUMN "public"."blade_notice"."release_time" IS '发布时间';
COMMENT ON COLUMN "public"."blade_notice"."content" IS '内容';
COMMENT ON COLUMN "public"."blade_notice"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_notice"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_notice"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_notice"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_notice"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_notice"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_notice"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_notice" IS '通知公告表';

-- ----------------------------
-- Table structure for blade_oss
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_oss";
CREATE TABLE "public"."blade_oss" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "category" int4,
  "oss_code" varchar(32) COLLATE "pg_catalog"."default",
  "endpoint" varchar(255) COLLATE "pg_catalog"."default",
  "access_key" varchar(255) COLLATE "pg_catalog"."default",
  "secret_key" varchar(255) COLLATE "pg_catalog"."default",
  "bucket_name" varchar(255) COLLATE "pg_catalog"."default",
  "app_id" varchar(255) COLLATE "pg_catalog"."default",
  "region" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_oss"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_oss"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_oss"."category" IS '分类';
COMMENT ON COLUMN "public"."blade_oss"."oss_code" IS '资源编号';
COMMENT ON COLUMN "public"."blade_oss"."endpoint" IS '资源地址';
COMMENT ON COLUMN "public"."blade_oss"."access_key" IS 'accessKey';
COMMENT ON COLUMN "public"."blade_oss"."secret_key" IS 'secretKey';
COMMENT ON COLUMN "public"."blade_oss"."bucket_name" IS '空间名';
COMMENT ON COLUMN "public"."blade_oss"."app_id" IS '应用ID';
COMMENT ON COLUMN "public"."blade_oss"."region" IS '地域简称';
COMMENT ON COLUMN "public"."blade_oss"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_oss"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_oss"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_oss"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_oss"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_oss"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_oss"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_oss"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_oss" IS '对象存储表';

-- ----------------------------
-- Table structure for blade_param
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_param";
CREATE TABLE "public"."blade_param" (
  "id" int8 NOT NULL,
  "param_name" varchar(255) COLLATE "pg_catalog"."default",
  "param_key" varchar(255) COLLATE "pg_catalog"."default",
  "param_value" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_param"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_param"."param_name" IS '参数名';
COMMENT ON COLUMN "public"."blade_param"."param_key" IS '参数键';
COMMENT ON COLUMN "public"."blade_param"."param_value" IS '参数值';
COMMENT ON COLUMN "public"."blade_param"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_param"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_param"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_param"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_param"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_param"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_param"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_param"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_param" IS '参数表';

-- ----------------------------
-- Table structure for blade_post
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_post";
CREATE TABLE "public"."blade_post" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "category" int4,
  "post_code" varchar(12) COLLATE "pg_catalog"."default",
  "post_name" varchar(64) COLLATE "pg_catalog"."default",
  "sort" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_post"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_post"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_post"."category" IS '岗位类型';
COMMENT ON COLUMN "public"."blade_post"."post_code" IS '岗位编号';
COMMENT ON COLUMN "public"."blade_post"."post_name" IS '岗位名称';
COMMENT ON COLUMN "public"."blade_post"."sort" IS '岗位排序';
COMMENT ON COLUMN "public"."blade_post"."remark" IS '岗位排序';
COMMENT ON COLUMN "public"."blade_post"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_post"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_post"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_post"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_post"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_post"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_post"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_post" IS '岗位表';

-- ----------------------------
-- Table structure for blade_process_leave
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_process_leave";
CREATE TABLE "public"."blade_process_leave" (
  "id" int8 NOT NULL,
  "process_definition_id" varchar(64) COLLATE "pg_catalog"."default",
  "process_instance_id" varchar(64) COLLATE "pg_catalog"."default",
  "start_time" timestamp(6),
  "end_time" timestamp(6),
  "reason" varchar(255) COLLATE "pg_catalog"."default",
  "task_user" varchar(255) COLLATE "pg_catalog"."default",
  "apply_time" timestamp(6),
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_process_leave"."id" IS '编号';
COMMENT ON COLUMN "public"."blade_process_leave"."process_definition_id" IS '流程定义主键';
COMMENT ON COLUMN "public"."blade_process_leave"."process_instance_id" IS '流程实例主键';
COMMENT ON COLUMN "public"."blade_process_leave"."start_time" IS '开始时间';
COMMENT ON COLUMN "public"."blade_process_leave"."end_time" IS '结束时间';
COMMENT ON COLUMN "public"."blade_process_leave"."reason" IS '请假理由';
COMMENT ON COLUMN "public"."blade_process_leave"."task_user" IS '第一级审批人';
COMMENT ON COLUMN "public"."blade_process_leave"."apply_time" IS '申请时间';
COMMENT ON COLUMN "public"."blade_process_leave"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_process_leave"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_process_leave"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_process_leave"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_process_leave"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_process_leave"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_process_leave"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_process_leave" IS '流程请假业务表';

-- ----------------------------
-- Table structure for blade_region
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_region";
CREATE TABLE "public"."blade_region" (
  "code" varchar(12) COLLATE "pg_catalog"."default" NOT NULL,
  "parent_code" varchar(12) COLLATE "pg_catalog"."default",
  "ancestors" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(32) COLLATE "pg_catalog"."default",
  "province_code" varchar(12) COLLATE "pg_catalog"."default",
  "province_name" varchar(32) COLLATE "pg_catalog"."default",
  "city_code" varchar(12) COLLATE "pg_catalog"."default",
  "city_name" varchar(32) COLLATE "pg_catalog"."default",
  "district_code" varchar(12) COLLATE "pg_catalog"."default",
  "district_name" varchar(32) COLLATE "pg_catalog"."default",
  "town_code" varchar(12) COLLATE "pg_catalog"."default",
  "town_name" varchar(32) COLLATE "pg_catalog"."default",
  "village_code" varchar(12) COLLATE "pg_catalog"."default",
  "village_name" varchar(32) COLLATE "pg_catalog"."default",
  "region_level" int4,
  "sort" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_region"."code" IS '区划编号';
COMMENT ON COLUMN "public"."blade_region"."parent_code" IS '父区划编号';
COMMENT ON COLUMN "public"."blade_region"."ancestors" IS '祖区划编号';
COMMENT ON COLUMN "public"."blade_region"."name" IS '区划名称';
COMMENT ON COLUMN "public"."blade_region"."province_code" IS '省级区划编号';
COMMENT ON COLUMN "public"."blade_region"."province_name" IS '省级名称';
COMMENT ON COLUMN "public"."blade_region"."city_code" IS '市级区划编号';
COMMENT ON COLUMN "public"."blade_region"."city_name" IS '市级名称';
COMMENT ON COLUMN "public"."blade_region"."district_code" IS '区级区划编号';
COMMENT ON COLUMN "public"."blade_region"."district_name" IS '区级名称';
COMMENT ON COLUMN "public"."blade_region"."town_code" IS '镇级区划编号';
COMMENT ON COLUMN "public"."blade_region"."town_name" IS '镇级名称';
COMMENT ON COLUMN "public"."blade_region"."village_code" IS '村级区划编号';
COMMENT ON COLUMN "public"."blade_region"."village_name" IS '村级名称';
COMMENT ON COLUMN "public"."blade_region"."region_level" IS '层级';
COMMENT ON COLUMN "public"."blade_region"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_region"."remark" IS '备注';
COMMENT ON TABLE "public"."blade_region" IS '行政区划表';

-- ----------------------------
-- Table structure for blade_report_file
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_report_file";
CREATE TABLE "public"."blade_report_file" (
  "id" int8 NOT NULL,
  "name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "content" bytea,
  "create_time" timestamp(6) NOT NULL,
  "update_time" timestamp(6) NOT NULL,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_report_file"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_report_file"."name" IS '文件名';
COMMENT ON COLUMN "public"."blade_report_file"."content" IS '文件内容';
COMMENT ON COLUMN "public"."blade_report_file"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_report_file"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."blade_report_file"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_report_file" IS '报表文件表';

-- ----------------------------
-- Table structure for blade_role
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_role";
CREATE TABLE "public"."blade_role" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "role_name" varchar(255) COLLATE "pg_catalog"."default",
  "sort" int4,
  "role_alias" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_role"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_role"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_role"."parent_id" IS '父主键';
COMMENT ON COLUMN "public"."blade_role"."role_name" IS '角色名';
COMMENT ON COLUMN "public"."blade_role"."sort" IS '排序';
COMMENT ON COLUMN "public"."blade_role"."role_alias" IS '角色别名';
COMMENT ON COLUMN "public"."blade_role"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_role" IS '角色表';

-- ----------------------------
-- Table structure for blade_role_menu
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_role_menu";
CREATE TABLE "public"."blade_role_menu" (
  "id" int8 NOT NULL,
  "menu_id" int8,
  "role_id" int8
)
;
COMMENT ON COLUMN "public"."blade_role_menu"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_role_menu"."menu_id" IS '菜单id';
COMMENT ON COLUMN "public"."blade_role_menu"."role_id" IS '角色id';
COMMENT ON TABLE "public"."blade_role_menu" IS '角色菜单关联表';

-- ----------------------------
-- Table structure for blade_role_scope
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_role_scope";
CREATE TABLE "public"."blade_role_scope" (
  "id" int8 NOT NULL,
  "scope_category" int4,
  "scope_id" int8,
  "role_id" int8
)
;
COMMENT ON COLUMN "public"."blade_role_scope"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_role_scope"."scope_category" IS '权限类型(1:数据权限、2:接口权限)';
COMMENT ON COLUMN "public"."blade_role_scope"."scope_id" IS '权限id';
COMMENT ON COLUMN "public"."blade_role_scope"."role_id" IS '角色id';
COMMENT ON TABLE "public"."blade_role_scope" IS '角色数据权限关联表';

-- ----------------------------
-- Table structure for blade_scope_api
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_scope_api";
CREATE TABLE "public"."blade_scope_api" (
  "id" int8 NOT NULL,
  "menu_id" int8,
  "resource_code" varchar(255) COLLATE "pg_catalog"."default",
  "scope_name" varchar(255) COLLATE "pg_catalog"."default",
  "scope_path" varchar(255) COLLATE "pg_catalog"."default",
  "scope_type" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_scope_api"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_scope_api"."menu_id" IS '菜单主键';
COMMENT ON COLUMN "public"."blade_scope_api"."resource_code" IS '资源编号';
COMMENT ON COLUMN "public"."blade_scope_api"."scope_name" IS '接口权限名';
COMMENT ON COLUMN "public"."blade_scope_api"."scope_path" IS '接口权限地址';
COMMENT ON COLUMN "public"."blade_scope_api"."scope_type" IS '接口权限类型';
COMMENT ON COLUMN "public"."blade_scope_api"."remark" IS '接口权限备注';
COMMENT ON COLUMN "public"."blade_scope_api"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_scope_api"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_scope_api"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_scope_api"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_scope_api"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_scope_api"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_scope_api"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_scope_api" IS '接口权限表';

-- ----------------------------
-- Table structure for blade_scope_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_scope_data";
CREATE TABLE "public"."blade_scope_data" (
  "id" int8 NOT NULL,
  "menu_id" int8,
  "resource_code" varchar(255) COLLATE "pg_catalog"."default",
  "scope_name" varchar(255) COLLATE "pg_catalog"."default",
  "scope_field" varchar(255) COLLATE "pg_catalog"."default",
  "scope_class" varchar(500) COLLATE "pg_catalog"."default",
  "scope_column" varchar(255) COLLATE "pg_catalog"."default",
  "scope_type" int4,
  "scope_value" varchar(2000) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_scope_data"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_scope_data"."menu_id" IS '菜单主键';
COMMENT ON COLUMN "public"."blade_scope_data"."resource_code" IS '资源编号';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_name" IS '数据权限名称';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_field" IS '数据权限字段';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_class" IS '数据权限类名';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_column" IS '数据权限字段';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_type" IS '数据权限类型';
COMMENT ON COLUMN "public"."blade_scope_data"."scope_value" IS '数据权限值域';
COMMENT ON COLUMN "public"."blade_scope_data"."remark" IS '数据权限备注';
COMMENT ON COLUMN "public"."blade_scope_data"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_scope_data"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_scope_data"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_scope_data"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_scope_data"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_scope_data"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_scope_data"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_scope_data" IS '数据权限表';

-- ----------------------------
-- Table structure for blade_sms
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_sms";
CREATE TABLE "public"."blade_sms" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "category" int4,
  "sms_code" varchar(12) COLLATE "pg_catalog"."default",
  "template_id" varchar(64) COLLATE "pg_catalog"."default",
  "access_key" varchar(255) COLLATE "pg_catalog"."default",
  "secret_key" varchar(255) COLLATE "pg_catalog"."default",
  "region_id" varchar(255) COLLATE "pg_catalog"."default",
  "sign_name" varchar(64) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_sms"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_sms"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_sms"."category" IS '分类';
COMMENT ON COLUMN "public"."blade_sms"."sms_code" IS '资源编号';
COMMENT ON COLUMN "public"."blade_sms"."template_id" IS '模板ID';
COMMENT ON COLUMN "public"."blade_sms"."access_key" IS 'accessKey';
COMMENT ON COLUMN "public"."blade_sms"."secret_key" IS 'secretKey';
COMMENT ON COLUMN "public"."blade_sms"."region_id" IS 'regionId';
COMMENT ON COLUMN "public"."blade_sms"."sign_name" IS '短信签名';
COMMENT ON COLUMN "public"."blade_sms"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_sms"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_sms"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_sms"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_sms"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_sms"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_sms"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_sms"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_sms" IS '短信配置表';

-- ----------------------------
-- Table structure for blade_tenant
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_tenant";
CREATE TABLE "public"."blade_tenant" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "tenant_name" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "domain" varchar(255) COLLATE "pg_catalog"."default",
  "background_url" varchar(1000) COLLATE "pg_catalog"."default",
  "linkman" varchar(20) COLLATE "pg_catalog"."default",
  "contact_number" varchar(20) COLLATE "pg_catalog"."default",
  "address" varchar(255) COLLATE "pg_catalog"."default",
  "account_number" int2 DEFAULT '-1'::integer,
  "expire_time" timestamp(6),
  "datasource_id" int8,
  "license_key" varchar(1000) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_tenant"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_tenant"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_tenant"."tenant_name" IS '租户名称';
COMMENT ON COLUMN "public"."blade_tenant"."domain" IS '域名地址';
COMMENT ON COLUMN "public"."blade_tenant"."background_url" IS '系统背景';
COMMENT ON COLUMN "public"."blade_tenant"."linkman" IS '联系人';
COMMENT ON COLUMN "public"."blade_tenant"."contact_number" IS '联系电话';
COMMENT ON COLUMN "public"."blade_tenant"."address" IS '联系地址';
COMMENT ON COLUMN "public"."blade_tenant"."account_number" IS '账号额度';
COMMENT ON COLUMN "public"."blade_tenant"."expire_time" IS '过期时间';
COMMENT ON COLUMN "public"."blade_tenant"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "public"."blade_tenant"."license_key" IS '授权码';
COMMENT ON COLUMN "public"."blade_tenant"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_tenant"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_tenant"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_tenant"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_tenant"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_tenant"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_tenant"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_tenant" IS '租户表';

-- ----------------------------
-- Table structure for blade_top_menu
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_top_menu";
CREATE TABLE "public"."blade_top_menu" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "code" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "source" varchar(255) COLLATE "pg_catalog"."default",
  "sort" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."blade_top_menu"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_top_menu"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."blade_top_menu"."code" IS '顶部菜单编号';
COMMENT ON COLUMN "public"."blade_top_menu"."name" IS '顶部菜单名';
COMMENT ON COLUMN "public"."blade_top_menu"."source" IS '顶部菜单资源';
COMMENT ON COLUMN "public"."blade_top_menu"."sort" IS '顶部菜单排序';
COMMENT ON COLUMN "public"."blade_top_menu"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_top_menu"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_top_menu"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_top_menu"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_top_menu"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_top_menu"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_top_menu"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."blade_top_menu" IS '顶部菜单表';

-- ----------------------------
-- Table structure for blade_top_menu_setting
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_top_menu_setting";
CREATE TABLE "public"."blade_top_menu_setting" (
  "id" int8 NOT NULL,
  "top_menu_id" int8,
  "menu_id" int8
)
;
COMMENT ON COLUMN "public"."blade_top_menu_setting"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_top_menu_setting"."top_menu_id" IS '顶部菜单主键';
COMMENT ON COLUMN "public"."blade_top_menu_setting"."menu_id" IS '菜单主键';
COMMENT ON TABLE "public"."blade_top_menu_setting" IS '顶部菜单配置表';

-- ----------------------------
-- Table structure for blade_user
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user";
CREATE TABLE "public"."blade_user" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "code" varchar(12) COLLATE "pg_catalog"."default",
  "user_type" int2,
  "account" varchar(45) COLLATE "pg_catalog"."default",
  "password" varchar(45) COLLATE "pg_catalog"."default",
  "name" varchar(20) COLLATE "pg_catalog"."default",
  "real_name" varchar(10) COLLATE "pg_catalog"."default",
  "avatar" varchar(500) COLLATE "pg_catalog"."default",
  "email" varchar(45) COLLATE "pg_catalog"."default",
  "phone" varchar(45) COLLATE "pg_catalog"."default",
  "birthday" timestamp(6),
  "sex" int2,
  "role_id" varchar(1000) COLLATE "pg_catalog"."default",
  "dept_id" varchar(1000) COLLATE "pg_catalog"."default",
  "post_id" varchar(1000) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "duty_ids" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_user"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_user"."code" IS '用户编号';
COMMENT ON COLUMN "public"."blade_user"."user_type" IS '用户平台';
COMMENT ON COLUMN "public"."blade_user"."account" IS '账号';
COMMENT ON COLUMN "public"."blade_user"."password" IS '密码';
COMMENT ON COLUMN "public"."blade_user"."name" IS '昵称';
COMMENT ON COLUMN "public"."blade_user"."real_name" IS '真名';
COMMENT ON COLUMN "public"."blade_user"."avatar" IS '头像';
COMMENT ON COLUMN "public"."blade_user"."email" IS '邮箱';
COMMENT ON COLUMN "public"."blade_user"."phone" IS '手机';
COMMENT ON COLUMN "public"."blade_user"."birthday" IS '生日';
COMMENT ON COLUMN "public"."blade_user"."sex" IS '性别';
COMMENT ON COLUMN "public"."blade_user"."role_id" IS '角色id';
COMMENT ON COLUMN "public"."blade_user"."dept_id" IS '部门id';
COMMENT ON COLUMN "public"."blade_user"."post_id" IS '岗位id';
COMMENT ON COLUMN "public"."blade_user"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."blade_user"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."blade_user"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."blade_user"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."blade_user"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."blade_user"."status" IS '状态';
COMMENT ON COLUMN "public"."blade_user"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."blade_user"."duty_ids" IS '责任区ID，逗号分隔';
COMMENT ON TABLE "public"."blade_user" IS '用户表';

-- ----------------------------
-- Table structure for blade_user_app
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user_app";
CREATE TABLE "public"."blade_user_app" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "user_ext" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_user_app"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user_app"."user_id" IS '用户ID';
COMMENT ON COLUMN "public"."blade_user_app"."user_ext" IS '用户拓展信息';
COMMENT ON TABLE "public"."blade_user_app" IS '用户平台拓展表';

-- ----------------------------
-- Table structure for blade_user_dept
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user_dept";
CREATE TABLE "public"."blade_user_dept" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "dept_id" int8
)
;
COMMENT ON COLUMN "public"."blade_user_dept"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user_dept"."user_id" IS '用户ID';
COMMENT ON COLUMN "public"."blade_user_dept"."dept_id" IS '部门ID';
COMMENT ON TABLE "public"."blade_user_dept" IS '用户部门表';

-- ----------------------------
-- Table structure for blade_user_oauth
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user_oauth";
CREATE TABLE "public"."blade_user_oauth" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "uuid" varchar(64) COLLATE "pg_catalog"."default",
  "user_id" int8,
  "username" varchar(32) COLLATE "pg_catalog"."default",
  "nickname" varchar(64) COLLATE "pg_catalog"."default",
  "avatar" varchar(1000) COLLATE "pg_catalog"."default",
  "blog" varchar(50) COLLATE "pg_catalog"."default",
  "company" varchar(255) COLLATE "pg_catalog"."default",
  "location" varchar(255) COLLATE "pg_catalog"."default",
  "email" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "gender" varchar(16) COLLATE "pg_catalog"."default",
  "source" varchar(16) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_user_oauth"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user_oauth"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."blade_user_oauth"."uuid" IS '第三方系统用户ID';
COMMENT ON COLUMN "public"."blade_user_oauth"."user_id" IS '用户ID';
COMMENT ON COLUMN "public"."blade_user_oauth"."username" IS '账号';
COMMENT ON COLUMN "public"."blade_user_oauth"."nickname" IS '用户名';
COMMENT ON COLUMN "public"."blade_user_oauth"."avatar" IS '头像';
COMMENT ON COLUMN "public"."blade_user_oauth"."blog" IS '应用主页';
COMMENT ON COLUMN "public"."blade_user_oauth"."company" IS '公司名';
COMMENT ON COLUMN "public"."blade_user_oauth"."location" IS '地址';
COMMENT ON COLUMN "public"."blade_user_oauth"."email" IS '邮件';
COMMENT ON COLUMN "public"."blade_user_oauth"."remark" IS '备注';
COMMENT ON COLUMN "public"."blade_user_oauth"."gender" IS '性别';
COMMENT ON COLUMN "public"."blade_user_oauth"."source" IS '来源';
COMMENT ON TABLE "public"."blade_user_oauth" IS '用户第三方认证表';

-- ----------------------------
-- Table structure for blade_user_other
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user_other";
CREATE TABLE "public"."blade_user_other" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "user_ext" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_user_other"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user_other"."user_id" IS '用户ID';
COMMENT ON COLUMN "public"."blade_user_other"."user_ext" IS '用户拓展信息';
COMMENT ON TABLE "public"."blade_user_other" IS '用户平台拓展表';

-- ----------------------------
-- Table structure for blade_user_web
-- ----------------------------
DROP TABLE IF EXISTS "public"."blade_user_web";
CREATE TABLE "public"."blade_user_web" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "user_ext" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."blade_user_web"."id" IS '主键';
COMMENT ON COLUMN "public"."blade_user_web"."user_id" IS '用户ID';
COMMENT ON COLUMN "public"."blade_user_web"."user_ext" IS '用户拓展信息';
COMMENT ON TABLE "public"."blade_user_web" IS '用户平台拓展表';

-- ----------------------------
-- Table structure for slmp_ac_box_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_ac_box_current_data";
CREATE TABLE "public"."slmp_ac_box_current_data" (
  "id" int8 NOT NULL,
  "ac_box_id" int8,
  "collect_time" timestamp(6),
  "km1_status" int4,
  "km2_status" int4,
  "km3_status" int4,
  "front_door_status" int4,
  "auto" int4,
  "smoke_alarm" int4,
  "water_sensor" int4,
  "surge_protection" int4,
  "total_power" numeric(16,2),
  "active_power_a" numeric(16,2),
  "active_power_b" numeric(16,2),
  "active_power_c" numeric(16,2),
  "voltage_a" numeric(16,2),
  "voltage_b" numeric(16,2),
  "voltage_c" numeric(16,2),
  "current_a" numeric(16,2),
  "current_b" numeric(16,2),
  "current_c" numeric(16,2),
  "k1_voltage" numeric(16,2),
  "k2_voltage" numeric(16,2),
  "k3_voltage" numeric(16,2),
  "k4_voltage" numeric(16,2),
  "k1_status" int4,
  "k2_status" int4,
  "k3_status" int4,
  "k4_status" int4,
  "temperature" numeric(16,2),
  "humidity" numeric(16,2),
  "door_sensor_status" int4,
  "k5_voltage" numeric(16,2),
  "k5_status" int4,
  "k1_power" numeric(16,2),
  "k2_power" numeric(16,2),
  "k3_power" numeric(16,2),
  "k4_power" numeric(16,2),
  "k5_power" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."ac_box_id" IS '交流配电箱id';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."km1_status" IS 'KM1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."km2_status" IS 'KM2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."km3_status" IS 'KM3状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."front_door_status" IS '前门状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."auto" IS '手自动 0手动 1自动';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."smoke_alarm" IS '烟雾报警 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."water_sensor" IS '水浸状态 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."surge_protection" IS '浪涌保护 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."total_power" IS '总电能';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."active_power_a" IS 'A相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."active_power_b" IS 'B相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."active_power_c" IS 'C相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."voltage_a" IS 'A相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."voltage_b" IS 'B相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."voltage_c" IS 'C相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."current_a" IS 'A相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."current_b" IS 'B相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."current_c" IS 'C相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k1_voltage" IS '空开1电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k2_voltage" IS '空开2电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k3_voltage" IS '空开3电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k4_voltage" IS '空开4电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k1_status" IS '空开1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k2_status" IS '空开2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k3_status" IS '空开3状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k4_status" IS '空开4状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."temperature" IS '温度';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."humidity" IS '湿度';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."door_sensor_status" IS '门磁 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k5_voltage" IS '空开5电压';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k5_status" IS '空开5状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k1_power" IS '空开1功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k2_power" IS '空开2功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k3_power" IS '空开3功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k4_power" IS '空开4功率';
COMMENT ON COLUMN "public"."slmp_ac_box_current_data"."k5_power" IS '空开5功率';
COMMENT ON TABLE "public"."slmp_ac_box_current_data" IS '交流柜实时数据';

-- ----------------------------
-- Table structure for slmp_ac_box_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_ac_box_device";
CREATE TABLE "public"."slmp_ac_box_device" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default",
  "term_addr" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_ac_box_device"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_ac_box_device"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_ac_box_device"."model" IS '交流配电箱型号';
COMMENT ON COLUMN "public"."slmp_ac_box_device"."term_addr" IS '地址码';

-- ----------------------------
-- Table structure for slmp_ac_box_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_ac_box_history_data";
CREATE TABLE "public"."slmp_ac_box_history_data" (
  "id" int8 NOT NULL,
  "ac_box_id" int8,
  "collect_time" timestamp(6),
  "km1_status" int4,
  "km2_status" int4,
  "km3_status" int4,
  "front_door_status" int4,
  "auto" int4,
  "smoke_alarm" int4,
  "water_sensor" int4,
  "surge_protection" int4,
  "total_power" numeric(16,2),
  "active_power_a" numeric(16,2),
  "active_power_b" numeric(16,2),
  "active_power_c" numeric(16,2),
  "voltage_a" numeric(16,2),
  "voltage_b" numeric(16,2),
  "voltage_c" numeric(16,2),
  "current_a" numeric(16,2),
  "current_b" numeric(16,2),
  "current_c" numeric(16,2),
  "k1_voltage" numeric(16,2),
  "k2_voltage" numeric(16,2),
  "k3_voltage" numeric(16,2),
  "k4_voltage" numeric(16,2),
  "k1_status" int4,
  "k2_status" int4,
  "k3_status" int4,
  "k4_status" int4,
  "temperature" numeric(16,2),
  "humidity" numeric(16,2),
  "door_sensor_status" int4,
  "k5_voltage" numeric(16,2),
  "k5_status" int4,
  "k1_power" numeric(16,2),
  "k2_power" numeric(16,2),
  "k3_power" numeric(16,2),
  "k4_power" numeric(16,2),
  "k5_power" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."ac_box_id" IS '交流配电箱id';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."km1_status" IS 'KM1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."km2_status" IS 'KM2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."km3_status" IS 'KM3状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."front_door_status" IS '前门状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."auto" IS '手自动 0手动 1自动';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."smoke_alarm" IS '烟雾报警 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."water_sensor" IS '水浸状态 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."surge_protection" IS '浪涌保护 0正常 1报警';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."total_power" IS '总电能';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."active_power_a" IS 'A相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."active_power_b" IS 'B相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."active_power_c" IS 'C相有功功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."voltage_a" IS 'A相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."voltage_b" IS 'B相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."voltage_c" IS 'C相电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."current_a" IS 'A相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."current_b" IS 'B相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."current_c" IS 'C相电流';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k1_voltage" IS '空开1电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k2_voltage" IS '空开2电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k3_voltage" IS '空开3电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k4_voltage" IS '空开4电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k1_status" IS '空开1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k2_status" IS '空开2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k3_status" IS '空开3状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k4_status" IS '空开4状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."temperature" IS '温度';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."humidity" IS '湿度';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."door_sensor_status" IS '门磁 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k5_voltage" IS '空开5电压';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k5_status" IS '空开5状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k1_power" IS '空开1功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k2_power" IS '空开2功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k3_power" IS '空开3功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k4_power" IS '空开4功率';
COMMENT ON COLUMN "public"."slmp_ac_box_history_data"."k5_power" IS '空开5功率';
COMMENT ON TABLE "public"."slmp_ac_box_history_data" IS '交流柜实时数据';

-- ----------------------------
-- Table structure for slmp_ac_box_total_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_ac_box_total_data";
CREATE TABLE "public"."slmp_ac_box_total_data" (
  "id" int8 NOT NULL,
  "create_time" timestamp(6),
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "total_power" numeric(16,2),
  "ac_box_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_ac_box_total_data"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_ac_box_total_data"."total_power" IS '功率';
COMMENT ON COLUMN "public"."slmp_ac_box_total_data"."ac_box_id" IS '交流柜id';

-- ----------------------------
-- Table structure for slmp_ac_switch_box
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_ac_switch_box";
CREATE TABLE "public"."slmp_ac_switch_box" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;

-- ----------------------------
-- Table structure for slmp_alarm
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_alarm";
CREATE TABLE "public"."slmp_alarm" (
  "id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "device_id" int8,
  "device_type" int4,
  "alarm_msg" varchar(255) COLLATE "pg_catalog"."default",
  "first_time" timestamp(6),
  "recover_time" timestamp(6),
  "status" int4,
  "code" int4,
  "last_time" timestamp(6),
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "device_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "opt" int4,
  "confirm_time" timestamp(6),
  "confirm_user_id" int8,
  "confirm_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "device_sn" varchar(255) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "note" varchar(255) COLLATE "pg_catalog"."default",
  "alarm_level" int4,
  "facility_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_alarm"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_alarm"."device_id" IS '设备id';
COMMENT ON COLUMN "public"."slmp_alarm"."device_type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_alarm"."alarm_msg" IS '告警信息';
COMMENT ON COLUMN "public"."slmp_alarm"."first_time" IS '第一次发生时间';
COMMENT ON COLUMN "public"."slmp_alarm"."recover_time" IS '告警恢复时间';
COMMENT ON COLUMN "public"."slmp_alarm"."status" IS '告警状态 1新增 2恢复';
COMMENT ON COLUMN "public"."slmp_alarm"."code" IS '告警码';
COMMENT ON COLUMN "public"."slmp_alarm"."last_time" IS '最后一次发生时间';
COMMENT ON COLUMN "public"."slmp_alarm"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_alarm"."device_name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_alarm"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_alarm"."opt" IS '操作';
COMMENT ON COLUMN "public"."slmp_alarm"."confirm_time" IS '确认时间';
COMMENT ON COLUMN "public"."slmp_alarm"."confirm_user_id" IS '确认人ID';
COMMENT ON COLUMN "public"."slmp_alarm"."confirm_user_name" IS '确认人名称';
COMMENT ON COLUMN "public"."slmp_alarm"."device_sn" IS '设备编号';
COMMENT ON COLUMN "public"."slmp_alarm"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_alarm"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_alarm"."note" IS '处理意见';
COMMENT ON COLUMN "public"."slmp_alarm"."alarm_level" IS '告警级别';
COMMENT ON COLUMN "public"."slmp_alarm"."facility_id" IS '所属设施ID，告警统计需要';
COMMENT ON TABLE "public"."slmp_alarm" IS '用户表';

-- ----------------------------
-- Table structure for slmp_alarm_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_alarm_config";
CREATE TABLE "public"."slmp_alarm_config" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "alarm_type" int4,
  "alarm_field" varchar(64) COLLATE "pg_catalog"."default",
  "alarm_value" varchar(64) COLLATE "pg_catalog"."default",
  "is_deleted" int4 DEFAULT 0,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" varchar(32) COLLATE "pg_catalog"."default",
  "alarm_level" int4 DEFAULT 3
)
;
COMMENT ON COLUMN "public"."slmp_alarm_config"."id" IS 'ID';
COMMENT ON COLUMN "public"."slmp_alarm_config"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_alarm_config"."alarm_type" IS '告警类型';
COMMENT ON COLUMN "public"."slmp_alarm_config"."alarm_field" IS '告警实例';
COMMENT ON COLUMN "public"."slmp_alarm_config"."alarm_value" IS '告警阈值';
COMMENT ON COLUMN "public"."slmp_alarm_config"."is_deleted" IS '是否删除';
COMMENT ON COLUMN "public"."slmp_alarm_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_alarm_config"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_alarm_config"."alarm_level" IS '告警级别';

-- ----------------------------
-- Table structure for slmp_alarm_dict
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_alarm_dict";
CREATE TABLE "public"."slmp_alarm_dict" (
  "id" int8 NOT NULL,
  "alarm_name" varchar(255) COLLATE "pg_catalog"."default",
  "alarm_code" int4,
  "cause" varchar(255) COLLATE "pg_catalog"."default",
  "suggest" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_alarm_dict"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_alarm_dict"."alarm_name" IS '告警名称';
COMMENT ON COLUMN "public"."slmp_alarm_dict"."alarm_code" IS '告警code';
COMMENT ON COLUMN "public"."slmp_alarm_dict"."cause" IS '可能引起告警的原因';
COMMENT ON COLUMN "public"."slmp_alarm_dict"."suggest" IS '建议';
COMMENT ON TABLE "public"."slmp_alarm_dict" IS '用户表';

-- ----------------------------
-- Table structure for slmp_alarm_suppress_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_alarm_suppress_device";
CREATE TABLE "public"."slmp_alarm_suppress_device" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "rule_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_alarm_suppress_device"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_device"."device_id" IS '设备id';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_device"."rule_id" IS '告警抑制规则id';
COMMENT ON TABLE "public"."slmp_alarm_suppress_device" IS '用户表';

-- ----------------------------
-- Table structure for slmp_alarm_suppress_rule
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_alarm_suppress_rule";
CREATE TABLE "public"."slmp_alarm_suppress_rule" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "alarm_code" varchar(512) COLLATE "pg_catalog"."default",
  "device_type" int4,
  "scope" int4,
  "time_scope" int4,
  "begin_time" varchar(32) COLLATE "pg_catalog"."default",
  "end_time" varchar(32) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."name" IS '告警抑制规则名称';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."alarm_code" IS '告警code, 多个用逗号分隔';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."device_type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_alarm_suppress_rule"."scope" IS '抑制范围 1全局 2自定义';
COMMENT ON TABLE "public"."slmp_alarm_suppress_rule" IS '用户表';

-- ----------------------------
-- Table structure for slmp_base
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_base";
CREATE TABLE "public"."slmp_base" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4
)
;
COMMENT ON COLUMN "public"."slmp_base"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_base"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_base"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_base"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_base"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_base"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_base"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_base"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_base"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."slmp_base" IS '用户表';

-- ----------------------------
-- Table structure for slmp_call_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_call_data";
CREATE TABLE "public"."slmp_call_data" (
  "id" int8 NOT NULL,
  "device_channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "gateway_channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "device_id" int8,
  "ring_time" timestamp(6),
  "handup_time" timestamp(6),
  "video_url" varchar(255) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."slmp_call_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_call_data"."device_channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_call_data"."gateway_channel_number" IS '网关序列号';
COMMENT ON COLUMN "public"."slmp_call_data"."device_id" IS '设备ID';
COMMENT ON COLUMN "public"."slmp_call_data"."ring_time" IS 'ring时间';
COMMENT ON COLUMN "public"."slmp_call_data"."handup_time" IS 'handup时间';
COMMENT ON COLUMN "public"."slmp_call_data"."video_url" IS '视频文件url';

-- ----------------------------
-- Table structure for slmp_dc_box_branch_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_branch_current_data";
CREATE TABLE "public"."slmp_dc_box_branch_current_data" (
  "id" int8 NOT NULL,
  "dc_box_id" int8,
  "collect_time" timestamp(6),
  "k1_i" numeric(16,2),
  "k1_status" int4,
  "k2_i" numeric(16,2),
  "k2_status" int4,
  "k3_i" numeric(16,2),
  "k3_status" int4,
  "k4_i" numeric(16,2),
  "k4_status" int4,
  "k5_i" numeric(16,2),
  "k5_status" int4,
  "k6_i" numeric(16,2),
  "k6_status" int4,
  "k7_i" numeric(16,2),
  "k7_status" int4,
  "k8_i" numeric(16,2),
  "k8_status" int4,
  "k9_i" numeric(16,2),
  "k9_status" int4,
  "k10_i" numeric(16,2),
  "k10_status" int4,
  "k11_i" numeric(16,2),
  "k11_status" int4,
  "k12_i" numeric(16,2),
  "k12_status" int4,
  "k13_i" numeric(16,2),
  "k13_status" int4,
  "k14_i" numeric(16,2),
  "k14_status" int4,
  "k15_i" numeric(16,2),
  "k15_status" int4,
  "k16_i" numeric(16,2),
  "k16_status" int4,
  "k17_i" numeric(16,2),
  "k17_status" int4,
  "k18_i" numeric(16,2),
  "k18_status" int4,
  "k19_i" numeric(16,2),
  "k19_status" int4,
  "k20_i" numeric(16,2),
  "k20_status" int4,
  "k21_i" numeric(16,2),
  "k21_status" int4,
  "k22_i" numeric(16,2),
  "k22_status" int4,
  "k23_i" numeric(16,2),
  "k23_status" int4,
  "k24_i" numeric(16,2),
  "k24_status" int4
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."dc_box_id" IS '直流配电箱id';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k1_i" IS '支路1电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k1_status" IS '支路1状态 0关 1开 2未配置';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k2_i" IS '支路2电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k2_status" IS '支路2状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k3_i" IS '支路3电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k3_status" IS '支路3状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k4_i" IS '支路4电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k4_status" IS '支路4状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k5_i" IS '支路5电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k5_status" IS '支路5状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k6_i" IS '支路6电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k6_status" IS '支路6状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k7_i" IS '支路7电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k7_status" IS '支路7状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k8_i" IS '支路8电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k8_status" IS '支路8状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k9_i" IS '支路9电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k9_status" IS '支路9状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k10_i" IS '支路10电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k10_status" IS '支路10状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k11_i" IS '支路11电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k11_status" IS '支路11状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k12_i" IS '支路12电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k12_status" IS '支路12状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k13_i" IS '支路13电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k13_status" IS '支路13状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k14_i" IS '支路14电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k14_status" IS '支路14状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k15_i" IS '支路15电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k15_status" IS '支路15状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k16_i" IS '支路16电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k16_status" IS '支路16状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k17_i" IS '支路17电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k17_status" IS '支路17状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k18_i" IS '支路18电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k18_status" IS '支路18状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k19_i" IS '支路19电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k19_status" IS '支路19状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k20_i" IS '支路20电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k20_status" IS '支路20状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k21_i" IS '支路21电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k21_status" IS '支路21状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k22_i" IS '支路22电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k22_status" IS '支路22状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k23_i" IS '支路23电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k23_status" IS '支路23状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k24_i" IS '支路24电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_current_data"."k24_status" IS '支路24状态';
COMMENT ON TABLE "public"."slmp_dc_box_branch_current_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_dc_box_branch_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_branch_history_data";
CREATE TABLE "public"."slmp_dc_box_branch_history_data" (
  "id" int8 NOT NULL,
  "dc_box_id" int8,
  "collect_time" timestamp(6),
  "k1_i" numeric(16,2),
  "k1_status" int4,
  "k2_i" numeric(16,2),
  "k2_status" int4,
  "k3_i" numeric(16,2),
  "k3_status" int4,
  "k4_i" numeric(16,2),
  "k4_status" int4,
  "k5_i" numeric(16,2),
  "k5_status" int4,
  "k6_i" numeric(16,2),
  "k6_status" int4,
  "k7_i" numeric(16,2),
  "k7_status" int4,
  "k8_i" numeric(16,2),
  "k8_status" int4,
  "k9_i" numeric(16,2),
  "k9_status" int4,
  "k10_i" numeric(16,2),
  "k10_status" int4,
  "k11_i" numeric(16,2),
  "k11_status" int4,
  "k12_i" numeric(16,2),
  "k12_status" int4,
  "k13_i" numeric(16,2),
  "k13_status" int4,
  "k14_i" numeric(16,2),
  "k14_status" int4,
  "k15_i" numeric(16,2),
  "k15_status" int4,
  "k16_i" numeric(16,2),
  "k16_status" int4,
  "k17_i" numeric(16,2),
  "k17_status" int4,
  "k18_i" numeric(16,2),
  "k18_status" int4,
  "k19_i" numeric(16,2),
  "k19_status" int4,
  "k20_i" numeric(16,2),
  "k20_status" int4,
  "k21_i" numeric(16,2),
  "k21_status" int4,
  "k22_i" numeric(16,2),
  "k22_status" int4,
  "k23_i" numeric(16,2),
  "k23_status" int4,
  "k24_i" numeric(16,2),
  "k24_status" int4
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."dc_box_id" IS '直流配电箱id';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k1_i" IS '支路1电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k1_status" IS '支路1状态 0关 1开 2未配置';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k2_i" IS '支路2电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k2_status" IS '支路2状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k3_i" IS '支路3电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k3_status" IS '支路3状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k4_i" IS '支路4电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k4_status" IS '支路4状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k5_i" IS '支路5电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k5_status" IS '支路5状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k6_i" IS '支路6电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k6_status" IS '支路6状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k7_i" IS '支路7电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k7_status" IS '支路7状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k8_i" IS '支路8电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k8_status" IS '支路8状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k9_i" IS '支路9电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k9_status" IS '支路9状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k10_i" IS '支路10电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k10_status" IS '支路10状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k11_i" IS '支路11电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k11_status" IS '支路11状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k12_i" IS '支路12电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k12_status" IS '支路12状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k13_i" IS '支路13电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k13_status" IS '支路13状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k14_i" IS '支路14电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k14_status" IS '支路14状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k15_i" IS '支路15电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k15_status" IS '支路15状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k16_i" IS '支路16电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k16_status" IS '支路16状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k17_i" IS '支路17电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k17_status" IS '支路17状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k18_i" IS '支路18电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k18_status" IS '支路18状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k19_i" IS '支路19电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k19_status" IS '支路19状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k20_i" IS '支路20电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k20_status" IS '支路20状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k21_i" IS '支路21电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k21_status" IS '支路21状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k22_i" IS '支路22电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k22_status" IS '支路22状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k23_i" IS '支路23电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k23_status" IS '支路23状态';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k24_i" IS '支路24电流';
COMMENT ON COLUMN "public"."slmp_dc_box_branch_history_data"."k24_status" IS '支路24状态';
COMMENT ON TABLE "public"."slmp_dc_box_branch_history_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_dc_box_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_current_data";
CREATE TABLE "public"."slmp_dc_box_current_data" (
  "id" int8 NOT NULL,
  "dc_box_id" int8,
  "collect_time" timestamp(6),
  "ac_ua" numeric(16,2),
  "ac_ia" numeric(16,2),
  "ac_ub" numeric(16,2),
  "ac_ib" numeric(16,2),
  "ac_uc" numeric(16,2),
  "ac_ic" numeric(16,2),
  "ac_power" numeric(16,2),
  "dc_voltage" numeric(16,2),
  "out_total_current" numeric(16,2),
  "work_pattern" int4,
  "dimming_value" int4,
  "env_temp" numeric(16,2),
  "ac_switch_status" int4,
  "branch_count" int4,
  "running_season" int4
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."dc_box_id" IS '直流配电箱id';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_ua" IS '交流A相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_ia" IS '交流A相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_ub" IS '交流B相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_ib" IS '交流B相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_uc" IS '交流C相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_ic" IS '交流C相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_power" IS '交流电能';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."dc_voltage" IS '直流电压';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."out_total_current" IS '输出总电流';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."work_pattern" IS '工作模式
0 正常工作模式
1 巡检模式
2 手动模式
3 维修模式
4 抢修模式
5 测试模式
6 非调光模式';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."dimming_value" IS '调光亮度 %';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."env_temp" IS '环境温度';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."ac_switch_status" IS '交流开关状态';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."branch_count" IS '支路数量';
COMMENT ON COLUMN "public"."slmp_dc_box_current_data"."running_season" IS '当前运行季节 0春 1夏 2秋 3冬';
COMMENT ON TABLE "public"."slmp_dc_box_current_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_dc_box_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_device";
CREATE TABLE "public"."slmp_dc_box_device" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default",
  "term_addr" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_dc_box_device"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_dc_box_device"."name" IS '电表名称';
COMMENT ON COLUMN "public"."slmp_dc_box_device"."model" IS '直流配电箱型号';
COMMENT ON COLUMN "public"."slmp_dc_box_device"."term_addr" IS '地址吗';

-- ----------------------------
-- Table structure for slmp_dc_box_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_history_data";
CREATE TABLE "public"."slmp_dc_box_history_data" (
  "id" int8 NOT NULL,
  "dc_box_id" int8,
  "collect_time" timestamp(6),
  "ac_ua" numeric(16,2),
  "ac_ia" numeric(16,2),
  "ac_ub" numeric(16,2),
  "ac_ib" numeric(16,2),
  "ac_uc" numeric(16,2),
  "ac_ic" numeric(16,2),
  "ac_power" numeric(16,2),
  "dc_voltage" numeric(16,2),
  "out_total_current" numeric(16,2),
  "work_pattern" int4,
  "dimming_value" int4,
  "env_temp" numeric(16,2),
  "ac_switch_status" int4,
  "branch_count" int4,
  "running_season" int4
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."dc_box_id" IS '直流配电箱id';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_ua" IS '交流A相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_ia" IS '交流A相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_ub" IS '交流B相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_ib" IS '交流B相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_uc" IS '交流C相电压';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_ic" IS '交流C相电流';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_power" IS '交流电能';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."dc_voltage" IS '直流电压';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."out_total_current" IS '输出总电流';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."work_pattern" IS '工作模式
0 正常工作模式
1 巡检模式
2 手动模式
3 维修模式
4 抢修模式
5 测试模式
6 非调光模式';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."dimming_value" IS '调光亮度 %';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."env_temp" IS '环境温度';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."ac_switch_status" IS '交流开关状态';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."branch_count" IS '支路数量';
COMMENT ON COLUMN "public"."slmp_dc_box_history_data"."running_season" IS '当前运行季节 0春 1夏 2秋 3冬';
COMMENT ON TABLE "public"."slmp_dc_box_history_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_dc_box_strategy
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_strategy";
CREATE TABLE "public"."slmp_dc_box_strategy" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy"."name" IS '策略名称';
COMMENT ON TABLE "public"."slmp_dc_box_strategy" IS '用户表';

-- ----------------------------
-- Table structure for slmp_dc_box_strategy_application
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_strategy_application";
CREATE TABLE "public"."slmp_dc_box_strategy_application" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "strategy_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_application"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_application"."device_id" IS '直流配电箱id';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_application"."strategy_id" IS '直流配电箱策略id';

-- ----------------------------
-- Table structure for slmp_dc_box_strategy_detail
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_box_strategy_detail";
CREATE TABLE "public"."slmp_dc_box_strategy_detail" (
  "id" int8 NOT NULL,
  "strategy_id" int8,
  "season" int4,
  "auto_on_time" varchar(5) COLLATE "pg_catalog"."default",
  "auto_off_time" varchar(5) COLLATE "pg_catalog"."default",
  "auto_light_value" int4,
  "dimming1_on_time" varchar(5) COLLATE "pg_catalog"."default",
  "dimming1_off_time" varchar(5) COLLATE "pg_catalog"."default",
  "dimming1_light_value" int4,
  "dimming2_on_time" varchar(5) COLLATE "pg_catalog"."default",
  "dimming2_off_time" varchar(5) COLLATE "pg_catalog"."default",
  "dimming2_light_value" int4
)
;
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."strategy_id" IS '直流配电箱策略id';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."season" IS '季节 0春 1夏 2秋 3冬';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."auto_on_time" IS '自动开灯时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."auto_off_time" IS '自动关灯时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."auto_light_value" IS '自动灯光亮度';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming1_on_time" IS '一级调光开始时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming1_off_time" IS '一级调光结束时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming1_light_value" IS '一级调光亮度';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming2_on_time" IS '二级调光开始时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming2_off_time" IS '二级调光结束时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_dc_box_strategy_detail"."dimming2_light_value" IS '二级调光亮度';

-- ----------------------------
-- Table structure for slmp_dc_switch_box
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_dc_switch_box";
CREATE TABLE "public"."slmp_dc_switch_box" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_dc_switch_box"."model" IS '配电箱型号';
COMMENT ON TABLE "public"."slmp_dc_switch_box" IS '用户表';

-- ----------------------------
-- Table structure for slmp_default_strategy
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_default_strategy";
CREATE TABLE "public"."slmp_default_strategy" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "day" varchar(10) COLLATE "pg_catalog"."default",
  "on_time" varchar(5) COLLATE "pg_catalog"."default",
  "off_time" varchar(5) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_default_strategy"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_default_strategy"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_default_strategy"."day" IS '日期yyyy-MM-dd';
COMMENT ON COLUMN "public"."slmp_default_strategy"."on_time" IS '开灯时间HH:mm';
COMMENT ON COLUMN "public"."slmp_default_strategy"."off_time" IS '关灯时间HH:mm';

-- ----------------------------
-- Table structure for slmp_device_ammeter
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_ammeter";
CREATE TABLE "public"."slmp_device_ammeter" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "ammeter_addr" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "total_reverse_electric_energy" varchar(255) COLLATE "pg_catalog"."default",
  "active_power_a" varchar(255) COLLATE "pg_catalog"."default",
  "active_power_b" varchar(255) COLLATE "pg_catalog"."default",
  "active_power_c" varchar(255) COLLATE "pg_catalog"."default",
  "a_phase_voltage" varchar(255) COLLATE "pg_catalog"."default",
  "b_phase_voltage" varchar(255) COLLATE "pg_catalog"."default",
  "c_phase_voltage" varchar(255) COLLATE "pg_catalog"."default",
  "a_phase_current" varchar(255) COLLATE "pg_catalog"."default",
  "b_phase_current" varchar(255) COLLATE "pg_catalog"."default",
  "c_phase_current" varchar(255) COLLATE "pg_catalog"."default",
  "total_forward_electric_energy" varchar(255) COLLATE "pg_catalog"."default",
  "total_power_consumption" varchar(255) COLLATE "pg_catalog"."default",
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_ammeter"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."name" IS '电表名称';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."ammeter_addr" IS '表号';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."total_reverse_electric_energy" IS '总反向电能';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."active_power_a" IS 'A项有功功率';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."active_power_b" IS 'B项有功功率';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."active_power_c" IS 'C项有功功率';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."a_phase_voltage" IS 'A项电压';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."b_phase_voltage" IS 'B项电压';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."c_phase_voltage" IS 'C项电压';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."a_phase_current" IS 'A项电流';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."b_phase_current" IS 'B项电流';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."c_phase_current" IS 'C项电流';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."total_forward_electric_energy" IS '总正向电能';
COMMENT ON COLUMN "public"."slmp_device_ammeter"."total_power_consumption" IS '总电能';

-- ----------------------------
-- Table structure for slmp_device_audio
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_audio";
CREATE TABLE "public"."slmp_device_audio" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "server_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_audio"."server_ip" IS '音响设备IP';
COMMENT ON COLUMN "public"."slmp_device_audio"."server_port" IS '音响设备端口';

-- ----------------------------
-- Table structure for slmp_device_call
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_call";
CREATE TABLE "public"."slmp_device_call" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(30) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "server_port" varchar(30) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "gateway_module_key" varchar(64) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "extend_data" varchar(512) COLLATE "pg_catalog"."default" DEFAULT NULL::character varying,
  "username" varchar(255) COLLATE "pg_catalog"."default",
  "password" varchar(255) COLLATE "pg_catalog"."default",
  "event_enable" int4,
  "video_time" int4,
  "rtsp_url" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_call"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_device_call"."username" IS '用户名';
COMMENT ON COLUMN "public"."slmp_device_call"."password" IS '密码';
COMMENT ON COLUMN "public"."slmp_device_call"."event_enable" IS '开启事件上报 0关闭 1开启';
COMMENT ON COLUMN "public"."slmp_device_call"."video_time" IS '视频录制时长 单位秒';
COMMENT ON COLUMN "public"."slmp_device_call"."rtsp_url" IS 'rtsp_url';

-- ----------------------------
-- Table structure for slmp_device_camera
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_camera";
CREATE TABLE "public"."slmp_device_camera" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "server_port" varchar(255) COLLATE "pg_catalog"."default",
  "server_username" varchar(255) COLLATE "pg_catalog"."default",
  "server_password" varchar(255) COLLATE "pg_catalog"."default",
  "init_status" int4,
  "rtsp_url" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_camera"."server_ip" IS '摄像头IP';
COMMENT ON COLUMN "public"."slmp_device_camera"."server_port" IS '摄像头端口';
COMMENT ON COLUMN "public"."slmp_device_camera"."server_username" IS '摄像头登录用户名';
COMMENT ON COLUMN "public"."slmp_device_camera"."server_password" IS '摄像头登录密码';
COMMENT ON COLUMN "public"."slmp_device_camera"."init_status" IS '摄像头初始化状态 1未初始化 2初始化中 3已初始化 4初始化失败';

-- ----------------------------
-- Table structure for slmp_device_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_data";
CREATE TABLE "public"."slmp_device_data" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "is_deleted" int4,
  "container_id" int8,
  "type" int4,
  "property" varchar(255) COLLATE "pg_catalog"."default",
  "sn" varchar(255) COLLATE "pg_catalog"."default",
  "gateway_sn" varchar(255) COLLATE "pg_catalog"."default",
  "value" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device_data"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_device_data"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_device_data"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_data"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_device_data"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_device_data"."container_id" IS '容器Id';
COMMENT ON COLUMN "public"."slmp_device_data"."type" IS '设备类型  1：水浸；2：门磁；3：温湿度；4：风扇；5：灯带；6：摄像头；7：电表';
COMMENT ON COLUMN "public"."slmp_device_data"."property" IS '属性';
COMMENT ON COLUMN "public"."slmp_device_data"."sn" IS '编号';
COMMENT ON COLUMN "public"."slmp_device_data"."gateway_sn" IS '网关编号';
COMMENT ON COLUMN "public"."slmp_device_data"."value" IS '值';

-- ----------------------------
-- Table structure for slmp_device_data_his
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_data_his";
CREATE TABLE "public"."slmp_device_data_his" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "is_deleted" int4,
  "container_id" int8,
  "type" int4,
  "property" varchar(255) COLLATE "pg_catalog"."default",
  "sn" varchar(255) COLLATE "pg_catalog"."default",
  "gateway_sn" varchar(255) COLLATE "pg_catalog"."default",
  "value" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device_data_his"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_device_data_his"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_device_data_his"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_data_his"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_device_data_his"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_device_data_his"."container_id" IS '容器Id';
COMMENT ON COLUMN "public"."slmp_device_data_his"."type" IS '设备类型 1：水浸；2：门磁；3：温湿度；4：风扇；5：灯带；6：摄像头；7：电表';
COMMENT ON COLUMN "public"."slmp_device_data_his"."property" IS '属性';
COMMENT ON COLUMN "public"."slmp_device_data_his"."sn" IS '编号';
COMMENT ON COLUMN "public"."slmp_device_data_his"."gateway_sn" IS '网关编号';
COMMENT ON COLUMN "public"."slmp_device_data_his"."value" IS '值';

-- ----------------------------
-- Table structure for slmp_device_door_sensor
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_door_sensor";
CREATE TABLE "public"."slmp_device_door_sensor" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "di" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_door_sensor"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_device_door_sensor"."di" IS '门磁闭合状态，0：闭；1：开';

-- ----------------------------
-- Table structure for slmp_device_immersion
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_immersion";
CREATE TABLE "public"."slmp_device_immersion" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "immersion_status" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_immersion"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_device_immersion"."name" IS '水浸名称';
COMMENT ON COLUMN "public"."slmp_device_immersion"."immersion_status" IS '水浸状态，0：无；1：有';

-- ----------------------------
-- Table structure for slmp_device_screen
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_screen";
CREATE TABLE "public"."slmp_device_screen" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "term_addr" varchar(255) COLLATE "pg_catalog"."default",
  "screen_type" int4 NOT NULL,
  "screen_width" int4 DEFAULT 0,
  "screen_height" int4 DEFAULT 0,
  "screen_status" int4,
  "config_id" int8,
  "server_port" varchar(30) COLLATE "pg_catalog"."default",
  "server_ip" varchar(255) COLLATE "pg_catalog"."default",
  "server_username" varchar(30) COLLATE "pg_catalog"."default",
  "server_password" varchar(30) COLLATE "pg_catalog"."default",
  "controller_type" varchar(30) COLLATE "pg_catalog"."default",
  "screen_template" int4 DEFAULT 0,
  "tags" varchar COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_screen"."term_addr" IS '地址码';
COMMENT ON COLUMN "public"."slmp_device_screen"."screen_type" IS '屏类型  0-LED 1-LCD';
COMMENT ON COLUMN "public"."slmp_device_screen"."screen_width" IS '屏宽度';
COMMENT ON COLUMN "public"."slmp_device_screen"."screen_height" IS '屏高度';
COMMENT ON COLUMN "public"."slmp_device_screen"."screen_status" IS '大屏状态';
COMMENT ON COLUMN "public"."slmp_device_screen"."config_id" IS '节目id';
COMMENT ON COLUMN "public"."slmp_device_screen"."screen_template" IS '屏幕播放模板： 0-全屏 ，1-下方带字幕条';

-- ----------------------------
-- Table structure for slmp_device_screen_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_screen_config";
CREATE TABLE "public"."slmp_device_screen_config" (
  "id" int8 NOT NULL,
  "config_name" varchar(100) COLLATE "pg_catalog"."default",
  "output_json" text COLLATE "pg_catalog"."default",
  "on_off_time" varchar(1024) COLLATE "pg_catalog"."default",
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "is_deleted" int4 DEFAULT 0,
  "status" int4 DEFAULT 0,
  "create_dept" int8,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "type" int4,
  "stay_time" int4 DEFAULT 15,
  "start_play_time" varchar(20) COLLATE "pg_catalog"."default",
  "end_play_time" varchar(20) COLLATE "pg_catalog"."default",
  "play_time" text COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device_screen_config"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."config_name" IS '策略名称';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."output_json" IS '输出文本 [{"type":"","name":"","content":"","order":""}]';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."on_off_time" IS '开关屏时间，json格式数据';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."create_user" IS '创建者';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."update_user" IS '修改者';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."is_deleted" IS '删除标志: 0 正常   1已删除';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."create_dept" IS '部门';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."type" IS '节目类型';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."stay_time" IS '停留时间,单位：秒，默认15秒';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."start_play_time" IS '开始播放时间 yyyy-MM-dd HH:mm:ss';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."end_play_time" IS '结束播放时间yyyy-MM-dd HH:mm:ss';
COMMENT ON COLUMN "public"."slmp_device_screen_config"."play_time" IS '播放时间json';
COMMENT ON TABLE "public"."slmp_device_screen_config" IS '多媒体屏策略表';

-- ----------------------------
-- Table structure for slmp_device_screen_play_his
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_screen_play_his";
CREATE TABLE "public"."slmp_device_screen_play_his" (
  "id" int8 NOT NULL,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "device_id" int8,
  "down_task_id" varchar(255) COLLATE "pg_catalog"."default",
  "down_rate" int4,
  "play_status" varchar(255) COLLATE "pg_catalog"."default",
  "down_errorinfo" varchar(255) COLLATE "pg_catalog"."default",
  "batch_no" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_device_screen_play_his"."is_deleted" IS '是否已删除';
COMMENT ON TABLE "public"."slmp_device_screen_play_his" IS '用户表';

-- ----------------------------
-- Table structure for slmp_device_screen_program
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_screen_program";
CREATE TABLE "public"."slmp_device_screen_program" (
  "id" int8 NOT NULL,
  "device_id" int8 NOT NULL,
  "down_task_id" varchar(64) COLLATE "pg_catalog"."default",
  "down_rate" int4 DEFAULT 0,
  "down_status" varchar(30) COLLATE "pg_catalog"."default",
  "down_errorinfo" varchar(2000) COLLATE "pg_catalog"."default",
  "batch_no" varchar(30) COLLATE "pg_catalog"."default",
  "config_id" int8,
  "play_list_file" varchar(100) COLLATE "pg_catalog"."default",
  "ret_play_list_file" varchar(200) COLLATE "pg_catalog"."default",
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "is_deleted" int4 DEFAULT 0,
  "status" int4 DEFAULT 0,
  "create_dept" int8,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_device_screen_program"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."device_id" IS '屏id';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."down_task_id" IS '下载任务 id';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."down_rate" IS '下载进度  千分比形式的总下载进度，0～1000';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."down_status" IS '下载状态    "waiting"：等待下载中;  "downloading"：正在下载中 ; "complete"：下载已完成;"failure"：下载失败 ;"notfound"：<任务 id >指定的任务不存在;';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."down_errorinfo" IS '下载错误信息(含其他错误信息)';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."batch_no" IS '批次号';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."config_id" IS '对应节目id,存放slmp_device_screen_config表的id字段';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."play_list_file" IS '播放列表文件';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."ret_play_list_file" IS '屏返回的播放节目xml文件';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."create_user" IS '创建者';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."update_user" IS '修改者';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."is_deleted" IS '删除标志: 0 正常   1已删除';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."create_dept" IS '部门';
COMMENT ON COLUMN "public"."slmp_device_screen_program"."tenant_id" IS '租户id';
COMMENT ON TABLE "public"."slmp_device_screen_program" IS '多媒体屏静态节目上传表，静态节目每个屏只保留最后一次静态节目。分上传，播放两步执行静态播放时，保存上传信息在该表。';

-- ----------------------------
-- Table structure for slmp_device_screen_resource
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_screen_resource";
CREATE TABLE "public"."slmp_device_screen_resource" (
  "id" int8 NOT NULL,
  "type" varchar(100) COLLATE "pg_catalog"."default",
  "name" varchar(2048) COLLATE "pg_catalog"."default",
  "content" varchar(1024) COLLATE "pg_catalog"."default",
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "is_deleted" int4 DEFAULT 0,
  "status" int4 DEFAULT 0,
  "create_dept" int8
)
;
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."type" IS '资源类型 Text，Picture，Video';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."name" IS '资源名称';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."content" IS '资源内容，图片和视频保存的是minio上的路径';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."create_user" IS '创建者';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."update_user" IS '修改者';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."is_deleted" IS '删除标志: 0 正常   1已删除';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_device_screen_resource"."create_dept" IS '部门';
COMMENT ON TABLE "public"."slmp_device_screen_resource" IS '多媒体屏策略表';

-- ----------------------------
-- Table structure for slmp_device_wifi
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_device_wifi";
CREATE TABLE "public"."slmp_device_wifi" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "wifi_type" int4,
  "mac_addr" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "ssid" varchar(255) COLLATE "pg_catalog"."default",
  "password" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_device_wifi"."wifi_type" IS 'Wifi设备类型 1网关内置 2独立设备';
COMMENT ON COLUMN "public"."slmp_device_wifi"."mac_addr" IS 'AP的mac地址';

-- ----------------------------
-- Table structure for slmp_duty
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_duty";
CREATE TABLE "public"."slmp_duty" (
  "id" int8 NOT NULL,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "tenant_id" varchar(64) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "manager_name" varchar(255) COLLATE "pg_catalog"."default",
  "manager_tel" varchar(255) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "is_leaf" bool,
  "use_case" int4
)
;
COMMENT ON COLUMN "public"."slmp_duty"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_duty"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_duty"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_duty"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_duty"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_duty"."name" IS '责任区名称';
COMMENT ON COLUMN "public"."slmp_duty"."manager_name" IS '责任人名称';
COMMENT ON COLUMN "public"."slmp_duty"."manager_tel" IS '责任人电话';
COMMENT ON COLUMN "public"."slmp_duty"."parent_id" IS '上级ID';
COMMENT ON COLUMN "public"."slmp_duty"."is_leaf" IS '是否叶子节点';
COMMENT ON COLUMN "public"."slmp_duty"."use_case" IS '使用场景';

-- ----------------------------
-- Table structure for slmp_environmental_detector
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_environmental_detector";
CREATE TABLE "public"."slmp_environmental_detector" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "term_addr" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "vendor_name" varchar(255) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_environmental_detector"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_environmental_detector"."term_addr" IS '地址码';
COMMENT ON COLUMN "public"."slmp_environmental_detector"."vendor_name" IS '厂商名';

-- ----------------------------
-- Table structure for slmp_flood_control_station
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_flood_control_station";
CREATE TABLE "public"."slmp_flood_control_station" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_flood_control_station"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_flood_control_station"."attach_url" IS '附件地址';
COMMENT ON TABLE "public"."slmp_flood_control_station" IS '用户表';

-- ----------------------------
-- Table structure for slmp_gateway
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_gateway";
CREATE TABLE "public"."slmp_gateway" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "sn" varchar(255) COLLATE "pg_catalog"."default",
  "switch_box_id" int8,
  "online_status" int4,
  "managed_object_id" int8,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "mo_type" int4,
  "type" int4,
  "usage_scene" int4,
  "last_login_time" timestamp(6),
  "last_heartbeat_time" timestamp(6),
  "product" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_gateway"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_gateway"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_gateway"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_gateway"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_gateway"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_gateway"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_gateway"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_gateway"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_gateway"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_gateway"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_gateway"."sn" IS '网关sn';
COMMENT ON COLUMN "public"."slmp_gateway"."switch_box_id" IS '配电箱ID';
COMMENT ON COLUMN "public"."slmp_gateway"."online_status" IS '网关在线状态';
COMMENT ON COLUMN "public"."slmp_gateway"."managed_object_id" IS '所属设施量ID';
COMMENT ON COLUMN "public"."slmp_gateway"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_gateway"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_gateway"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_gateway"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_gateway"."mo_type" IS '设施量类型';
COMMENT ON COLUMN "public"."slmp_gateway"."type" IS '网关类型 1实体网关 2虚拟网关';
COMMENT ON COLUMN "public"."slmp_gateway"."usage_scene" IS '使用场景 1单灯 2RTU';
COMMENT ON TABLE "public"."slmp_gateway" IS '用户表';

-- ----------------------------
-- Table structure for slmp_gateway_wifi_cfg
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_gateway_wifi_cfg";
CREATE TABLE "public"."slmp_gateway_wifi_cfg" (
  "id" int8 NOT NULL,
  "gateway_id" int8,
  "radio" int4,
  "channel" varchar(255) COLLATE "pg_catalog"."default",
  "ssid" varchar(255) COLLATE "pg_catalog"."default",
  "password" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "enable" bool,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."gateway_id" IS '网关ID';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."radio" IS '0-2.4G 1-5G';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."channel" IS '信道';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."ssid" IS 'wifi名称';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."password" IS 'wifi密码';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."enable" IS '是否启用 true false';
COMMENT ON COLUMN "public"."slmp_gateway_wifi_cfg"."tenant_id" IS '租户id';

-- ----------------------------
-- Table structure for slmp_group
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_group";
CREATE TABLE "public"."slmp_group" (
  "id" int8 NOT NULL,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "tenant_id" varchar(64) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "image" varchar(255) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "is_leaf" bool,
  "use_case" int4,
  "device_type" int4
)
;
COMMENT ON COLUMN "public"."slmp_group"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_group"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_group"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_group"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_group"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_group"."name" IS '分组名称';
COMMENT ON COLUMN "public"."slmp_group"."image" IS '背景图';
COMMENT ON COLUMN "public"."slmp_group"."parent_id" IS '上级分组ID';
COMMENT ON COLUMN "public"."slmp_group"."is_leaf" IS '是否叶子节点';
COMMENT ON COLUMN "public"."slmp_group"."use_case" IS '使用场景';
COMMENT ON COLUMN "public"."slmp_group"."device_type" IS '设备类型';

-- ----------------------------
-- Table structure for slmp_hx_box_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_hx_box_current_data";
CREATE TABLE "public"."slmp_hx_box_current_data" (
  "id" int8 NOT NULL,
  "hx_box_id" int8,
  "collect_time" timestamp(6),
  "fan_working_mode" int4,
  "temperature_upper" numeric(16,2),
  "temperature" numeric(16,2),
  "humidity" numeric(16,2),
  "lock_status" int4,
  "fan_status" int4,
  "door_status" int4,
  "water_status" int4,
  "power_status" int4,
  "armed_status" int4,
  "smoke_status" int4,
  "screen1_status" int4,
  "screen2_status" int4,
  "ball_machine_status" int4,
  "lamp1_status" int4,
  "lamp2_status" int4,
  "lamp3_status" int4,
  "exchange_status" int4,
  "voice_status" int4,
  "lamp1_dimming_value" int4,
  "lamp2_dimming_value" int4,
  "dc12_voltage" numeric(16,2),
  "dc24_voltage" numeric(16,2),
  "ac16_voltage" numeric(16,2),
  "ac16_current" numeric(16,2),
  "ac32_voltage" numeric(16,2),
  "ac32_current" numeric(16,2),
  "screen_current" numeric(16,2),
  "voice_current" numeric(16,2),
  "longitude" numeric(16,2),
  "latitude" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."hx_box_id" IS '交流柜id';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."fan_working_mode" IS '风扇工作模式 0自动 1手动';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."temperature_upper" IS '风机开启上限温度';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."temperature" IS '环境温度';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."humidity" IS '环境湿度';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lock_status" IS '电子锁状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."fan_status" IS '风机状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."door_status" IS '门磁状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."water_status" IS '水浸状态 0正常 1告警';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."power_status" IS '电源状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."armed_status" IS '布防状态 0撤防 1布防';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."smoke_status" IS '烟感状态 0正常 1告警';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."screen1_status" IS '显示屏1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."screen2_status" IS '显示屏2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."ball_machine_status" IS '球机状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lamp1_status" IS '路灯1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lamp2_status" IS '路灯2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lamp3_status" IS '氛围灯状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."exchange_status" IS '交换机传输状态 0开 1关';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."voice_status" IS '音柱状态 0开 1关';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lamp1_dimming_value" IS '路灯1调光值';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."lamp2_dimming_value" IS '路灯2调光值';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."dc12_voltage" IS '直流12V电压';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."dc24_voltage" IS '直流24V电压';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."ac16_voltage" IS '16A 220V交流电压';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."ac16_current" IS '16A 220V交流电流';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."ac32_voltage" IS '32A 220V交流电压';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."ac32_current" IS '32A 220V交流电流';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."screen_current" IS '显示屏电流';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."voice_current" IS '音柱电流';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_hx_box_current_data"."latitude" IS '纬度';
COMMENT ON TABLE "public"."slmp_hx_box_current_data" IS '华信智能柜设备实时数据';

-- ----------------------------
-- Table structure for slmp_hx_box_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_hx_box_device";
CREATE TABLE "public"."slmp_hx_box_device" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON TABLE "public"."slmp_hx_box_device" IS '华信配电箱控制器';

-- ----------------------------
-- Table structure for slmp_hx_box_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_hx_box_history_data";
CREATE TABLE "public"."slmp_hx_box_history_data" (
  "id" int8 NOT NULL,
  "hx_box_id" int8,
  "collect_time" timestamp(6),
  "fan_working_mode" int4,
  "temperature_upper" numeric(16,2),
  "temperature" numeric(16,2),
  "humidity" numeric(16,2),
  "lock_status" int4,
  "fan_status" int4,
  "door_status" int4,
  "water_status" int4,
  "power_status" int4,
  "armed_status" int4,
  "smoke_status" int4,
  "screen1_status" int4,
  "screen2_status" int4,
  "ball_machine_status" int4,
  "lamp1_status" int4,
  "lamp2_status" int4,
  "lamp3_status" int4,
  "exchange_status" int4,
  "voice_status" int4,
  "lamp1_dimming_value" int4,
  "lamp2_dimming_value" int4,
  "dc12_voltage" numeric(16,2),
  "dc24_voltage" numeric(16,2),
  "ac16_voltage" numeric(16,2),
  "ac16_current" numeric(16,2),
  "ac32_voltage" numeric(16,2),
  "ac32_current" numeric(16,2),
  "screen_current" numeric(16,2),
  "voice_current" numeric(16,2),
  "longitude" numeric(16,2),
  "latitude" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."hx_box_id" IS '交流柜id';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."fan_working_mode" IS '风扇工作模式 0自动 1手动';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."temperature_upper" IS '风机开启上限温度';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."temperature" IS '环境温度';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."humidity" IS '环境湿度';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lock_status" IS '电子锁状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."fan_status" IS '风机状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."door_status" IS '门磁状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."water_status" IS '水浸状态 0正常 1告警';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."power_status" IS '电源状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."armed_status" IS '布防状态 0撤防 1布防';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."smoke_status" IS '烟感状态 0正常 1告警';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."screen1_status" IS '显示屏1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."screen2_status" IS '显示屏2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."ball_machine_status" IS '球机状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lamp1_status" IS '路灯1状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lamp2_status" IS '路灯2状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lamp3_status" IS '氛围灯状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."exchange_status" IS '交换机传输状态 0开 1关';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."voice_status" IS '音柱状态 0开 1关';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lamp1_dimming_value" IS '路灯1调光值';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."lamp2_dimming_value" IS '路灯2调光值';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."dc12_voltage" IS '直流12V电压';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."dc24_voltage" IS '直流24V电压';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."ac16_voltage" IS '16A 220V交流电压';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."ac16_current" IS '16A 220V交流电流';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."ac32_voltage" IS '32A 220V交流电压';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."ac32_current" IS '32A 220V交流电流';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."screen_current" IS '显示屏电流';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."voice_current" IS '音柱电流';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_hx_box_history_data"."latitude" IS '纬度';
COMMENT ON TABLE "public"."slmp_hx_box_history_data" IS '华信智能柜设备历史数据';

-- ----------------------------
-- Table structure for slmp_hx_switch_box
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_hx_switch_box";
CREATE TABLE "public"."slmp_hx_switch_box" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;

-- ----------------------------
-- Table structure for slmp_io_module_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_io_module_current_data";
CREATE TABLE "public"."slmp_io_module_current_data" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "collect_time" timestamp(6),
  "di1" int4,
  "di2" int4,
  "di3" int4,
  "di4" int4
)
;
COMMENT ON COLUMN "public"."slmp_io_module_current_data"."id" IS '主键';
COMMENT ON TABLE "public"."slmp_io_module_current_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_io_module_device
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_io_module_device";
CREATE TABLE "public"."slmp_io_module_device" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_io_module_device"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_io_module_device"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_io_module_device"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_io_module_device"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_io_module_device"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_io_module_device"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_io_module_device"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_io_module_device"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_io_module_device"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_io_module_device"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_io_module_device"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_io_module_device"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_io_module_device"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_io_module_device"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_io_module_device"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_io_module_device"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_io_module_device"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_io_module_device"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_io_module_device"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_io_module_device"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_io_module_device"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_io_module_device"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_io_module_device"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_io_module_device"."group_ids" IS '组ID集合,多个用逗号分隔';

-- ----------------------------
-- Table structure for slmp_io_module_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_io_module_history_data";
CREATE TABLE "public"."slmp_io_module_history_data" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "collect_time" timestamp(6),
  "di1" int4,
  "di2" int4,
  "di3" int4,
  "di4" int4
)
;
COMMENT ON COLUMN "public"."slmp_io_module_history_data"."id" IS '主键';
COMMENT ON TABLE "public"."slmp_io_module_history_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_lamp
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamp";
CREATE TABLE "public"."slmp_lamp" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "protocol" varchar(255) COLLATE "pg_catalog"."default",
  "software_version" varchar(255) COLLATE "pg_catalog"."default",
  "imei" varchar(255) COLLATE "pg_catalog"."default",
  "imsi" varchar(255) COLLATE "pg_catalog"."default",
  "iccid" varchar(255) COLLATE "pg_catalog"."default",
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_lamp"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamp"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_lamp"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_lamp"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_lamp"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_lamp"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_lamp"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_lamp"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_lamp"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_lamp"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_lamp"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_lamp"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_lamp"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_lamp"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_lamp"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_lamp"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_lamp"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_lamp"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_lamp"."protocol" IS '单灯协议';
COMMENT ON COLUMN "public"."slmp_lamp"."software_version" IS '软件版本号';
COMMENT ON COLUMN "public"."slmp_lamp"."imei" IS '模组IMEI号';
COMMENT ON COLUMN "public"."slmp_lamp"."imsi" IS 'SIM卡IMSI';
COMMENT ON COLUMN "public"."slmp_lamp"."iccid" IS 'SIM卡ICCID';

-- ----------------------------
-- Table structure for slmp_lamp_current
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamp_current";
CREATE TABLE "public"."slmp_lamp_current" (
  "id" int8 NOT NULL,
  "lamp_id" int8,
  "collect_time" timestamp(6),
  "signal_intensity" int4,
  "snr" int4,
  "rtc_time" timestamp(6),
  "login_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."slmp_lamp_current"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamp_current"."lamp_id" IS '单灯id';
COMMENT ON COLUMN "public"."slmp_lamp_current"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_lamp_current"."signal_intensity" IS '信号强度';
COMMENT ON COLUMN "public"."slmp_lamp_current"."snr" IS '信噪比';
COMMENT ON COLUMN "public"."slmp_lamp_current"."rtc_time" IS '单灯RTC时间';
COMMENT ON COLUMN "public"."slmp_lamp_current"."login_time" IS '单灯登录时间';

-- ----------------------------
-- Table structure for slmp_lamp_history
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamp_history";
CREATE TABLE "public"."slmp_lamp_history" (
  "id" int8 NOT NULL,
  "lamp_id" int8,
  "collect_time" timestamp(6),
  "signal_intensity" int4,
  "snr" int4,
  "message_id" int4
)
;
COMMENT ON COLUMN "public"."slmp_lamp_history"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamp_history"."lamp_id" IS '单灯id';
COMMENT ON COLUMN "public"."slmp_lamp_history"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_lamp_history"."signal_intensity" IS '信号强度';
COMMENT ON COLUMN "public"."slmp_lamp_history"."snr" IS '信噪比';
COMMENT ON COLUMN "public"."slmp_lamp_history"."message_id" IS '消息id';

-- ----------------------------
-- Table structure for slmp_lamp_loop_current
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamp_loop_current";
CREATE TABLE "public"."slmp_lamp_loop_current" (
  "id" int8 NOT NULL,
  "lamp_id" int8,
  "collect_time" timestamp(6),
  "loop_no" varchar(32) COLLATE "pg_catalog"."default",
  "auto" int4,
  "light_value" int4,
  "voltage" numeric(8,2),
  "electricity_current" numeric(8,2),
  "power" numeric(8,2)
)
;
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."lamp_id" IS '单灯id';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."loop_no" IS '回路编号';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."auto" IS '手自动';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."light_value" IS '亮度值';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."voltage" IS '电压';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."electricity_current" IS '电流';
COMMENT ON COLUMN "public"."slmp_lamp_loop_current"."power" IS '功率';

-- ----------------------------
-- Table structure for slmp_lamp_loop_history
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamp_loop_history";
CREATE TABLE "public"."slmp_lamp_loop_history" (
  "id" int8 NOT NULL,
  "lamp_id" int8,
  "collect_time" timestamp(6),
  "loop_no" varchar(32) COLLATE "pg_catalog"."default",
  "auto" int4,
  "light_value" int4,
  "voltage" numeric(8,2),
  "electricity_current" numeric(8,2),
  "power" numeric(8,2),
  "message_id" int4
)
;
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."lamp_id" IS '单灯id';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."loop_no" IS '回路编号';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."auto" IS '手自动';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."light_value" IS '亮度值';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."voltage" IS '电压';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."electricity_current" IS '电流';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."power" IS '功率';
COMMENT ON COLUMN "public"."slmp_lamp_loop_history"."message_id" IS '消息id';

-- ----------------------------
-- Table structure for slmp_lamps
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_lamps";
CREATE TABLE "public"."slmp_lamps" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "model" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "type" int4,
  "color" int4,
  "power" int4,
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_lamps"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_lamps"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_lamps"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_lamps"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_lamps"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_lamps"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_lamps"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_lamps"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_lamps"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_lamps"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_lamps"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_lamps"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_lamps"."model" IS '灯具型号';
COMMENT ON COLUMN "public"."slmp_lamps"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_lamps"."type" IS '灯具类型 1-LED路灯 2-钠灯 3-投光灯 4-节能灯 5-礼花灯 6-电子管 7-彩云追月 8-五彩梦幻灯 9-冷阴极灯管 10-日光灯 11-变色灯 12-金卤灯 13-庭院灯 14-LED灯带(圆) 15-LED灯带(匾)';
COMMENT ON COLUMN "public"."slmp_lamps"."color" IS '灯具颜色 1-红 2-绿 3-白 4-黄 5-紫 6-变色 7-五彩 8-LED双管三色';
COMMENT ON COLUMN "public"."slmp_lamps"."power" IS '灯具功率';
COMMENT ON COLUMN "public"."slmp_lamps"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_lamps"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_lamps"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_lamps"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_lamps"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_lamps"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_lamps"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_lamps"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_lamps"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_lamps"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_lamps"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_lamps"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_lamps"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_lamps"."mo_type" IS '管理对象类型';
COMMENT ON TABLE "public"."slmp_lamps" IS '用户表';

-- ----------------------------
-- Table structure for slmp_managed_object_attach
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_managed_object_attach";
CREATE TABLE "public"."slmp_managed_object_attach" (
  "id" int8 NOT NULL,
  "managed_object_id" int8,
  "attach_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_managed_object_attach"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_managed_object_attach"."managed_object_id" IS '关联对象id';
COMMENT ON COLUMN "public"."slmp_managed_object_attach"."attach_id" IS '附件id';
COMMENT ON TABLE "public"."slmp_managed_object_attach" IS '用户表';

-- ----------------------------
-- Table structure for slmp_monitor_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_monitor_data";
CREATE TABLE "public"."slmp_monitor_data" (
  "id" int8 NOT NULL,
  "device_channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "gateway_channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "device_id" int8,
  "collect_time" timestamp(6),
  "data" text COLLATE "pg_catalog"."default",
  "device_type" varchar(255) COLLATE "pg_catalog"."default",
  "data_type" varchar(255) COLLATE "pg_catalog"."default",
  "identifier" varchar(255) COLLATE "pg_catalog"."default",
  "message_id" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_monitor_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_monitor_data"."device_channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_monitor_data"."gateway_channel_number" IS '网关序列号';
COMMENT ON COLUMN "public"."slmp_monitor_data"."device_id" IS '设备ID';
COMMENT ON COLUMN "public"."slmp_monitor_data"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_monitor_data"."data" IS '设备数据';
COMMENT ON COLUMN "public"."slmp_monitor_data"."device_type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_monitor_data"."data_type" IS '数据类型';
COMMENT ON COLUMN "public"."slmp_monitor_data"."identifier" IS '服务事件的唯一识别码';
COMMENT ON COLUMN "public"."slmp_monitor_data"."message_id" IS '消息id';
COMMENT ON COLUMN "public"."slmp_monitor_data"."tenant_id" IS '租户id';

-- ----------------------------
-- Table structure for slmp_multiple_strategy_record
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_multiple_strategy_record";
CREATE TABLE "public"."slmp_multiple_strategy_record" (
  "id" int8 NOT NULL,
  "rtu_id" int8,
  "effect_day" varchar(5) COLLATE "pg_catalog"."default",
  "effect_hour" varchar(5) COLLATE "pg_catalog"."default",
  "index_of_strategy" int4,
  "selected" varchar(8) COLLATE "pg_catalog"."default",
  "checked" bool,
  "collect_time" timestamp(6),
  "is_on" bool,
  "is_failed" bool
)
;
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."rtu_id" IS 'rtuid';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."effect_day" IS '策略日期';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."effect_hour" IS '策略时间';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."index_of_strategy" IS '策略index';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."selected" IS '策略执行的rtu回路 00000000';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."checked" IS '该记录是否被确认';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."collect_time" IS '数据保存时间';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."is_on" IS '是否为开灯操作  true开灯 false关灯';
COMMENT ON COLUMN "public"."slmp_multiple_strategy_record"."is_failed" IS '是否失效';

-- ----------------------------
-- Table structure for slmp_opt_log
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_opt_log";
CREATE TABLE "public"."slmp_opt_log" (
  "id" int8 NOT NULL,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "opt_obj" varchar(5000) COLLATE "pg_catalog"."default",
  "cost" int8,
  "start_time" timestamp(6),
  "uri" varchar(255) COLLATE "pg_catalog"."default",
  "username" varchar(255) COLLATE "pg_catalog"."default",
  "method" varchar(255) COLLATE "pg_catalog"."default",
  "ip" varchar(255) COLLATE "pg_catalog"."default",
  "result" varchar(255) COLLATE "pg_catalog"."default",
  "batch_no" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_opt_log"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_opt_log"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_opt_log"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_opt_log"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_opt_log"."name" IS '操作名称';
COMMENT ON COLUMN "public"."slmp_opt_log"."opt_obj" IS '操作对象';
COMMENT ON COLUMN "public"."slmp_opt_log"."cost" IS '操作耗时';
COMMENT ON COLUMN "public"."slmp_opt_log"."start_time" IS '开始时间';
COMMENT ON COLUMN "public"."slmp_opt_log"."uri" IS '地址';
COMMENT ON COLUMN "public"."slmp_opt_log"."username" IS '用户名';
COMMENT ON COLUMN "public"."slmp_opt_log"."method" IS '请求类型';
COMMENT ON COLUMN "public"."slmp_opt_log"."ip" IS 'IP';
COMMENT ON COLUMN "public"."slmp_opt_log"."result" IS '操作结果';
COMMENT ON COLUMN "public"."slmp_opt_log"."batch_no" IS '批次号';

-- ----------------------------
-- Table structure for slmp_pole
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_pole";
CREATE TABLE "public"."slmp_pole" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "pole_no" varchar(64) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "switch_box_id" int8,
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "type" int4,
  "arm_count" int4,
  "arm_length" int4,
  "height" int4,
  "category" int4,
  "usage" int4,
  "texture" int4,
  "install_type" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "facility_status" int4,
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "lamps" varchar(255) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "handover_time" timestamp(6),
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "last_id" int8,
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_pole"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_pole"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_pole"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_pole"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_pole"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_pole"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_pole"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_pole"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_pole"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_pole"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_pole"."pole_no" IS '杆号';
COMMENT ON COLUMN "public"."slmp_pole"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_pole"."switch_box_id" IS '所属配电箱';
COMMENT ON COLUMN "public"."slmp_pole"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_pole"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_pole"."type" IS '杆型 1-中杆 2-高杆 3-平行杆 4-高低杆 5-华灯杆';
COMMENT ON COLUMN "public"."slmp_pole"."arm_count" IS '挑臂数量';
COMMENT ON COLUMN "public"."slmp_pole"."arm_length" IS '挑臂长度 1-1.2米以内 2-1.2米以外';
COMMENT ON COLUMN "public"."slmp_pole"."height" IS '灯杆高度 1-7米及以下 2-13米及以下 3-16米及以下';
COMMENT ON COLUMN "public"."slmp_pole"."category" IS '灯杆类型 1-主要道路道路灯 2-主要道路投光灯 3-主要道路庭院灯 4-中杆灯 5-高杆灯 6-主要道路挑灯 7-小街小巷道路灯 8-小街小巷投光灯 9-小街小巷庭院灯 10-小街小巷挑灯';
COMMENT ON COLUMN "public"."slmp_pole"."usage" IS '灯杆用途 1-公用(多功能杆) 2-路灯专用';
COMMENT ON COLUMN "public"."slmp_pole"."texture" IS '材质 1-木杆 2-金属杆 3-水泥';
COMMENT ON COLUMN "public"."slmp_pole"."install_type" IS '安装方式 1-水泥杆装 2-墙装(换臂) 3-普通安装';
COMMENT ON COLUMN "public"."slmp_pole"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_pole"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_pole"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_pole"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_pole"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_pole"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_pole"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_pole"."lamps" IS '灯具，灯具id 用逗号分隔';
COMMENT ON COLUMN "public"."slmp_pole"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_pole"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_pole"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_pole"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_pole"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_pole"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_pole"."mo_type" IS '管理对象类型';
COMMENT ON COLUMN "public"."slmp_pole"."last_id" IS '上一根灯杆';
COMMENT ON TABLE "public"."slmp_pole" IS '用户表';

-- ----------------------------
-- Table structure for slmp_push_command_log
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_push_command_log";
CREATE TABLE "public"."slmp_push_command_log" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(32) COLLATE "pg_catalog"."default",
  "device_type" varchar(32) COLLATE "pg_catalog"."default",
  "channel_number" varchar(64) COLLATE "pg_catalog"."default",
  "batch_no" varchar(64) COLLATE "pg_catalog"."default",
  "mi" int4,
  "identifier" varchar(255) COLLATE "pg_catalog"."default",
  "payload" text COLLATE "pg_catalog"."default",
  "push_time" timestamp(6),
  "poll_time" timestamp(6),
  "result" int4
)
;
COMMENT ON COLUMN "public"."slmp_push_command_log"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_push_command_log"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_push_command_log"."device_type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_push_command_log"."channel_number" IS '设备sn';

-- ----------------------------
-- Table structure for slmp_rain_bucket
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rain_bucket";
CREATE TABLE "public"."slmp_rain_bucket" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_rain_bucket"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."group_ids" IS '组ID集合,多个用逗号分隔';
COMMENT ON COLUMN "public"."slmp_rain_bucket"."model" IS '设备型号';

-- ----------------------------
-- Table structure for slmp_rain_bucket_current_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rain_bucket_current_data";
CREATE TABLE "public"."slmp_rain_bucket_current_data" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "collect_time" timestamp(6),
  "rain" numeric(16,2),
  "rain_1Hours" numeric(16,2),
  "rain_3Hours" numeric(16,2),
  "rain_6Hours" numeric(16,2),
  "rain_24Hours" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."rain" IS '实时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."rain_1Hours" IS '1小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."rain_3Hours" IS '3小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."rain_6Hours" IS '6小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_current_data"."rain_24Hours" IS '24小时降雨量';
COMMENT ON TABLE "public"."slmp_rain_bucket_current_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_rain_bucket_history_data
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rain_bucket_history_data";
CREATE TABLE "public"."slmp_rain_bucket_history_data" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "collect_time" timestamp(6),
  "rain" numeric(16,2),
  "rain_1Hours" numeric(16,2),
  "rain_3Hours" numeric(16,2),
  "rain_6Hours" numeric(16,2),
  "rain_24Hours" numeric(16,2)
)
;
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."rain" IS '实时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."rain_1Hours" IS '1小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."rain_3Hours" IS '3小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."rain_6Hours" IS '6小时降雨量';
COMMENT ON COLUMN "public"."slmp_rain_bucket_history_data"."rain_24Hours" IS '24小时降雨量';
COMMENT ON TABLE "public"."slmp_rain_bucket_history_data" IS '用户表';

-- ----------------------------
-- Table structure for slmp_rtu
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu";
CREATE TABLE "public"."slmp_rtu" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "protocol" varchar(255) COLLATE "pg_catalog"."default",
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default",
  "config_usage" int4 DEFAULT 1,
  "profile_id" int8 DEFAULT 1
)
INHERITS ("public"."slmp_device")
;
COMMENT ON COLUMN "public"."slmp_rtu"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rtu"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_rtu"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_rtu"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_rtu"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_rtu"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_rtu"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_rtu"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_rtu"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_rtu"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_rtu"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_rtu"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_rtu"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_rtu"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_rtu"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_rtu"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_rtu"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_rtu"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_rtu"."protocol" IS 'rtu协议';
COMMENT ON COLUMN "public"."slmp_rtu"."config_usage" IS 'rtu配置 1跟随配置组 2独立配置';
COMMENT ON COLUMN "public"."slmp_rtu"."profile_id" IS '配置组id';

-- ----------------------------
-- Table structure for slmp_rtu_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_config";
CREATE TABLE "public"."slmp_rtu_config" (
  "id" int8 NOT NULL,
  "rtu_id" int8,
  "ratio_a" numeric(8,2),
  "ratio_b" numeric(8,2),
  "ratio_c" numeric(8,2),
  "standard_ia" numeric(8,2),
  "standard_ib" numeric(8,2),
  "standard_ic" numeric(8,2),
  "standard_ua" numeric(8,2),
  "standard_ub" numeric(8,2),
  "standard_uc" numeric(8,2),
  "up_ia" int4,
  "down_ia" int4,
  "up_ua" int4,
  "down_ua" int4,
  "profile_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_rtu_config"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rtu_config"."rtu_id" IS 'rtuId';
COMMENT ON COLUMN "public"."slmp_rtu_config"."ratio_a" IS 'A相电流变比';
COMMENT ON COLUMN "public"."slmp_rtu_config"."ratio_b" IS 'B相电流变比';
COMMENT ON COLUMN "public"."slmp_rtu_config"."ratio_c" IS 'C相电流变比';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_ia" IS 'A相标定电流';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_ib" IS 'B相标定电流';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_ic" IS 'C相标定电流';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_ua" IS 'A相标定电压';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_ub" IS 'B相标定电压';
COMMENT ON COLUMN "public"."slmp_rtu_config"."standard_uc" IS 'C相标定电压';
COMMENT ON COLUMN "public"."slmp_rtu_config"."up_ia" IS '电流上浮';
COMMENT ON COLUMN "public"."slmp_rtu_config"."down_ia" IS '电流下浮';
COMMENT ON COLUMN "public"."slmp_rtu_config"."up_ua" IS '电压上浮';
COMMENT ON COLUMN "public"."slmp_rtu_config"."down_ua" IS '电压下浮';
COMMENT ON COLUMN "public"."slmp_rtu_config"."profile_id" IS 'rtu配置模板id';
COMMENT ON TABLE "public"."slmp_rtu_config" IS '用户表';

-- ----------------------------
-- Table structure for slmp_rtu_config_profile
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_config_profile";
CREATE TABLE "public"."slmp_rtu_config_profile" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(6) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user" varchar(255) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "global_type" bool DEFAULT false
)
;
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."name" IS 'rtu配置模板名称';
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_rtu_config_profile"."global_type" IS '是否全局配置';

-- ----------------------------
-- Table structure for slmp_rtu_current
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_current";
CREATE TABLE "public"."slmp_rtu_current" (
  "id" int8 NOT NULL,
  "rtu_id" int8,
  "auto" int4,
  "collect_time" timestamp(6),
  "ua" numeric(8,2),
  "ia" numeric(8,2),
  "ub" numeric(8,2),
  "ib" numeric(8,2),
  "uc" numeric(8,2),
  "ic" numeric(8,2),
  "rtc_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."slmp_rtu_current"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_rtu_current"."rtu_id" IS 'rtu_id';
COMMENT ON COLUMN "public"."slmp_rtu_current"."auto" IS '手自动 1自动 0手动';
COMMENT ON COLUMN "public"."slmp_rtu_current"."ua" IS '第一路进线A相电压';
COMMENT ON COLUMN "public"."slmp_rtu_current"."ia" IS '第一路进线A相电流';
COMMENT ON COLUMN "public"."slmp_rtu_current"."ub" IS '第一路进线B相电压';
COMMENT ON COLUMN "public"."slmp_rtu_current"."ib" IS '第一路进线B相电流';
COMMENT ON COLUMN "public"."slmp_rtu_current"."uc" IS '第一路进线C相电压';
COMMENT ON COLUMN "public"."slmp_rtu_current"."ic" IS '第一路进线C相电流';
COMMENT ON COLUMN "public"."slmp_rtu_current"."rtc_time" IS 'RTC时间';

-- ----------------------------
-- Table structure for slmp_rtu_history
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_history";
CREATE TABLE "public"."slmp_rtu_history" (
  "id" int8 NOT NULL,
  "message_id" int8,
  "rtu_id" int8,
  "auto" int4,
  "collect_time" timestamp(6),
  "ua" numeric(8,2),
  "ia" numeric(8,2),
  "ub" numeric(8,2),
  "ib" numeric(8,2),
  "uc" numeric(8,2),
  "ic" numeric(8,2),
  "rtc_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."slmp_rtu_history"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_rtu_history"."message_id" IS '消息id';
COMMENT ON COLUMN "public"."slmp_rtu_history"."rtu_id" IS 'rtu_id';
COMMENT ON COLUMN "public"."slmp_rtu_history"."auto" IS '手自动 1自动 0手动';
COMMENT ON COLUMN "public"."slmp_rtu_history"."ua" IS '第一路进线A相电压';
COMMENT ON COLUMN "public"."slmp_rtu_history"."ia" IS '第一路进线A相电流';
COMMENT ON COLUMN "public"."slmp_rtu_history"."ub" IS '第一路进线B相电压';
COMMENT ON COLUMN "public"."slmp_rtu_history"."ib" IS '第一路进线B相电流';
COMMENT ON COLUMN "public"."slmp_rtu_history"."uc" IS '第一路进线C相电压';
COMMENT ON COLUMN "public"."slmp_rtu_history"."ic" IS '第一路进线C相电流';
COMMENT ON COLUMN "public"."slmp_rtu_history"."rtc_time" IS 'RTC时间';

-- ----------------------------
-- Table structure for slmp_rtu_loop_current
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_loop_current";
CREATE TABLE "public"."slmp_rtu_loop_current" (
  "id" int8 NOT NULL,
  "rtu_id" int8,
  "collect_time" timestamp(6),
  "loop_status" int4,
  "ia" numeric(8,2),
  "ib" numeric(8,2),
  "ic" numeric(8,2),
  "i" numeric(8,2),
  "loop_no" varchar(62) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."rtu_id" IS 'rtuId';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."loop_status" IS '回路状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."ia" IS '出线A相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."ib" IS '出线B相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."ic" IS '出线C相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."i" IS '电流 直流配电箱';
COMMENT ON COLUMN "public"."slmp_rtu_loop_current"."loop_no" IS '回路编号';

-- ----------------------------
-- Table structure for slmp_rtu_loop_history
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_rtu_loop_history";
CREATE TABLE "public"."slmp_rtu_loop_history" (
  "id" int8 NOT NULL,
  "message_id" int8,
  "rtu_id" int8,
  "collect_time" timestamp(6),
  "loop_status" int4,
  "ia" numeric(8,2),
  "ib" numeric(8,2),
  "ic" numeric(8,2),
  "i" numeric(8,2),
  "loop_no" varchar(64) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."id" IS '主键id';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."message_id" IS '消息id';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."rtu_id" IS 'rtuid';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."collect_time" IS '采集时间';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."loop_status" IS '回路状态 0关 1开';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."ia" IS '出线A相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."ib" IS '出线B相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."ic" IS '出线C相电流';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."i" IS '电流 直流配电箱';
COMMENT ON COLUMN "public"."slmp_rtu_loop_history"."loop_no" IS '回路编号';

-- ----------------------------
-- Table structure for slmp_solar_panel
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_solar_panel";
CREATE TABLE "public"."slmp_solar_panel" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_solar_panel"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_solar_panel"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_solar_panel"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_solar_panel"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_solar_panel"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_solar_panel"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_solar_panel"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_solar_panel"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_solar_panel"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_solar_panel"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_solar_panel"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_solar_panel"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_solar_panel"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_solar_panel"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_solar_panel"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_solar_panel"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_solar_panel"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_solar_panel"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_solar_panel"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_solar_panel"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_solar_panel"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_solar_panel"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_solar_panel"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_solar_panel"."group_ids" IS '组ID集合,多个用逗号分隔';

-- ----------------------------
-- Table structure for slmp_special_transformer
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_special_transformer";
CREATE TABLE "public"."slmp_special_transformer" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "capacity" varchar(64) COLLATE "pg_catalog"."default",
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "install_time" timestamp(6),
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "management_unit" varchar(64) COLLATE "pg_catalog"."default",
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "completed_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "usage_category" int4,
  "duty_id" int8,
  "mo_type" int4,
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_special_transformer"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_special_transformer"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_special_transformer"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_special_transformer"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_special_transformer"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_special_transformer"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_special_transformer"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_special_transformer"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_special_transformer"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_special_transformer"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_special_transformer"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_special_transformer"."capacity" IS '申报容量';
COMMENT ON COLUMN "public"."slmp_special_transformer"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_special_transformer"."install_time" IS '报装时间';
COMMENT ON COLUMN "public"."slmp_special_transformer"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_special_transformer"."management_unit" IS '管理单位';
COMMENT ON COLUMN "public"."slmp_special_transformer"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_special_transformer"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_special_transformer"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_special_transformer"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_special_transformer"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_special_transformer"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_special_transformer"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_special_transformer"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_special_transformer"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_special_transformer"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_special_transformer"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_special_transformer"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_special_transformer"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_special_transformer"."mo_type" IS '管理对象类型';
COMMENT ON TABLE "public"."slmp_special_transformer" IS '用户表';

-- ----------------------------
-- Table structure for slmp_strategy
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_strategy";
CREATE TABLE "public"."slmp_strategy" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "effect_start" varchar(64) COLLATE "pg_catalog"."default",
  "effect_end" varchar(64) COLLATE "pg_catalog"."default",
  "priority" int4,
  "repeat" int4,
  "execute_date" varchar(255) COLLATE "pg_catalog"."default",
  "usage_device" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_strategy"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_strategy"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_strategy"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_strategy"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_strategy"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_strategy"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_strategy"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_strategy"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_strategy"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_strategy"."name" IS '策略名称';
COMMENT ON COLUMN "public"."slmp_strategy"."effect_start" IS '策略生效日期';
COMMENT ON COLUMN "public"."slmp_strategy"."effect_end" IS '策略失效日期';
COMMENT ON COLUMN "public"."slmp_strategy"."priority" IS '优先级:数字越大,优先级越高';
COMMENT ON COLUMN "public"."slmp_strategy"."repeat" IS '重复:1不重复,2每天重复,3每周重复';
COMMENT ON COLUMN "public"."slmp_strategy"."execute_date" IS '策略执行日期:不重复时为选择的日期,格式yyyy-MM-dd. 按天重复不填. 按周重复格式1-7,逗号分隔,对应周一到周日.';
COMMENT ON COLUMN "public"."slmp_strategy"."usage_device" IS '策略使用设备，仅为了区分策略用在RTU还是单灯上';
COMMENT ON TABLE "public"."slmp_strategy" IS '用户表';

-- ----------------------------
-- Table structure for slmp_strategy_application
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_strategy_application";
CREATE TABLE "public"."slmp_strategy_application" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "loop_no" varchar(64) COLLATE "pg_catalog"."default",
  "strategy_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_strategy_application"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_strategy_application"."device_id" IS '设备id';
COMMENT ON COLUMN "public"."slmp_strategy_application"."loop_no" IS '回路编号';
COMMENT ON COLUMN "public"."slmp_strategy_application"."strategy_id" IS '策略id';
COMMENT ON TABLE "public"."slmp_strategy_application" IS '用户表';

-- ----------------------------
-- Table structure for slmp_strategy_record
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_strategy_record";
CREATE TABLE "public"."slmp_strategy_record" (
  "id" int8 NOT NULL,
  "device_id" int8,
  "loop_no" varchar(64) COLLATE "pg_catalog"."default",
  "effect_date" varchar(10) COLLATE "pg_catalog"."default",
  "plan_time" varchar(255) COLLATE "pg_catalog"."default",
  "real_time" varchar(255) COLLATE "pg_catalog"."default",
  "effected" int4,
  "push_time" timestamp(6),
  "poll_time" timestamp(6)
)
;
COMMENT ON COLUMN "public"."slmp_strategy_record"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_strategy_record"."device_id" IS '设备id';
COMMENT ON COLUMN "public"."slmp_strategy_record"."loop_no" IS '回路编号';
COMMENT ON COLUMN "public"."slmp_strategy_record"."effect_date" IS '策略日期 格式yyyy-MM-dd';
COMMENT ON COLUMN "public"."slmp_strategy_record"."plan_time" IS '计划时间 格式HH:mm';
COMMENT ON COLUMN "public"."slmp_strategy_record"."real_time" IS '实际时间 格式HH:mm';
COMMENT ON COLUMN "public"."slmp_strategy_record"."effected" IS '是否生效 -1未知 0不一致 1一致';
COMMENT ON COLUMN "public"."slmp_strategy_record"."push_time" IS '策略下发时间';
COMMENT ON COLUMN "public"."slmp_strategy_record"."poll_time" IS '策略采集时间';
COMMENT ON TABLE "public"."slmp_strategy_record" IS '用户表';

-- ----------------------------
-- Table structure for slmp_strategy_time
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_strategy_time";
CREATE TABLE "public"."slmp_strategy_time" (
  "id" int8 NOT NULL,
  "strategy_id" int8,
  "execute_time" varchar(12) COLLATE "pg_catalog"."default",
  "value" int4
)
;
COMMENT ON COLUMN "public"."slmp_strategy_time"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_strategy_time"."strategy_id" IS '策略id';
COMMENT ON COLUMN "public"."slmp_strategy_time"."execute_time" IS '执行时间 HH:mm';
COMMENT ON COLUMN "public"."slmp_strategy_time"."value" IS '控制值 0关 1开';
COMMENT ON TABLE "public"."slmp_strategy_time" IS '用户表';

-- ----------------------------
-- Table structure for slmp_switch_box
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_switch_box";
CREATE TABLE "public"."slmp_switch_box" (
  "id" int8 NOT NULL,
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "is_deleted" int4,
  "name" varchar(64) COLLATE "pg_catalog"."default",
  "sn" varchar(64) COLLATE "pg_catalog"."default",
  "vendor" varchar(64) COLLATE "pg_catalog"."default",
  "brand" varchar(64) COLLATE "pg_catalog"."default",
  "longitude" numeric(32,8),
  "latitude" numeric(32,8),
  "transformer_id" int8,
  "road_name" varchar(255) COLLATE "pg_catalog"."default",
  "loop_count" int4,
  "supply_scope" varchar(255) COLLATE "pg_catalog"."default",
  "install_type" int4,
  "type" int4,
  "usage_category" int4,
  "development_unit" varchar(64) COLLATE "pg_catalog"."default",
  "completed_time" timestamp(6),
  "contacts_phone" varchar(64) COLLATE "pg_catalog"."default",
  "handover_status" int4,
  "handover_time" timestamp(6),
  "facility_status" int4,
  "install_address" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "mo_type" int4,
  "model" varchar(255) COLLATE "pg_catalog"."default",
  "attach_url" text COLLATE "pg_catalog"."default"
)
INHERITS ("public"."slmp_managed_object")
;
COMMENT ON COLUMN "public"."slmp_switch_box"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_switch_box"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_switch_box"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_switch_box"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_switch_box"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_switch_box"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_switch_box"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_switch_box"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_switch_box"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_switch_box"."name" IS '名称';
COMMENT ON COLUMN "public"."slmp_switch_box"."sn" IS '资产编号';
COMMENT ON COLUMN "public"."slmp_switch_box"."vendor" IS '供应商';
COMMENT ON COLUMN "public"."slmp_switch_box"."brand" IS '品牌';
COMMENT ON COLUMN "public"."slmp_switch_box"."longitude" IS '经度';
COMMENT ON COLUMN "public"."slmp_switch_box"."latitude" IS '纬度';
COMMENT ON COLUMN "public"."slmp_switch_box"."transformer_id" IS '父级设备-专用变压器';
COMMENT ON COLUMN "public"."slmp_switch_box"."road_name" IS '道路名';
COMMENT ON COLUMN "public"."slmp_switch_box"."loop_count" IS '出线回路数';
COMMENT ON COLUMN "public"."slmp_switch_box"."supply_scope" IS '供电范围';
COMMENT ON COLUMN "public"."slmp_switch_box"."install_type" IS '安装类型 1-壁挂式 2-落地式 3-杆挂式';
COMMENT ON COLUMN "public"."slmp_switch_box"."type" IS '配电箱类型 1-主要街道配电箱 2-小街小巷配电箱';
COMMENT ON COLUMN "public"."slmp_switch_box"."usage_category" IS '使用场景 1-道路照明 2-景观照明';
COMMENT ON COLUMN "public"."slmp_switch_box"."development_unit" IS '建设单位';
COMMENT ON COLUMN "public"."slmp_switch_box"."completed_time" IS '建设完成时间';
COMMENT ON COLUMN "public"."slmp_switch_box"."contacts_phone" IS '联系人电话';
COMMENT ON COLUMN "public"."slmp_switch_box"."handover_status" IS '移交状态 1-未知 2-未移交 3-移交中 4-已移交';
COMMENT ON COLUMN "public"."slmp_switch_box"."handover_time" IS '移交时间';
COMMENT ON COLUMN "public"."slmp_switch_box"."facility_status" IS '设施状态 1-投运 2-检修 3-维修 4-停运';
COMMENT ON COLUMN "public"."slmp_switch_box"."install_address" IS '安装地址';
COMMENT ON COLUMN "public"."slmp_switch_box"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_switch_box"."duty_id" IS '责任区id';
COMMENT ON COLUMN "public"."slmp_switch_box"."model" IS '配电箱型号';
COMMENT ON TABLE "public"."slmp_switch_box" IS '用户表';

-- ----------------------------
-- Table structure for slmp_switch_box_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_switch_box_config";
CREATE TABLE "public"."slmp_switch_box_config" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "model" varchar(255) COLLATE "pg_catalog"."default",
  "has_immersion" bool,
  "immersion_num" int4,
  "has_th" bool,
  "th_num" int4,
  "has_door_sensor" bool,
  "door_sensor_num" int4,
  "has_fan" bool,
  "fan_num" int4,
  "has_lamp" bool,
  "lamp_num" int4,
  "has_camera" bool,
  "camera_num" int4,
  "has_ammeter" bool,
  "ammeter_num" int4,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "has_rtu" bool,
  "rtu_num" int4,
  "has_gateway" bool,
  "gateway_num" int4,
  "has_smoke" bool,
  "smoke_num" int4,
  "loop_num" int4,
  "branch_num" int4
)
;
COMMENT ON COLUMN "public"."slmp_switch_box_config"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."name" IS '配电箱名称';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."model" IS '配电箱型号';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_immersion" IS '是否支持水浸';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."immersion_num" IS '水浸设备数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_th" IS '是否支持温湿度';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."th_num" IS '温湿度设备数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_door_sensor" IS '是否支持门磁';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."door_sensor_num" IS '门磁数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_fan" IS '是否支持风扇';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."fan_num" IS '风扇数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_lamp" IS '是否支持灯带';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."lamp_num" IS '灯带数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_camera" IS '是否支持摄像头';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."camera_num" IS '摄像头数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_ammeter" IS '是否支持电表';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."ammeter_num" IS '电表数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_rtu" IS '是否支持rtu';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."rtu_num" IS 'rtu数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_gateway" IS '是否支持网关';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."gateway_num" IS '网关数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."has_smoke" IS '是否支持烟感';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."smoke_num" IS '烟感数量';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."loop_num" IS '回路数';
COMMENT ON COLUMN "public"."slmp_switch_box_config"."branch_num" IS '支路数';

-- ----------------------------
-- Table structure for slmp_system_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_system_config";
CREATE TABLE "public"."slmp_system_config" (
  "id" int8 NOT NULL,
  "key" varchar(255) COLLATE "pg_catalog"."default",
  "value" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "seq" int4
)
;

-- ----------------------------
-- Table structure for slmp_task
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_task";
CREATE TABLE "public"."slmp_task" (
  "id" int8 NOT NULL,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "cron" varchar(255) COLLATE "pg_catalog"."default",
  "opt" varchar(255) COLLATE "pg_catalog"."default",
  "device_ids" varchar(255) COLLATE "pg_catalog"."default",
  "status" bool,
  "start_time" varchar(255) COLLATE "pg_catalog"."default",
  "end_time" varchar(255) COLLATE "pg_catalog"."default",
  "repeat" int4,
  "execute_time" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_task"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_task"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_task"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_task"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_task"."name" IS '任务名称';
COMMENT ON COLUMN "public"."slmp_task"."cron" IS 'cron表达式';
COMMENT ON COLUMN "public"."slmp_task"."opt" IS '执行命令';
COMMENT ON COLUMN "public"."slmp_task"."device_ids" IS '设备ID，逗号分隔';
COMMENT ON COLUMN "public"."slmp_task"."status" IS '是否启用';
COMMENT ON COLUMN "public"."slmp_task"."start_time" IS '开始时间';
COMMENT ON COLUMN "public"."slmp_task"."end_time" IS '结束时间';
COMMENT ON COLUMN "public"."slmp_task"."repeat" IS '重复:1不重复,2每天重复,3每周重复';
COMMENT ON COLUMN "public"."slmp_task"."execute_time" IS '执行时间点';
COMMENT ON COLUMN "public"."slmp_task"."remark" IS '描述';

-- ----------------------------
-- Table structure for slmp_task_log
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_task_log";
CREATE TABLE "public"."slmp_task_log" (
  "id" int8 NOT NULL,
  "created_time" timestamp(6),
  "updated_time" timestamp(6),
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "start_time" timestamp(6),
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "device_ids" varchar(255) COLLATE "pg_catalog"."default",
  "task_id" int8
)
;
COMMENT ON COLUMN "public"."slmp_task_log"."id" IS '主键ID';
COMMENT ON COLUMN "public"."slmp_task_log"."created_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_task_log"."updated_time" IS '更新时间';
COMMENT ON COLUMN "public"."slmp_task_log"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "public"."slmp_task_log"."name" IS '任务名称';
COMMENT ON COLUMN "public"."slmp_task_log"."start_time" IS '执行时间';
COMMENT ON COLUMN "public"."slmp_task_log"."status" IS '执行状态';
COMMENT ON COLUMN "public"."slmp_task_log"."device_ids" IS '设备ID，逗号分隔';
COMMENT ON COLUMN "public"."slmp_task_log"."task_id" IS '任务配置ID';

-- ----------------------------
-- Table structure for slmp_tenant_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_tenant_config";
CREATE TABLE "public"."slmp_tenant_config" (
  "id" int8 NOT NULL,
  "tenant" varchar(255) COLLATE "pg_catalog"."default",
  "key" varchar(255) COLLATE "pg_catalog"."default",
  "value" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "seq" int4
)
;
COMMENT ON COLUMN "public"."slmp_tenant_config"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_tenant_config"."tenant" IS '租户';
COMMENT ON COLUMN "public"."slmp_tenant_config"."seq" IS '排序';

-- ----------------------------
-- Table structure for slmp_voice_module
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_voice_module";
CREATE TABLE "public"."slmp_voice_module" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_voice_module"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_voice_module"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_voice_module"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_voice_module"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_voice_module"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_voice_module"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_voice_module"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_voice_module"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_voice_module"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_voice_module"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_voice_module"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_voice_module"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_voice_module"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_voice_module"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_voice_module"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_voice_module"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_voice_module"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_voice_module"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_voice_module"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_voice_module"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_voice_module"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_voice_module"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_voice_module"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_voice_module"."group_ids" IS '组ID集合,多个用逗号分隔';

-- ----------------------------
-- Table structure for slmp_water_level_gauge
-- ----------------------------
DROP TABLE IF EXISTS "public"."slmp_water_level_gauge";
CREATE TABLE "public"."slmp_water_level_gauge" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "channel_number" varchar(255) COLLATE "pg_catalog"."default",
  "pole_id" int8,
  "gateway_id" int8,
  "vendor" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "is_deleted" int4,
  "create_user" int8,
  "create_dept" int8,
  "create_time" timestamp(6),
  "update_user" int8,
  "update_time" timestamp(6),
  "status" int4,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(12) COLLATE "pg_catalog"."default",
  "online_status" int4 DEFAULT '-1'::integer,
  "gateway_port" varchar(255) COLLATE "pg_catalog"."default",
  "managed_object_id" int8,
  "mo_type" int4,
  "mo_name" varchar(255) COLLATE "pg_catalog"."default",
  "duty_id" int8,
  "group_id" int8,
  "group_ids" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."id" IS '主键';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."name" IS '设备名称';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."channel_number" IS '设备系列号';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."pole_id" IS '归属灯杆';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."gateway_id" IS '所属网关';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."vendor" IS '设备厂家';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."type" IS '设备类型';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."is_deleted" IS '是否已删除';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."create_user" IS '创建人';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."update_user" IS '修改人';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."status" IS '状态';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."remark" IS '备注';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."online_status" IS '在线状态';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."gateway_port" IS '使用的网关端口';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."managed_object_id" IS '设施id';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."mo_type" IS '管理对象类型 1变压器 2配电箱 3灯杆 4灯具';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."mo_name" IS '所属设施名';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."duty_id" IS '责任区ID';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."group_id" IS '组ID';
COMMENT ON COLUMN "public"."slmp_water_level_gauge"."group_ids" IS '组ID集合,多个用逗号分隔';

-- ----------------------------
-- Primary Key structure for table blade_attach
-- ----------------------------
ALTER TABLE "public"."blade_attach" ADD CONSTRAINT "blade_attach_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_client
-- ----------------------------
ALTER TABLE "public"."blade_client" ADD CONSTRAINT "blade_client_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_code
-- ----------------------------
ALTER TABLE "public"."blade_code" ADD CONSTRAINT "blade_code_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_datasource
-- ----------------------------
ALTER TABLE "public"."blade_datasource" ADD CONSTRAINT "blade_datasource_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_dept
-- ----------------------------
ALTER TABLE "public"."blade_dept" ADD CONSTRAINT "blade_dept_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_dict
-- ----------------------------
ALTER TABLE "public"."blade_dict" ADD CONSTRAINT "blade_dict_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_dict_biz
-- ----------------------------
ALTER TABLE "public"."blade_dict_biz" ADD CONSTRAINT "blade_dict_biz_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_log_api
-- ----------------------------
ALTER TABLE "public"."blade_log_api" ADD CONSTRAINT "blade_log_api_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_log_error
-- ----------------------------
ALTER TABLE "public"."blade_log_error" ADD CONSTRAINT "blade_log_error_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_log_usual
-- ----------------------------
ALTER TABLE "public"."blade_log_usual" ADD CONSTRAINT "blade_log_usual_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_menu
-- ----------------------------
ALTER TABLE "public"."blade_menu" ADD CONSTRAINT "blade_menu_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_notice
-- ----------------------------
ALTER TABLE "public"."blade_notice" ADD CONSTRAINT "blade_notice_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_oss
-- ----------------------------
ALTER TABLE "public"."blade_oss" ADD CONSTRAINT "blade_oss_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_param
-- ----------------------------
ALTER TABLE "public"."blade_param" ADD CONSTRAINT "blade_param_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_post
-- ----------------------------
ALTER TABLE "public"."blade_post" ADD CONSTRAINT "blade_post_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_process_leave
-- ----------------------------
ALTER TABLE "public"."blade_process_leave" ADD CONSTRAINT "blade_process_leave_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_region
-- ----------------------------
ALTER TABLE "public"."blade_region" ADD CONSTRAINT "blade_region_pkey" PRIMARY KEY ("code");

-- ----------------------------
-- Primary Key structure for table blade_report_file
-- ----------------------------
ALTER TABLE "public"."blade_report_file" ADD CONSTRAINT "blade_report_file_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_role
-- ----------------------------
ALTER TABLE "public"."blade_role" ADD CONSTRAINT "blade_role_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_role_menu
-- ----------------------------
ALTER TABLE "public"."blade_role_menu" ADD CONSTRAINT "blade_role_menu_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_role_scope
-- ----------------------------
ALTER TABLE "public"."blade_role_scope" ADD CONSTRAINT "blade_role_scope_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_scope_api
-- ----------------------------
ALTER TABLE "public"."blade_scope_api" ADD CONSTRAINT "blade_scope_api_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_scope_data
-- ----------------------------
ALTER TABLE "public"."blade_scope_data" ADD CONSTRAINT "blade_scope_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_sms
-- ----------------------------
ALTER TABLE "public"."blade_sms" ADD CONSTRAINT "blade_sms_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_tenant
-- ----------------------------
ALTER TABLE "public"."blade_tenant" ADD CONSTRAINT "blade_tenant_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_top_menu
-- ----------------------------
ALTER TABLE "public"."blade_top_menu" ADD CONSTRAINT "blade_top_menu_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_top_menu_setting
-- ----------------------------
ALTER TABLE "public"."blade_top_menu_setting" ADD CONSTRAINT "blade_top_menu_setting_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user
-- ----------------------------
ALTER TABLE "public"."blade_user" ADD CONSTRAINT "blade_user_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user_app
-- ----------------------------
ALTER TABLE "public"."blade_user_app" ADD CONSTRAINT "blade_user_app_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user_dept
-- ----------------------------
ALTER TABLE "public"."blade_user_dept" ADD CONSTRAINT "blade_user_dept_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user_oauth
-- ----------------------------
ALTER TABLE "public"."blade_user_oauth" ADD CONSTRAINT "blade_user_oauth_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user_other
-- ----------------------------
ALTER TABLE "public"."blade_user_other" ADD CONSTRAINT "blade_user_other_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table blade_user_web
-- ----------------------------
ALTER TABLE "public"."blade_user_web" ADD CONSTRAINT "blade_user_web_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_ac_box_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_ac_box_current_data" ADD CONSTRAINT "slmp_dc_box_current_data_copy1_pkey2" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_ac_box_device
-- ----------------------------
ALTER TABLE "public"."slmp_ac_box_device" ADD CONSTRAINT "slmp_dc_box_device_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_ac_box_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_ac_box_history_data" ADD CONSTRAINT "slmp_ac_box_current_data_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_ac_box_total_data
-- ----------------------------
ALTER TABLE "public"."slmp_ac_box_total_data" ADD CONSTRAINT "slmp_ac_box_total_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_alarm
-- ----------------------------
ALTER TABLE "public"."slmp_alarm" ADD CONSTRAINT "slmp_base_copy1_pkey5" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_alarm_dict
-- ----------------------------
ALTER TABLE "public"."slmp_alarm_dict" ADD CONSTRAINT "slmp_alarm_suppress_rule_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_alarm_suppress_device
-- ----------------------------
ALTER TABLE "public"."slmp_alarm_suppress_device" ADD CONSTRAINT "slmp_alarm_suppress_rule_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_alarm_suppress_rule
-- ----------------------------
ALTER TABLE "public"."slmp_alarm_suppress_rule" ADD CONSTRAINT "slmp_alarm_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_base
-- ----------------------------
ALTER TABLE "public"."slmp_base" ADD CONSTRAINT "slmp_switch_box_copy1_pkey2" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table slmp_call_data
-- ----------------------------
CREATE INDEX "slmp_call_data_idx1" ON "public"."slmp_call_data" USING btree (
  "device_channel_number" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST,
  "ring_time" "pg_catalog"."timestamp_ops" ASC NULLS LAST,
  "handup_time" "pg_catalog"."timestamp_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table slmp_call_data
-- ----------------------------
ALTER TABLE "public"."slmp_call_data" ADD CONSTRAINT "slmp_call_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_branch_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_branch_current_data" ADD CONSTRAINT "slmp_dc_box_current_data_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_branch_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_branch_history_data" ADD CONSTRAINT "slmp_dc_box_branch_current_data_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_current_data" ADD CONSTRAINT "slmp_base_copy1_pkey8" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_device
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_device" ADD CONSTRAINT "slmp_device_ammeter_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_history_data" ADD CONSTRAINT "slmp_dc_box_current_data_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_box_strategy
-- ----------------------------
ALTER TABLE "public"."slmp_dc_box_strategy" ADD CONSTRAINT "slmp_base_copy1_pkey9" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_dc_switch_box
-- ----------------------------
ALTER TABLE "public"."slmp_dc_switch_box" ADD CONSTRAINT "slmp_switch_box_copy1_pkey3" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device
-- ----------------------------
ALTER TABLE "public"."slmp_device" ADD CONSTRAINT "slmp_device_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_ammeter
-- ----------------------------
ALTER TABLE "public"."slmp_device_ammeter" ADD CONSTRAINT "slmp_device_immersion_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_audio
-- ----------------------------
ALTER TABLE "public"."slmp_device_audio" ADD CONSTRAINT "slmp_device_audio_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_call
-- ----------------------------
ALTER TABLE "public"."slmp_device_call" ADD CONSTRAINT "slmp_device_call_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_door_sensor
-- ----------------------------
ALTER TABLE "public"."slmp_device_door_sensor" ADD CONSTRAINT "slmp_device_immersion_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_immersion
-- ----------------------------
ALTER TABLE "public"."slmp_device_immersion" ADD CONSTRAINT "slmp_device_immersion_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_screen
-- ----------------------------
ALTER TABLE "public"."slmp_device_screen" ADD CONSTRAINT "slmp_device_screen_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_screen_config
-- ----------------------------
ALTER TABLE "public"."slmp_device_screen_config" ADD CONSTRAINT "slmp_device_screen_config_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_screen_play_his
-- ----------------------------
ALTER TABLE "public"."slmp_device_screen_play_his" ADD CONSTRAINT "slmp_base_copy1_pkey11" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table slmp_device_screen_program
-- ----------------------------
CREATE INDEX "screen_program_idx1" ON "public"."slmp_device_screen_program" USING btree (
  "device_id" "pg_catalog"."int8_ops" ASC NULLS LAST,
  "create_time" "pg_catalog"."timestamp_ops" ASC NULLS LAST
);
CREATE INDEX "screen_program_idx2" ON "public"."slmp_device_screen_program" USING btree (
  "device_id" "pg_catalog"."int8_ops" ASC NULLS LAST,
  "batch_no" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table slmp_device_screen_program
-- ----------------------------
ALTER TABLE "public"."slmp_device_screen_program" ADD CONSTRAINT "pk_slmp_device_screen_program" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_device_screen_resource
-- ----------------------------
ALTER TABLE "public"."slmp_device_screen_resource" ADD CONSTRAINT "slmp_device_screen_config_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_environmental_detector
-- ----------------------------
ALTER TABLE "public"."slmp_environmental_detector" ADD CONSTRAINT "slmp_environmental_detector_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_flood_control_station
-- ----------------------------
ALTER TABLE "public"."slmp_flood_control_station" ADD CONSTRAINT "slmp_managed_object_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_gateway
-- ----------------------------
ALTER TABLE "public"."slmp_gateway" ADD CONSTRAINT "slmp_base_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_gateway_wifi_cfg
-- ----------------------------
ALTER TABLE "public"."slmp_gateway_wifi_cfg" ADD CONSTRAINT "slmp_gateway_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_hx_box_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_hx_box_current_data" ADD CONSTRAINT "slmp_hx_box_current_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_hx_box_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_hx_box_history_data" ADD CONSTRAINT "slmp_hx_box_history_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_io_module_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_io_module_current_data" ADD CONSTRAINT "slmp_base_copy1_pkey10" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_io_module_device
-- ----------------------------
ALTER TABLE "public"."slmp_io_module_device" ADD CONSTRAINT "slmp_device_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_io_module_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_io_module_history_data" ADD CONSTRAINT "slmp_io_module_current_data_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_lamp
-- ----------------------------
ALTER TABLE "public"."slmp_lamp" ADD CONSTRAINT "slmp_device_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_lamps
-- ----------------------------
ALTER TABLE "public"."slmp_lamps" ADD CONSTRAINT "slmp_switch_box_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_managed_object
-- ----------------------------
ALTER TABLE "public"."slmp_managed_object" ADD CONSTRAINT "slmp_base_copy1_pkey3" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_managed_object_attach
-- ----------------------------
ALTER TABLE "public"."slmp_managed_object_attach" ADD CONSTRAINT "slmp_base_copy1_pkey2" PRIMARY KEY ("id");

-- ----------------------------
-- Indexes structure for table slmp_monitor_data
-- ----------------------------
CREATE INDEX "slmp_monitor_data_idx1" ON "public"."slmp_monitor_data" USING btree (
  "device_channel_number" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST,
  "identifier" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "slmp_monitor_data_idx2" ON "public"."slmp_monitor_data" USING btree (
  "collect_time" "pg_catalog"."timestamp_ops" ASC NULLS LAST
);

-- ----------------------------
-- Primary Key structure for table slmp_monitor_data
-- ----------------------------
ALTER TABLE "public"."slmp_monitor_data" ADD CONSTRAINT "slmp_monitor_data_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_multiple_strategy_record
-- ----------------------------
ALTER TABLE "public"."slmp_multiple_strategy_record" ADD CONSTRAINT "slmp_multiple_strategy_record_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_pole
-- ----------------------------
ALTER TABLE "public"."slmp_pole" ADD CONSTRAINT "slmp_switch_box_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_rain_bucket
-- ----------------------------
ALTER TABLE "public"."slmp_rain_bucket" ADD CONSTRAINT "slmp_device_copy1_pkey2" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_rain_bucket_current_data
-- ----------------------------
ALTER TABLE "public"."slmp_rain_bucket_current_data" ADD CONSTRAINT "slmp_io_module_current_data_copy1_pkey1" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_rain_bucket_history_data
-- ----------------------------
ALTER TABLE "public"."slmp_rain_bucket_history_data" ADD CONSTRAINT "slmp_rain_bucket_current_data_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_rtu
-- ----------------------------
ALTER TABLE "public"."slmp_rtu" ADD CONSTRAINT "slmp_lamp_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_rtu_config
-- ----------------------------
ALTER TABLE "public"."slmp_rtu_config" ADD CONSTRAINT "slmp_base_copy1_pkey4" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_solar_panel
-- ----------------------------
ALTER TABLE "public"."slmp_solar_panel" ADD CONSTRAINT "slmp_device_copy1_pkey3" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_special_transformer
-- ----------------------------
ALTER TABLE "public"."slmp_special_transformer" ADD CONSTRAINT "blade_user_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_strategy
-- ----------------------------
ALTER TABLE "public"."slmp_strategy" ADD CONSTRAINT "slmp_base_copy1_pkey6" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_strategy_application
-- ----------------------------
ALTER TABLE "public"."slmp_strategy_application" ADD CONSTRAINT "slmp_base_copy1_pkey7" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_strategy_record
-- ----------------------------
ALTER TABLE "public"."slmp_strategy_record" ADD CONSTRAINT "slmp_rtu_strategy_application_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_strategy_time
-- ----------------------------
ALTER TABLE "public"."slmp_strategy_time" ADD CONSTRAINT "slmp_rtu_strategy_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_switch_box
-- ----------------------------
ALTER TABLE "public"."slmp_switch_box" ADD CONSTRAINT "slmp_special_transformer_copy1_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_voice_module
-- ----------------------------
ALTER TABLE "public"."slmp_voice_module" ADD CONSTRAINT "slmp_device_copy1_pkey4" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table slmp_water_level_gauge
-- ----------------------------
ALTER TABLE "public"."slmp_water_level_gauge" ADD CONSTRAINT "slmp_device_copy1_pkey5" PRIMARY KEY ("id");
