#!/bin/sh

. /lib/functions/network.sh
help()
{
    cat <<_HELP_
Setup virtual AP.
Usage: $0 {set|stop} {ap|sta|mesh} [-ssid SSID] [-mesh_id MESH_ID ][-key PASSWORD ] [-name NAME ][-B] [-P]

        -ssid SSID # Only the AP and station modes are valid
        -mesh_id MEDH_ID # Only the mesh modes is valid
        -key PASSWORD # Must be greater than 8 characters
        -name NAME# Virtual AP section named, vapNM n:0~1 M:0
        -P # Portal AP flag 
        -B # Enable base64 decode for SSID and MESH ID 
Example:
    $0 set ap -name vap00 -B -ssid MTIzMjEzCg== -key password 
    $0 set mesh -name vap10 -B -P -mesh_id MTIzMjEzCg== -key password
    $0 set mesh -name vap10 -P -mesh_id 123213 -key password
    $0 stop -name vap10 
_HELP_
}

if [ $# -lt 3 ] ;then 
	help;
	exit 1;
fi

case "$1" in
    set)action="$1";; 
    stop)action="$1";;
    *) help; exit 1;;
esac
shift 1


disable_vap()
{
uci batch << EOF
set wireless.$name.disabled='1'
commit wireless
EOF
}


if [ "$action" == "stop" ];then
case $1 in
    -name) 
	name="$2";shift 2
	disable_vap
	exit;;
    *);;
esac

fi

case "$1" in
    ap) mode="$1"
	shift 1;;
    sta) mode="$1"
	shift 1;;
    mesh) mode="$1"
	shift 1;;
    *) 
	help; exit 1
	;;
esac


	

while [ -n "$1" ]; do
    case $1 in
        -name) name="$2";shift 2;;
        -ssid) ssid="$2";shift 2;;
        -key) key="$2";shift 2;;
        -mesh_id) ssid="$2";shift 2;;
        -B) base64='1';shift 1;;
        -P) portal='1';shift 1;;
        -S) no_restart='1';shift 1;;
        --) shift;break;;
        -*) help;exit 1;;
        *) break;;
    esac
done

if [ "${name:0:3}" != "vap" ];then
echo "${name:0:3}"
	help;exit 1;
fi


if [ "${name:3:1}" == '0' ];then
	radio="radio0"
elif [ "${name:3:1}" == '1' ];then
	radio="radio1"
else
	help;exit 1;
fi


len=`echo $key | wc -c`
if [ "$len" -lt 9 ];then
echo "-key size too short";exit 1;
fi

if [ "$base64" == 1 ];then
	ssid=`echo "$ssid" | base64 -d`	
	echo "ssid = $ssid"
fi

set_metric()
{
uci batch << EOF
set network.wifiwan.metric="$1"
commit network
EOF
}

set_ap_mode()
{

uci batch << EOF
delete  wireless."$name"
set wireless."$name"='wifi-iface'
set wireless."$name".device="$radio"
set wireless."$name".mode="$mode"
set wireless."$name".key="$key"
set wireless."$name".ssid="$ssid"
set wireless."$name".encryption="psk-mixed"
set wireless."$name".network="lan"
set wireless."$name".disabled="0"
commit wireless
EOF
}


set_sta_mode()
{
uci batch << EOF
delete  wireless."$name"
set wireless."$name"='wifi-iface'
set wireless.$name.device="$radio"
set wireless.$name.mode="$mode"
set wireless.$name.key="$key"
set wireless.$name.ssid="$ssid"
set wireless.$name.encryption="psk-mixed"
set wireless.$name.network="wifiwan"
set wireless.$name.disabled="0"
commit wireless
EOF
}


set_mesh_mode()
{
uci batch << EOF
delete  wireless."$name"
set wireless."$name"='wifi-iface'
set wireless.$name.device="$radio"
set wireless.$name.mode="$mode"
set wireless.$name.key="$key"
set wireless.$name.mesh_id="$ssid"
set wireless.$name.encryption="psk-mixed"
set wireless.$name.network="$1"
set wireless.$name.disabled="0"
commit wireless
EOF
}

case "$mode" in
    ap) 
	set_ap_mode 
	;;
    sta) 
	set_sta_mode
	set_metric 10
	
	;;
    mesh)
	if [ "$portal" == '1' ];then
		set_mesh_mode "meshlan"
	else 

		set_mesh_mode "wifiwan"
		set_metric 40
	fi 
	;;
    *) help; exit 1;;
esac

shift 1;


if [ -z "$no_restart" ]; then
    /etc/init.d/network reload
fi

exit 0
