#!/bin/sh

. /lib/functions.sh

help()
{
    cat <<_HELP_
Set NTP server configuration
Usage: $0 set -h <host> -p <port> [-S]
        -h NTP server name
        -p NTP server port
        -z timezone
Example:
    $0 set -h openwrt.pool.ntp.org -p 123
_HELP_
}

shift 1

while [ -n "$1" ]; do
    case $1 in
        -h) host="$2"; shift 2;;
        -p) port="$2";shift 2;;
        -z) tz="$2";shift 2;;
        --) shift;break;;
        -*) help;exit 1;;
        *) break;;
    esac
done

# clear old config
uci delete system.ntp.server

[ $tz ] && uci set system.system.timezone=$tz

uci set system.ntp.enabled=1
uci add_list system.ntp.server=$host
uci set system.ntp.port=$port

uci commit system

/etc/init.d/sysntpd restart

echo "Set NTP server to $host:$port"
exit 0
