#!/bin/sh

help()
{
    cat <<_HELP_
Setup bridge mode.
Usage: $0 {set|del}
Example:
    $0 set # Set bridge mode.
    $0 del # Set router mode.
_HELP_
}

if [ $# -ne 1 ]; then
    help
    exit 1
fi

case $1 in
    set) cmd="$1";;
    del) cmd="$1";;
    *) help; exit 1;;
esac

if [ "$cmd" == "set" ]
then
    uci set system.system.netmodel="1"
else
    uci set system.system.netmodel="0"
fi
uci commit system

if [ "$cmd" == "set" ]
then
    echo "Set bridge mode"
else
    echo "Set router mode"
fi

exit 0
