#!/bin/sh

opkg_service_trap() {
    cp /etc/opkg/distfeeds.conf_bak /etc/opkg/distfeeds.conf
    rm /etc/opkg/distfeeds.conf_bak
}
trap 'opkg_service_trap; exit 1' INT TERM ABRT QUIT ALRM

help() {
    cat <<_HELP_
opkg service wrapper

Usage:  $0 {list|update|delete} [--serv IP:PORT] [--name NAME]
        $0 list
        $0 update --serv URL --name NAME
        $0 delete --name NAME
        
        --serv IP:PORT # ip:port of SW repos
        --name NAME # SW module name
Example:
    $0 list
    $0 update --serv 183.169.132.54:80 --name gw_lora_v2
    $0 delete --name gw_lora_v2
_HELP_
}

case "$1" in
list) cmd="$1" ;;
update) cmd="$1" ;;
delete) cmd="$1" ;;
*)
    help
    exit 1
    ;;
esac
shift 1

while [ -n "$1" ]; do
    case $1 in
    --serv)
        serv="$2"
        shift 2
        ;;
    --name)
        name="$2"
        shift 2
        ;;
    --)
        shift
        break
        ;;
    -*)
        help
        exit 1
        ;;
    *) break ;;
    esac
done

. /usr/share/libubox/jshn.sh

do_list() {
    listed_sw="ali_sport base-files curl dragino_lorawan_server firewall frpc gw_lora_v2
               huayun ip-tiny ipset iptables iw lg02_pkt_fwd linkkit_gateway logd
               lua lua-pack luabitop node paho_mqtt python strace tcpdump uhttpd vpnc
               wget whsnbg device_monitor ffmpeg python-pip rs485 rule_eng swconfig virtual_dev
               virtual_interfaces xieneng_car cloud_conn_dayun rtlap lora_serv lora ip_camera
               comm_socket upgrade jshn jsonfilter config_manager dy_reset_button data_reporter
               azure azure-iot arpoison can_mqtt_proxy shanghai_S5  ip_soundbox
               soundbox_data_server ip_alarm node-realtimeserver alink lanzhuo "
    cache_opkg_list=$(/bin/opkg list-installed)

    json_init
    json_add_array "apps"
    for sw in $listed_sw; do
        sw_name=$(echo "$cache_opkg_list" | awk -F ' - ' '/'"$sw"[^-].'/{print $1}')
        sw_version=$(echo "$cache_opkg_list" | awk -F ' - ' '/'"$sw"[^-].'/{print $2}')
        [ -n "$sw_name" -a -n "$sw_version" ] && {
            json_add_object
            json_add_string "name" "$sw_name"
            json_add_string "version" "$sw_version"
            json_close_object
        }
    done
    json_dump
    return 0
}

do_update() {
    sw_name="$1"
    serv="$2"
    killall opkg
    [ -n "$serv" ] && {
        url=$(cat /etc/opkg/distfeeds.conf | grep lnxall_package | awk '{print $3}' | sed "s/iot.lnxall.com/$serv/")
        wget -t 2 -T 30 ${url}/Packages.gz -O /tmp/Packages.gz
        ret="$?"
        rm -rfv /tmp/Packages.gz
        if [ "$ret" == "0" ]; then
            cp /etc/opkg/distfeeds.conf /etc/opkg/distfeeds.conf_bak
            sed -i 's#http://.*/repository/#http://'"${serv}"'/repository_gw/#g' /etc/opkg/distfeeds.conf
        else
            cat /etc/opkg/distfeeds.conf
            cp /etc/opkg/distfeeds.conf_bak /etc/opkg/distfeeds.conf
            rm /etc/opkg/distfeeds.conf_bak
            return 2
        fi
        cat /etc/opkg/distfeeds.conf
    }
    /bin/opkg update >/tmp/install.log 2>&1
    ret="$?"
    [ "$ret" != "0" ] && {
        cat /tmp/install.log
    }
    /bin/opkg remove --force-depends "$sw_name" >/tmp/install.log 2>&1
    ret="$?"
    [ "$ret" != "0" ] && {
        cat /tmp/install.log
        cp /etc/opkg/distfeeds.conf_bak /etc/opkg/distfeeds.conf
        rm /etc/opkg/distfeeds.conf_bak
        return 4
    }
    /bin/opkg install "$sw_name" >/tmp/install.log 2>&1
    ret="$?"
    [ "$ret" != "0" ] && {
        cat /tmp/install.log
        cp /etc/opkg/distfeeds.conf_bak /etc/opkg/distfeeds.conf
        rm /etc/opkg/distfeeds.conf_bak
        return 5
    }
    cat /tmp/install.log
    cp /etc/opkg/distfeeds.conf_bak /etc/opkg/distfeeds.conf
    rm /etc/opkg/distfeeds.conf_bak
    return 0
}

do_delete() {
    sw_name=$1
    /bin/opkg remove "$sw_name" >/tmp/install.log 2>&1
    ret="$?"
    [ "$ret" != "0" ] && {
        cat /tmp/install.log
        return 5
    }
    cat /tmp/install.log
    return 0
}

case "$cmd" in
list)
    do_list
    ;;
update)
    [ -z "$name" ] && {
        help
        exit 1
    }
    do_update "$name" "$serv"
    return "$?"
    ;;
delete)
    [ -z "$name" ] && {
        help
        exit 1
    }
    do_delete "$name"
    return "$?"
    ;;
*)
    help
    exit 1
    ;;
esac
