#!/usr/bin/awk -f
#sta[n]["mac"]
#sta[n]["ip"]
#sta[n]["rssi"]
#sta[n]["rx pack"]
#sta[n]["tx pack"]
#iw dev wlan0 station dump

BEGIN	{
i=0
}

{
if(match($0,"Station")){
	if(i != 0)
	{
	sta[i-1]=sprintf("{\"mac\":\"%s\",  \"rx_bytes\":\"%s\",\"tx_bytes\":\"%s\",  \"rx_bitrate\":\"%s\",\"tx_bitrate\":\"%s\",  \"rx_packets\":\"%s\",\"tx_packets\":\"%s\",  \"signal_avg\":\"%s\",\"connected_time\":\"%s\",\"expected_throughput\":\"%s\"}\n",\
	mac,rx_bytes,tx_bytes,rx_bitrate,tx_bitrate,rx_packets,tx_packets,signal_avg,connected_time,expected_throughput)
	}

	mac=$2
	i++
}
else if(match($0,"rx bytes")){
	rx_bytes=$3
}
else if(match($0,"tx bytes")){
	tx_bytes=$3
}
else if(match($0,"rx bitrate")){
	rx_bitrate=$3
}
else if(match($0,"tx bitrate")){
	tx_bitrate=$3
}
else if(match($0,"rx packets")){
	rx_packets=$3
}
else if(match($0,"tx packets")){
	tx_packets=$3
}
else if(match($0,"signal avg") && !match($0,"beacon signal avg")){
	signal_avg=$3
}
else if(match($0,"connected time")){
	connected_time=$3
}
else if(match($0,"expected throughput")){
	expected_throughput=$3
}

}

END	{

	sta[i-1]=sprintf("{\"mac\":\"%s\",  \"rx_bytes\":\"%s\",\"tx_bytes\":\"%s\",  \"rx_bitrate\":\"%s\",\"tx_bitrate\":\"%s\",  \"rx_packets\":\"%s\",\"tx_packets\":\"%s\",  \"signal_avg\":\"%s\",\"connected_time\":\"%s\",\"expected_throughput\":\"%s\"}\n",\
	mac,rx_bytes,tx_bytes,rx_bitrate,tx_bitrate,rx_packets,tx_packets,signal_avg,connected_time,expected_throughput)
	
#	head=sprintf("{\"station_info\":[")
	out=sprintf("%s",head)
	for(m=0; m<i; m++)
	{
	if(m == 0){
		out=sprintf("%s\n%s",out,sta[m])
	}
	else{	
		out=sprintf("%s,%s",out,sta[m])
	}
	}
	#tail=sprintf("]}")
	out=sprintf("%s%s",out,tail)
	print  out

}
