#!/bin/sh
tmpfile=/tmp/wireless.tmp
radio_map="wlan0 wlan1"

. /usr/share/libubox/jshn.sh


fetch_radio()
{
	
	json_init
	json_add_array "radio_list"

	for _status in $(echo $radio_map)
	do

	json_add_object

	wlan="$_status"
	iw_dev_info=`iw dev "$wlan" info`
	iw_config=`iwconfig "$wlan"`
	iw_info=`iwinfo "$wlan" info`
	iw_dev_survey=`iw dev "$wlan" survey dump`
#----------------------------------------------------------------------------------------------------------------------#
	json_add_string "mac" 		"$(echo "$iw_dev_info"  | sed s/[[:space:]]// | awk  '/^addr/  {print $2}')"
	json_add_string "type"  	"$(echo "$iw_dev_info"  | sed s/[[:space:]]// | awk '/^type/  {print $2 }')"

	json_add_string "channel" 	"$(echo "$iw_dev_info"  | sed s/[[:space:]]// | awk  '/^channel/  {print $2}')"
	json_add_string "width" 	"$(echo "$iw_dev_info"  | sed s/[[:space:]]// | awk  '/^channel/  {print $6}')"
	json_add_string "center1" 	"$(echo "$iw_dev_info"  | sed s/[[:space:]]// | awk  '/^channel/  {print $9}')"
	
#----------------------------------------------------------------------------------------------------------------------#
	json_add_string "protocol" 	"$(echo "$iw_config"   	| sed s/[[:space:]]// | awk  '/^wlan0/  {print  $3}')"
	json_add_string "tx_power" 	"$(echo "$iw_config"   	| sed s/[[:space:]]// | awk -F'=' '/^wlan0/  {print $2}')"

#----------------------------------------------------------------------------------------------------------------------#
	json_add_string "ssid" 		"$(echo "$iw_info"  	| sed s/[[:space:]]// | awk  -F':' '/^wlan0 /  {print $2}'	| sed s/unknown//)"
	json_add_string "encryption" 	"$(echo "$iw_info"  	| grep 'Encry' 	| awk  -F':' '  {print $2}' | awk '{print $1}' | sed s/unknown//)"
	json_add_string "bitrate" 	"$(echo "$iw_info"  	| grep 'Bit' 	| awk  -F':' '  {print $2}' | awk '{print $1}' | sed s/unknown//)"
	json_add_string "link_quality" 	"$(echo "$iw_info" 	| grep 'Link' 	| awk  -F':' '  {print $3}' | awk '{print $1}' | sed s/unknown//)"
	json_add_string "signal" 	"$(echo "$iw_info"  	| grep 'Sign' 	| awk  -F':' '  {print $2}' | awk '{print $1}' | sed s/unknown//)"
#----------------------------------------------------------------------------------------------------------------------#
	active="$(echo "$iw_dev_survey"  | grep 'channel active' 	| awk  -F':' '  {print $2}' | awk '{print $1}')"
	busy="$(echo "$iw_dev_survey"  | grep 'channel busy' 	| grep   -v 'extension' | awk  -F':' '  {print $2}' | awk '{print $1}')"
	if [ -n "$busy" ] ;then
	json_add_string "used_rate" 	"$(expr ${busy} \* 100 \/ ${active})"
	fi
#----------------------------------------------------------------------------------------------------------------------#
	json_close_object
	done
	json_dump
}

case  "$1" in
	status)
	phy_list=`iw dev`
	[ -z "$phy_list" ] && echo '{}' && exit 0
	fetch_radio
	;;
	*)
	exit 1
	;;

esac
