#!/bin/sh

. /usr/share/libubox/jshn.sh

fetch_wifi() {
    intf=$1
    intf_list=$(iw dev | awk '/Interface/{print $2}' | grep $intf | tr '\n' ',')

    OLD_IFS="$IFS" #保存旧的分隔符

    IFS=","

    #遍历数组
    result=""
    for i in $intf_list; do
        t="$(iw dev $i station dump)"
        result=$result$t
    done

    echo "$result"
    IFS="$OLD_IFS" # 将IFS恢复成原来的

    return 0
}

info_2g="$(fetch_wifi wlan0)"
info_5g="$(fetch_wifi wlan1)"

echo $info_2g

stas_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/Station /{a++}END{print a}')
rx_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/rx bytes:/{a+=$3}END{print a}')
tx_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/tx bytes:/{a+=$3}END{print a}')

stas_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/Station /{a++}END{print a}')
rx_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/rx bytes:/{a+=$3}END{print a}')
tx_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/tx bytes:/{a+=$3}END{print a}')

sleep 1

info_2g="$(fetch_wifi wlan0)"
info_5g="$(fetch_wifi wlan1)"

new_stas_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/Station /{a++}END{print a}')
new_rx_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/rx bytes:/{a+=$3}END{print a}')
new_tx_2g=$(echo "$info_2g" | awk 'BEGIN{a=0}/tx bytes:/{a+=$3}END{print a}')

new_stas_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/Station /{a++}END{print a}')
new_rx_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/rx bytes:/{a+=$3}END{print a}')
new_tx_5g=$(echo "$info_5g" | awk 'BEGIN{a=0}/tx bytes:/{a+=$3}END{print a}')

json_init

json_add_int "timestamp" $(date +%s)
json_add_int "client_number" $((stas_2g + stas_5g))
json_add_int "client_number_2g" $stas_2g
json_add_int "client_number_5g" $stas_5g

json_add_int "rx_bytes_2g" $tx_2g
json_add_int "tx_bytes_2g" $rx_2g

json_add_int "rx_bytes_5g" $tx_5g
json_add_int "tx_bytes_5g" $rx_5g

json_add_int "rx_rate_2g" $(echo "" | awk -v r1="$tx_2g" -v r2="$new_tx_2g" '{a=r2-r1;if(r2>r1){print r2-r1;}else{print 0}}')
json_add_int "tx_rate_2g" $(echo "" | awk -v r1="$rx_2g" -v r2="$new_rx_2g" '{a=r2-r1;if(r2>r1){print r2-r1;}else{print 0}}')

json_add_int "rx_rate_5g" $(echo "" | awk -v r1="$tx_5g" -v r2="$new_tx_5g" '{a=r2-r1;if(r2>r1){print r2-r1;}else{print 0}}')
json_add_int "tx_rate_5g" $(echo "" | awk -v r1="$rx_5g" -v r2="$new_rx_5g" '{a=r2-r1;if(r2>r1){print r2-r1;}else{print 0}}')

json_dump
