#!/bin/sh

. /usr/share/libubox/jshn.sh
. /lib/functions/network.sh
. /lib/functions.sh
. /lib/dyiot/bin/get_hardware

# 1: destination variable
# 2: interface
# 3: path # 4: separator
# 5: limit
__network_devstatus() {
    local __tmp

    [ -z "$__DEVICE_CACHE" ] &&
        export __DEVICE_CACHE="$(ubus call network.device status)"

    __tmp="$(jsonfilter ${4:+-F "$4"} ${5:+-l "$5"} -s "$__DEVICE_CACHE" -e "$1=@${2:+['$2']}$3")"

    [ -z "$__tmp" ] &&
        unset "$1" &&
        return 1

    eval "$__tmp"
}

flush_all_cache() {
    network_flush_cache
    unset __DEVICE_CACHE
}

##
##
function fetch_interface_status() {
    interface=$1
    real_interface=$1
    l3_device=""
    network_get_device "l3_device" "$interface"
    if [ "$l3_device" == "br-lan" ]; then
        l3_device="eth1"
    fi
    if [ "$(uci get system.system.netmodel)" == "1" -a "$interface" == "wan" ]; then
        interface="lan"
        l3_device="eth0"
    fi
    proto=""
    network_get_protocol "proto" "$interface"
    uptime=""
    __network_ifstatus "uptime" "$interface" ".uptime"
    subnet=""
    network_get_subnet "subnet" "$interface"
    dnss=""
    network_get_dnsserver "dnss" "$interface"

    status=""
    __network_devstatus "status" "$l3_device" ".carrier"
    if [ "$status" == "0" ]; then
        uptime=0
    fi
    macaddr=""
    __network_devstatus "macaddr" "$l3_device" ".macaddr"
    speed=""
    __network_devstatus "speed" "$l3_device" ".speed"
    txbytes=""
    __network_devstatus "txbytes" "$l3_device" ".statistics.tx_bytes"
    rxbytes=""
    __network_devstatus "rxbytes" "$l3_device" ".statistics.rx_bytes"
    txpackets=""
    __network_devstatus "txpackets" "$l3_device" ".statistics.tx_packets"
    rxpackets=""
    __network_devstatus "rxpackets" "$l3_device" ".statistics.rx_packets"

    if [ "$(uci get system.system.netmodel)" == "1" -a "$real_interface" == "wan" ]; then
        interface="lan1"
    fi
    json_add_object "$interface"
    if [ "$interface" == "wwan" ]; then
        modem=$(modem_name)
        dev=$(modem_dev)

        if [ -e $dev ]; then
            IMEI=$(cat /tmp/simcard_imei 2>/dev/null)
            if [ -z "${IMEI}" -o "${IMEI}" = "ERROR" ]; then
                case "$modem" in
                longsung)
                    gcom -s /etc/gcom/getimei.gcom -d "$dev" 2>/dev/null >/tmp/simcard_imei
                    ;;
                *)
                    gcom -d $dev -s /etc/gcom/getimei.gcom 2>/dev/null >/tmp/simcard_imei
                    ;;
                esac
            fi
            IMSI=$(cat /tmp/simcard_imsi 2>/dev/null)
            if [ ! -n "$IMSI" ] || [ $IMSI == "ERROR" ]; then
                case "$modem" in
                longsung)
                    gcom -s /etc/gcom/getimsi.gcom -d $dev 2>/dev/null | sed -n '2p' >/tmp/simcard_imsi
                    ;;
                *)
                    gcom -d $dev -s /etc/gcom/getimsi.gcom 2>/dev/null >/tmp/simcard_imsi
                    ;;
                esac
            fi
            ICCID=$(cat /tmp/simcard_iccid 2>/dev/null)
            if [ ! -n "$ICCID" ] || [ $ICCID == "ERROR" ]; then
                case "$modem" in
                longsung)
                    gcom -s /etc/gcom/geticcid.gcom -d $dev 2>/dev/null | sed -n '2p' | awk -F': ' '/^\+CCID/{print $2;exit}' >/tmp/simcard_iccid
                    ;;
                Air720|Air724UG)
                    gcom -d $dev -s /etc/gcom/geticcid.gcom 2>/dev/null >/tmp/simcard_iccid
                    ;;
                *)
                    gcom -d $dev -s /etc/gcom/geticcid.gcom 2>/dev/null | awk -F': ' '/^\+CCID/{print $2;exit}' >/tmp/simcard_iccid
                    ;;
                esac
            fi
            REG=$(cat /tmp/simcard_reg 2>/dev/null)
            if [ ! -n "$REG" ] || [ $REG == "0" ]; then
                case "$modem" in
                longsung)
                    gcom -s /etc/gcom/getvendor.gcom -d $dev 2>/dev/null | awk -F': ' '/^\+COPS/{print $2;exit}' >/tmp/simcard_reg
                    ;;
                *)
                    gcom -d $dev -s /etc/gcom/getvendor.gcom 2>/dev/null | awk -F': ' '/^\+COPS/{print $2;exit}' >/tmp/simcard_reg
                    ;;
                esac
                sed -i "s/[\r\n]//" /tmp/simcard_reg
            fi

            case "$modem" in
            longsung)
                gcom -s /etc/gcom/getstrength.gcom -d $dev 2>/dev/null | awk -F': ' '/^\+CSQ/{print $2;exit}' >/tmp/simcard_sig
                ;;
            *)
                gcom -d $dev -s /etc/gcom/getstrength.gcom 2>/dev/null | awk -F': ' '/^\+CSQ/{print $2;exit}' >/tmp/simcard_sig
                ;;
            esac
            sed -i "s/[\r\n]//" /tmp/simcard_sig
            IMEI=$(cat /tmp/simcard_imei 2>/dev/null)
            if [ -n "${IMEI}" ]; then
                json_add_string "IMEI" "$IMEI"
            fi
            IMSI=$(cat /tmp/simcard_imsi 2>/dev/null)
            [ -n "$IMSI" ] && {
                json_add_string "IMSI" "$IMSI"
            }
            ICCID=$(cat /tmp/simcard_iccid 2>/dev/null)
            [ -n "$ICCID" ] && {
                json_add_string "ICCID" "$ICCID"
            }
            REG=$(cat /tmp/simcard_reg 2>/dev/null)
            [ -n "$REG" ] && {
                json_add_string "REG" "$REG"
            }
            SIG=$(cat /tmp/simcard_sig 2>/dev/null)
            [ -n "$SIG" ] && {
                json_add_string "SIG" "$SIG"
            }
        fi
        json_add_string "l3_device" "2/3/4g-wwan"
        if [ "$proto" != "none" ]; then
            json_add_string "proto" "2/3/4g"
        fi
    elif [ "$(uci get system.system.netmodel)" == "0" -a "$real_interface" == "wan" ]; then
        json_add_string "l3_device" "eth0"
        json_add_string "proto" "$proto"
    else
        json_add_string "l3_device" "$l3_device"
        json_add_string "proto" "$proto"
    fi
    json_add_string "uptime" "$uptime"
    json_add_string "status" "$status"
    json_add_string "macaddr" "$macaddr"
    json_add_string "subnet" "$subnet"
    json_add_string "dnss" "$dnss"
    json_add_string "speed" "$speed"
    json_add_string "txbytes" "$txbytes"
    json_add_string "rxbytes" "$rxbytes"
    json_add_string "txpackets" "$txpackets"
    json_add_string "rxpackets" "$rxpackets"

    json_close_object
}

flush_all_cache

json_init

fetch_interface_status "wwan"
fetch_interface_status "wan"
fetch_interface_status "lan"

echo $(json_dump)
