#!/bin/sh
. /lib/dyiot/bin/diag_network.sh
. /lib/dyiot/bin/diag_wireless.sh
. /lib/dyiot/bin/diag_dev_driver.sh
. /lib/dyiot/bin/diag_io.sh
. /usr/share/libubox/jshn.sh
PRODUCT=`fw_printenv | grep -i ^PRODUCT | awk -F = '{print $2}' | tr '\n' '\0'`

prepare_env()
{
	echo "PLEASE INSERT ETHERNET CABLES IN WAN, LAN, AND 485 CROSS CABLES INTO ALL 485 PORTS"
	/etc/init.d/supervisor stop > /dev/null 2>&1
	/etc/init.d/app stop > /dev/null 2>&1
	/etc/init.d/rs485 stop > /dev/null 2>&1
	/etc/init.d/cloud_conn_dayun stop > /dev/null 2>&1
	/etc/init.d/whsnbg stop > /dev/null 2>&1
	sleep 3
	rm -rvf $TEST_SUMMARY > /dev/null 2>&1
}

restore_env()
{
	killall tail > /dev/null 2>&1
	killall cat > /dev/null 2>&1
	killall lg02_single_rx_tx > /dev/null 2>&1
	rm -rfv /app/*_test.log > /dev/null 2>&1
	/etc/init.d/supervisor restart > /dev/null 2>&1
	/etc/init.d/app restart > /dev/null 2>&1
	/etc/init.d/cloud_conn_dayun restart > /dev/null 2>&1
	/etc/init.d/whsnbg restart > /dev/null 2>&1
}

test_pass_msg()
{
	if [ -z "$1" ]
	then
		echo "TEST MSG NOT INTERFACE"
		return
	fi
	json_add_object
	json_add_string "interfaces" "$1"
	json_add_int "error_code" "0"
	json_add_string "error_msg" "success"
	json_close_object
}

test_failed_msg()
{
	if [ -z "$1" -o -z "$2" ]
	then
		echo "TEST MSG NOT INTERFACE"
		return
	fi
	json_add_object
	json_add_string "interfaces" "$1"
	json_add_string "error_msg" "$2"
	if [ -z "$3" ]
	then
		json_add_int "error_code" "99"
	else
		json_add_int "error_code" "$3"
	fi
	json_close_object
}

json_add_result_to_obj()
{
	if [ "$2" != 0 ] ;then
		test_failed_msg "$1" "$3" "$2"
	else
		test_pass_msg "$1"
	fi
}
