#!/bin/sh

#获取当前文件当前路径
positionPath="/app"
#获取昨天时间
DATE=$(date "+%Y%m%d")

#需要发送的文件名
#filename="userInfoData.$DATA.*"
filename="xieneng_data.db.tar.gz"
sn=$(cat /app/config/fac.ini | grep -i ^sn | awk -F = '{print $2}' | awk '{gsub(/^\s+|\s+$/, "");print}' | tr '\n' '\0')

#要发送的主机名
HOST="122.224.72.13"
PORT=30021
USERNAME="vbms"
PASSWORD="906708"
mi=$1

startTime=$(date "+%Y-%m-%d %H:%M:%S")
startTimeStamp=$(date -d "$startTime" +%s)
basedir=$positionPath
file_regex="xieneng_data.db*"
# log file
logfile=$basedir/lftp.$(date "+%Y%m%d").iot

echo "####startTime:$startTime start sftp $filename=======" >>$logfile
filecnt=$(find $basedir -name "$file_regex" | wc -l)
if [ $filecnt -gt 0 ]; then
    cd $positionPath
    tar czf $filename $file_regex
    echo "here has $filecnt files need to be sftp to bigdata!" >>$logfile
    ts=$(date +%s)
    filesize=$(ls -l $filename | awk '{print $5}')
    msg="{\"sn\":\"$sn\",\"mi\":$mi,\"time\":$ts,\"identifier\":\"downLoadHisData\",\"tags\":{\"downLoadStatus\":0,\"downLoadFileSize\":$filesize,\"downLoadUrl\":\"ftp://$HOST:$PORT/$sn/$DATE/$filename\"},\"data_type\":\"service\"}"
    mosquitto_pub -t ipc/$sn/CANBUS_0/device/$sn/data_filtered/service/downLoadHisData -m "$msg"
    lftp -u $USERNAME,$PASSWORD ftp://$HOST:$PORT <<EOF
        set passive-mode on
        mkdir -pf $sn/$DATE
        cd $sn/$DATE
        lcd $positionPath
        mput $filename
        bye
EOF
    cd $positionPath
    rm $filename
    echo "$filesize ftp://$HOST:$PORT/$sn/$DATE/$filename"
else
    echo "here no file need to be sftp to bigdata" >>$logfile
fi
endTime=$(date "+%Y-%m-%d %H:%M:%S")
endTimeStamp=$(date -d "$endTime" +%s)
echo "== total == time consuming: "$(($endTimeStamp - $startTimeStamp))"s" >>$logfile
