#!/bin/sh
. /lib/dyiot/bin/diag_sys.sh

json_init

# uboot_env=`fw_printenv`
uboot_env=$(factory get)
mac_addr=$(echo "$uboot_env" | awk -F'=' '/^MAC=/{print $2}')
sn=$(echo "$uboot_env" | awk -F'=' '/^SN=/{print $2}')
hwver=$(echo "$uboot_env" | awk -F'=' '/^HWVER=/{print $2}')
fdate=$(echo "$uboot_env" | awk -F'=' '/^DATE=/{print $2}')
echo "HWVER: $hwver"
echo "SN: $sn"
echo "DATE: $date"
echo "SWVER: $(cat /etc/issue)"
json_add_string "sn" "$sn"
json_add_string "product" "$PRODUCT"
json_add_int "timestamp" $(date +%s)
json_add_string "MAC" "$mac_addr"
json_add_string "MAC1" "$mac_addr1"
json_add_string "HWVER": "$hwver"
json_add_string "SWVER": "$(cat /etc/issue)"

prepare_env

json_add_object "data"

json_add_array "Led"
msg=$(test_led led-heart led-internet)
ret=$?
json_add_result_to_obj "led" "$ret" "$msg"
json_close_array

json_add_array "OnBoardPort"
msg=$(test_uart ttymxc2 ttymxc2)
ret=$?
json_add_result_to_obj "RS485_1" "$ret" "$msg"

msg=$(test_can can0 can0)
ret=$?
json_add_result_to_obj "CAN0" "$ret" "$msg"
json_close_array

json_add_array "NetWork"
msg=$(test_4g_modem)
ret=$?
json_add_result_to_obj "4g_modem" "$ret" "$msg"

msg=$(test_net_connect)
ret=$?
json_add_result_to_obj "ping" "$ret" "$msg"
json_close_array

if [ $hwver == "1.0" ]; then
	json_add_array "Other"
	msg=$(test_gps ttymxc1)
	ret=$?
	json_add_result_to_obj "GPS" "$ret" "$msg"
	json_close_array
elif [ $hwver == "1.1" ]; then
	json_add_array "Other"
	msg=$(test_gps_in_ec200s /dev/ttyUSB2)
	ret=$?
	json_add_result_to_obj "GPS" "$ret" "$msg"
	json_close_array
fi
json_close_object

echo ""
echo "---TEST SUMMARY---"
#cat $TEST_SUMMARY
sleep 1
json_str=$(json_dump)
echo "test_result:$json_str"

restore_env