#!/bin/sh
PRODUCT=$(fw_printenv | grep -i ^PRODUCT | awk -F = '{print $2}' | tr '\n' '\0')

products="WooLink5004-WL-4G WooLink2004-WL-4G WooLink0011-4D WooLink2102-W-4G WooLink2004-W-4G WooLink2F6280-W-4G WooLink2F6280_W_4G WooLink2000-4X WooLink-SMC-GW-V3 WooLink-SMC-GW-V3-Lite"
products="$products WooLink2000-4X BS-IGW-1-V2 BS-IGW-1-V3"

instsvr_stop() {
	local initd="/etc/init.d/$1"
	if [ -x "${initd}" ] ; then
		"${initd}" stop
		return $?
	fi
	return 1
}

for var in ${products}; do
	if [ $PRODUCT == "$var" ]; then
		instsvr_stop rs485
		instsvr_stop xieneng_car
		instsvr_stop whsnbg
		instsvr_stop cloud_conn_dayun
		instsvr_stop dido_modbus_tcp
		instsvr_stop ser2net
		eval /app/diag_for_"$PRODUCT".sh $*
		exit 0
	fi
done
echo "$PRODUCT NOT SUPPORT!!!"
