#!/bin/sh

. /lib/functions.sh
. /lib/dyiot/bin/get_hardware

function execute_gcom() {
	dev=$(modem_dev)

	echo "Modem info:"
	gcom -d $dev info
	echo "sim status:"
	gcom -d $dev -s /etc/gcom/checksim.gcom
	echo "----"
	echo "vendor info:"
	gcom -d $dev -s /etc/gcom/getvendor.gcom
	echo "----"
	echo "imei info:"
	gcom -d $dev -s /etc/gcom/getimei.gcom
	echo "----"
	echo "imsi info:"
	gcom -d $dev -s /etc/gcom/getimsi.gcom
	echo "----"
	echo "iccid info:"
	gcom -d $dev -s /etc/gcom/geticcid.gcom
	echo "----"
	echo "cardinfo:"
	gcom -d $dev -s /etc/gcom/getcardinfo.gcom
	echo "----"
	echo "signal strength:"
	gcom -d $dev -s /etc/gcom/getstrength.gcom
	echo "----"
	echo "carrier info:"
	gcom -d $dev -s /etc/gcom/getcarrier.gcom
	echo "----"
	echo "PING result:"
	gcom -d $dev -s /etc/gcom/ping.gcom
	echo "----"
	echo "APN config:"
	gcom -d $dev -s /etc/gcom/getcgdcont.gcom
	echo "----"
	echo "Connect status:"
	gcom -d $dev -s /etc/gcom/getcgcontrdp.gcom
}

execute_gcom

echo "route info:"
route -n
echo "----"

echo "interface info:"
ifconfig -a
echo "----"

echo "dns info:"
nslookup baidu.com
echo "----"
