#!/bin/sh

# update feeds
echo "src/gz reboot_core http://iot.lnxall.com/repository/17.01.6/targets/imx6/generic/packages
src/gz reboot_base http://mirror.0x.sg/openwrt/releases/17.01.6/packages/arm_cortex-a7_neon-vfpv4/base
src/gz reboot_packages http://mirror.0x.sg/openwrt/releases/17.01.6/packages/arm_cortex-a7_neon-vfpv4/packages
src/gz reboot_routing http://mirror.0x.sg/openwrt/releases/17.01.6/packages/arm_cortex-a7_neon-vfpv4/routing
src/gz reboot_telephony http://mirror.0x.sg/openwrt/releases/17.01.6/packages/arm_cortex-a7_neon-vfpv4/telephony
src/gz reboot_luci http://mirror.0x.sg/openwrt/releases/17.01.6/packages/arm_cortex-a7_neon-vfpv4/luci
src/gz dy_package http://iot.lnxall.com/repository/17.01.6/packages/arm_cortex-a7_neon-vfpv4/dy_package" > /etc/opkg/distfeeds.conf

# uhttpd
opkg update
opkg install uhttpd 

uci set uhttpd.llmp=uhttpd
uci set uhttpd.llmp.listen_http=82
uci set uhttpd.llmp.home=/srv/www
uci commit uhttpd

mkdir -p $(uci get uhttpd.llmp.home)
/etc/init.d/uhttpd restart
/etc/init.d/uhttpd enable
echo "<P>Hello, this web server runs on OpenWrt!!</P>" > /srv/www/index.html


# php7
opkg install php7 php7-cgi php7-cli php7-mod-mysqli

uci get uhttpd.llmp.interpreter 2>/dev/null | grep "php-cgi"
[ "$?" != "0" ] && uci add_list uhttpd.llmp.interpreter=".php=/usr/bin/php-cgi"
uci set uhttpd.llmp.index_page="index.html index.htm default.html default.htm index.php"
uci commit uhttpd

sed -i 's,doc_root.*,doc_root = "",g' /etc/php.ini
sed -i 's,;short_open_tag = Off,short_open_tag = On,g' /etc/php.ini

echo "<?php phpinfo(); ?>" > /srv/www/index.php

/etc/init.d/uhttpd restart


# MySQLi
opkg install libpthread libncurses libreadline mysql-server

sed -i 's,^datadir.*,datadir         = "/srv/mysql",g' /etc/my.cnf
sed -i 's,^tmpdir.*,tmpdir          = "/tmp",g' /etc/my.cnf

mkdir -p /srv/mysql
mysql_install_db --force

/etc/init.d/mysqld start
/etc/init.d/mysqld enable

mysql_user="root"
mysql_passwd="dyiot123"

mysqladmin -u "$mysql_user" password "$mysql_passwd"

# php7 - mysqli
sed -i 's,;extension=mysqli.so,extension=mysqli.so,g' /etc/php.ini

grep "MySQLi" /etc/php.ini
[ "$?" != 0 ] && {
echo "
[MySQLi]
mysqli.allow_local_infile = On
mysqli.allow_persistent = On
mysqli.cache_size = 2000
mysqli.max_persistent = -1
mysqli.max_links = -1
mysqli.default_port = 3306
mysqli.default_socket = /var/run/mysqld.sock
mysqli.default_host = 127.0.0.1
mysqli.default_user = \"$mysql_user\"
mysqli.default_password = \"$mysql_passwd\"
mysqli.connect_timeout = 60
mysqli.trace_mode = Off
" >> /etc/php.ini
}

echo "
<?php
\$servername = \"localhost\";
\$username = \"$mysql_user\";
\$password = \"$mysql_passwd\";
 
\$conn = new mysqli(\$servername, \$username, \$password);
 
if (\$conn->connect_error) {
    die(\"Connection Failed: \" . \$conn->connect_error);
} 
echo \"Connection Success\"
?>
" > /srv/www/mysql.php

# firewall
uci -q batch <<-EOF
set firewall.lamp=redirect
set firewall.lamp.src='wan'
set firewall.lamp.src_dport='8002'
set firewall.lamp.dest='lan'
set firewall.lamp.dest_port='82'
set firewall.lamp.proto='tcp'
EOF

uci commit firewall
/etc/init.d/firewall restart &

