#!/bin/sh

. /lib/functions.sh

help()
{
    cat <<_HELP_
Setup WAN port on PPPOE mode.
Usage: $0 {wan|wan1|wan2} USERNAME PASSWORD
        [-k KEEPALIVE] [-d DNS[,DNS]] [-m MTU] [-rRS]
        -k KEEPALIVE # How many unreceived echo will trigger reconnection. Echo will be sent for every 5 seconds.
        -d DNS[,DNS] # Manually add dns list
        -m MTU # Set MTU on this interface
        -r # Add default route on this WAN port, it's default behavior.
        -R # Don't add default route on this WAN port
        -S # don't restart service
Example:
    $0 wan hzhz804352 oakridge -k 3 -d '8.8.8.8,9.9.9.9'
    $0 wan1 hzhz804352 oakridge -R # Set wan1 as pppoe without default route.
    $0 wan2 hzhz804352 oakridge -r # Set wan2 as pppoe with default route, it's default behavior.
_HELP_
}

if [ $# -lt 3 ]; then
    help
    exit 1
fi

if [ "$(uci get system.system.netmodel)" == "1" ]; then
    echo "No need to config Wan Port on bridge mode"
    exit 0
fi

board=$(board_name)

case "$board" in
    WOOLINK-MT7621-512M-256M)
        ifx="$1";ifname="eth0.4094"
        ;;
    WOOLINK-MT7628-128M-32M)
        ifx="$1";ifname="eth0.4090"
        ;;
    woolink,mt7621-64m)
        ifx="$1";ifname="wan"
        ;;
    *)
        case $1 in
            wan) ifx="$1";ifname="eth0";;
            wan1) ifx="$1";ifname="eth3";;
            wan2) ifx="$1";ifname="eth2";;
            *) help; exit 1;;
        esac
        ;;
esac

username="$2"
password="$3"
shift 3

defaultroute='1'
while [ -n "$1" ]; do
    case $1 in
        -k) keepalive="$2";shift 2;;
        -d) dnss="$2";shift 2;;
        -R) defaultroute='0';shift 1;;
        -r) defaultroute='1';shift 1;;
        -m) mtu="$2";shift 2;;
        -S) no_restart='1';shift 1;;
        --) shift;break;;
        -*) help;exit 1;;
        *) break;;
    esac
done

uci set network.${ifx}='interface'
uci set network.${ifx}.ifname=$ifname
uci set network.${ifx}.proto='pppoe'
uci set network.${ifx}.username=$username
uci set network.${ifx}.password=$password
uci set network.lan.ifname="eth1"
uci set system.system.netmodel="0"

if [ -n "$mtu" ]; then
    uci set network.${ifx}.mtu=$mtu
fi

if [ -n "$keepalive" ]; then
    uci set network.${ifx}.keepalive=$keepalive
fi

uci set network.${ifx}.defaultroute=$defaultroute

uci delete network.${ifname}.dns
if [ -n "$dnss" ]; then
    for dns in ${dnss//,/ }; do
        uci add_list network.${ifname}.dns=$dns
    done
fi

uci commit network
uci commit system

if [ -z "$no_restart" ]; then
    /etc/init.d/network reload
fi

#if [ $defaultroute = '1' ]; then
#    ip r add default dev $ifname metric 1
#fi
echo "Set WAN port $ifx on pppoe mode"

i=1
miss_count=0
while [ $i -le 30 ]
do
    let i++
    ping -w3 -c 2 www.baidu.com > /dev/null 2>&1
    if [ "$?" != 0 ]
    then
        miss_count=$(($miss_count+1))
        echo "Network is abnormal, miss_count:$miss_count"
    else
        echo "Network is OK, miss_count:$miss_count"
        break
    fi
done

exit 0

