#!/bin/sh

help()
{
    cat <<_HELP_
Setup logserver config
Usage: $0 [-ip <server_ip>] [-port <server_port>] [-proto <udp/tcp>] [-loglevel <log_level>] 
    -ip <server_ip> setup the remote syslog server ip, default log.lnxall.com
    -port <server_port> setup the remote syslog server port, default 514
    -loglevel <log_level> setup the critical than log_level message to remote server, default 5
    -proto <udp/tcp>  setup server proto, udp or tcp, default udp
Example:
    $0 -ip log.lnxall.com -port 514 -proto udp -loglevel 5
_HELP_
}

if [ $# -lt 2 ]; then
    help
    exit 1
fi

while [ -n "$1" ]; do
    case $1 in
        -ip) server_ip="$2";shift 2;;
        -port) server_port="$2";shift 2;;
        -loglevel) log_level="$2";shift 2;;
        -proto) server_proto="$2";shift 2;;
        -*) help;exit 1;;
        *) break;;
    esac
done

echo "$server_ip, $server_port, $server_proto, $log_level"

uci set system.system.log_remote=1
[ -n "$server_ip" ] && uci set system.system.log_ip="$server_ip"
[ -n "$server_port" ] && uci set system.system.log_port="$server_port"
[ -n "$server_proto" ] && uci set system.system.log_proto="$server_proto"
[ -n "$log_level" ] && uci set system.system.log_level="$log_level"
uci set system.system.log_remote="1"

uci commit system;/etc/init.d/log restart

exit 0

