#!/bin/sh

all_installed=1

check_installed_ipk()
{
  local updated=0

  if [[ "$all_installed" == "1" ]]
  then
    echo "All IPK Installed"
    return
  fi

  local flag=0
  cat /app/config/ipk_installed | while read line
  do
    result=$(/bin/opkg list-installed | grep $line)
    if [[ "$result" == "" ]]
    then
    flag=1
    echo "$line not installed"
    [ "$updated" == 0 ] && {
        /bin/opkg update
        updated=1
    }
    /bin/opkg install $line
    fi
  done
  if [ "$flag" -eq "0" ]; then
    all_installed=1
    echo "all installed"
  fi
}


check_installed_ipk