#!/bin/sh

. /usr/share/libubox/jshn.sh

function fetch_vapconfig() {
	vap_name=$1
	disalbed="$(uci get wireless.$vap_name.disabled 2>/dev/null)"
	json_add_boolean "disabled" $disalbed
	key="$(uci get wireless.$vap_name.key 2>/dev/null)"
	json_add_string "key" $key
	mode="$(uci get wireless.$vap_name.mode 2>/dev/null)"
	json_add_string "mode" $mode
	ssid="$(uci get wireless.$vap_name.ssid 2>/dev/null)"
	json_add_string "ssid" $ssid
	json_add_string "vap_name" $vap_name
}

json_init

json_add_array "vap_list"

vap00=$(uci get wireless.vap00.device)
if [ -n "$vap00" ]; then
	json_add_object
	fetch_vapconfig 'vap00'
	json_close_object
fi

vap10=$(uci get wireless.vap10.device)
if [ -n "$vap10" ]; then
	json_add_object
	fetch_vapconfig 'vap10'
	json_close_object
fi

json_close_array

echo "$(json_dump)"
