#!/bin/sh

updated=0
check_installed_ipk()
{

  if [[ "$all_installed" == "1" ]]
  then
    echo "All IPK Installed" | logger -t "IPK CHECK" -p 3
    return
  fi

  local flag=0
  if [ -f "/app/config/ipk_installed" ]; then
    for line in `cat /app/config/ipk_installed | awk '{print $1}'`
    do
      result=$(/bin/opkg list-installed | grep "^$line ")
      if [[ "$result" == "" ]]
      then
        flag=1
        echo "$line not installed" | logger -t "IPK CHECK" -p 3
        [ "$updated" == 0 ] && {
            /bin/opkg update
            updated=1
        }
        str=`cat /app/config/ipk_installed`
        args=${str#"$line "}
        echo "args is $args"
        /bin/opkg $args
      fi
    done
  fi
  if [ "$flag" -eq "0" ]; then
    all_installed=1
    echo "all installed" | logger -t "IPK CHECK" -p 3
  fi
}

while :
do
  check_installed_ipk &
  sleep 10
done
