#!/bin/sh

. /usr/share/libubox/jshn.sh
dbfile=/tmp/dhcp.db
tablename=dhcp_status
#echo sqlite3  $dbfile "BEGIN TRANSACTION;CREATE TABLE ${tablename}(MAC,IFNAME,CHAN,RSSI,ASSOCTIME,RADIOID,BSSID,IPADDR,AUTHENTICATION,PORTAL_SCHEME,SSID,VLAN,PORTAL_HMODE,PORTAL_USER,HOSTNAME,PPSK_KEY,PORTAL_STATUS,REMAIN_TIME);COMMIT;" | logger
sqlite3  $dbfile "BEGIN TRANSACTION;CREATE TABLE IF NOT EXISTS ${tablename}(INTERFACE TXT ,MAC,IP TEXT,NAME TEXT);COMMIT;"

interface=$( env | awk -F'[=]' '/^DNSMASQ_INTERFACE/  {print $2}')
mac="$2"
ip="$3"
name="$4"
case  "$1" in
	add) 
        # add new record
        CMD="REPLACE INTO ${tablename} (INTERFACE,MAC,IP,NAME) VALUES('$interface', '$mac','$ip','$name')"
        echo "$CMD" | logger -t 'dhcp_status'
        i=0
        while [ $i -lt 3 ]
        do
            i=$(($i+1))
            sqlite3 $dbfile "BEGIN TRANSACTION;${CMD};COMMIT;"
            ret="$?"
            if [ "$ret" = "0" ]
            then
                break
            fi
            sleep 2
            echo "$ret, $i, $CMD"
        done
	
	;;
	del)
        # delete record
        CMD="DELETE FROM ${tablename} WHERE MAC = '$mac'"
        echo "$CMD" | logger -t 'dhcp_status'
        i=0
        while [ $i -lt 3 ]
        do
            i=$(($i+1))
            sqlite3 $dbfile "BEGIN TRANSACTION;${CMD};COMMIT;"
            ret="$?"
            if [ "$ret" = "0" ]
            then
                break
            fi
            sleep 2
            echo "$ret, $i, $CMD"
        done
	;;
status)
  # active missed client
  json_init
  json_add_array "status"
  for client in $(arp | awk -F'[ \t()]' '{printf("%s|%s|%s|%s\n", $1,$3,$6,$10)}')
  do
    OIFS=$IFS;IFS='|';
    set -- $client;_interface=$4;_mac=$3;_ip=$2;_name=$1;IFS=$OIFS
    json_add_object
    json_add_string "interface" "$_interface"
    json_add_string "mac" "$_mac"
    json_add_string "ip" "$_ip"
    json_add_string "name" "$_name"
    json_close_object
  done
  #json_dump > /dev/console
  json_dump
  ;;

status_all)
	# active missed client
	json_init
	json_add_array "status"
	for client in $(sqlite3 $dbfile "SELECT * FROM $tablename" 2>/dev/null)
	do
    	OIFS=$IFS;IFS='|';
	set -- $client;_interface=$1;_mac=$2;_ip=$3;_name=$4;IFS=$OIFS        
	json_add_object 
	json_add_string "interface" "$_interface"
	json_add_string "mac" "$_mac"
	json_add_string "ip" "$_ip"
	json_add_string "name" "$_name"
	json_close_object
	done

	#json_dump > /dev/console
	json_dump 
	;;
	*)
	exit 1
	;;

esac
