#!/bin/sh
test_dio()
{
	di=$1
	do=$2
	echo $di > /sys/class/gpio/export 2>/dev/null
	echo $do > /sys/class/gpio/export 2>/dev/null

	echo in > /sys/class/gpio/gpio$di/direction
	echo out > /sys/class/gpio/gpio$do/direction

	echo 1 > /sys/class/gpio/gpio$do/value
	result=$(cat /sys/class/gpio/gpio$di/value)
	if [ $result != "0" ]
	then
		echo "DIO TEST FAILED!!!" | tee -a $TEST_SUMMARY
		return 2
	fi

	echo 0 > /sys/class/gpio/gpio$do/value
	result=$(cat /sys/class/gpio/gpio$di/value)
	if [ $result != "1" ]
	then
		echo "DIO TEST FAILED!!!" | tee -a $TEST_SUMMARY
		return 3
	fi
	echo "[+] DIO TEST PASSED" | tee -a $TEST_SUMMARY
	return 0
}

turn_led_on()
{
	for led_id in $@
	do
		tmp_path="/sys/class/leds/${led_id}/brightness"
		echo 1 > $tmp_path
	done
}

turn_led_off()
{
	for led_id in $@
	do
		tmp_path="/sys/class/leds/${led_id}/brightness"
		echo 0 > $tmp_path
	done
}

test_led()
{
	echo "[*] LED TEST START"
	echo "ALL LEDs BLINKING TEST START"
	echo "PLEASE CHECK ALL LEDs BLINKING"

	turn_led_on $*
	usleep 200000
	turn_led_off $*
	usleep 200000
	turn_led_on $*
	usleep 200000
	turn_led_off $*
	usleep 200000
	turn_led_on $*
	usleep 200000
	turn_led_off $*
	usleep 200000
	turn_led_on $*
	usleep 200000
	turn_led_off $*
	usleep 200000
	turn_led_on $*
	echo "[+] LED PASSED" | tee -a $TEST_SUMMARY
	return 0
}


