#!/bin/sh
. /lib/dyiot/bin/diag_sys.sh

json_init

# uboot_env=`fw_printenv`
uboot_env=`factory get`
mac_addr=$(echo "$uboot_env"|awk -F'=' '/^MAC=/{print $2}')
sn=$(echo "$uboot_env"|awk -F'=' '/^SN=/{print $2}')
hwver=$(echo "$uboot_env"|awk -F'=' '/^HWVER=/{print $2}')
fdate=$(echo "$uboot_env"|awk -F'=' '/^DATE=/{print $2}')
echo "HWVER: $hwver"
echo "SN: $sn"
echo "DATE: $date"
echo "SWVER: $(cat /etc/issue)"
json_add_string "sn" "$sn"
json_add_string "product" "$PRODUCT"
json_add_int "timestamp" `date +%s`
json_add_string "MAC" "$mac_addr"
json_add_string "HWVER": "$hwver"
json_add_string "SWVER": "$(cat /etc/issue)"


help()
{
    cat <<_HELP_
diagnose devices

_HELP_
}

prepare_env

json_add_object "data"
        json_add_array  "Led"
                msg=`test_led led-heart led-internet led-wlan`
                ret=$?
                json_add_result_to_obj "led" "$ret" "$msg"
        json_close_array

        
        json_add_array  "EX-GPIO"
                msg=`test_dio 0 11`
                ret=$?
                json_add_result_to_obj "dio" "$ret" "$msg"
        json_close_array

	json_add_array  "OnBoardPort"
                msg=`test_uart ttyS1 ttyS1`
                ret=$?
                json_add_result_to_obj "Uart1" "$ret" "$msg"

                json_add_result_to_obj "Uart2" "0" ""

        json_close_array

        json_add_array  "Wireless"
                msg=`test_wifi 0`
                ret=$?
                json_add_result_to_obj "wlan0" "$ret" "$msg"
        json_close_array

        json_add_array  "NetWork"
                msg=`test_4g_modem`
                ret=$?
                json_add_result_to_obj "4g_modem" "$ret" "$msg"

                msg=`test_internet usb0`
                ret=$?
                json_add_result_to_obj "Ping with 4G" "$ret" "$msg"

                msg=`test_internet eth0.4090`
                ret=$?
                json_add_result_to_obj "Ping with WAN" "$ret" "$msg"

                msg=`test_lan`
                ret=$?
                json_add_result_to_obj "LAN" "$ret" "$msg"
        json_close_array
json_close_object
echo ""
echo "---TEST SUMMARY---"
#cat $TEST_SUMMARY
sleep 1
json_str=`json_dump`
echo "test_result:$json_str"

restore_env
