#!/bin/sh

help() {
    cat <<_HELP_
Update rootfs file.
Usage: $0 <rootfs URL>
Example:
    $0 http://qa.frps.lnxall.com:5008/images/gw_lora_v3/3.374.1649/rootfs.tar.gz
_HELP_
}

if [ $# -ne 1 ]; then
    help
    exit 1
fi

url=$1

if [ -f "/app/after_update" ]; then
    if [ $(grep -c $url /app/after_update) -eq 0 ]; then
        echo "need update"
    else
        echo "already updated"
        exit 0
    fi
fi

cur_ts=$(date +%s)
echo "before $cur_ts $url" >/app/before_update

cd /tmp
wget $url -O /tmp/rootfs.tar.gz
tar -xzf /tmp/rootfs.tar.gz -C /

echo "after $cur_ts $url" >/app/after_update

echo "UPDATE SUCCESSFUL"

sync
reboot
