#!/bin/sh  

. /usr/share/libubox/jshn.sh

#
# {
# 	"gateway": "",
# 	"ip_type": 0,
# 	"mi": 11845124,
# 	"netmask": "",
# 	"pppoe_password": "",
# 	"pppoe_username": "",
# 	"timestamp": 1596698743,
# 	"version": "no2IP2auD1BB"
# }

function fetch_wanconfig()
{
    ip_type="$(uci get network.wan.proto 2>/dev/null)"
    pppoe_username="$(uci get network.wan.username 2>/dev/null)"
    pppoe_password="$(uci get network.wan.password 2>/dev/null)"
    ipaddr="$(uci get network.wan.ipaddr 2>/dev/null)"
    netmask="$(uci get network.wan.netmask 2>/dev/null)"
    gateway="$(uci get network.wan.gateway 2>/dev/null)"
    dnss="$(uci get network.wan.dns 2>/dev/null)"

    if [ "$ip_type" = "dhcp" ]
    then
        ip_type=0
    elif [ "$ip_type" = "static" ]
    then
        ip_type=1
    elif [ "$ip_type" = "pppoe" ]
    then
        ip_type=2

    elif [ "$ip_type" = "none" ]
    then
        ip_type=3
    else
        echo "not support"
        return 1
    fi

    json_add_int "ip_type" $ip_type
    json_add_string "pppoe_username" "$pppoe_username"
    json_add_string "pppoe_password" "$pppoe_password"
    json_add_string "ipaddr" "$ipaddr"
    json_add_string "netmask" "$netmask"
    json_add_string "gateway" "$gateway"
    json_add_string "dnss" "$dnss"
}

json_init
# json_add_string "netmodel" "$(uci get system.system.netmodel)"
fetch_wanconfig

echo "$(json_dump)"


