#!/bin/sh
tmpfile=/tmp/wireless.tmp
vap_tab="vap00 vap10"
ap_map="
vap00 wlan0 \n 
vap10 wlan1 \n
"
. /usr/share/libubox/jshn.sh

fetch_radio()
{
	
	out="$out {"
	for _vap in $(echo $vap_tab)
	do
	out="$out \"$_vap\":["
	#wlan=$(echo "$ap_map" | awk '/^vap00/ {print $2 }')
	wlan=$(echo "$ap_map" | awk "/^$_vap/ {print \$2 }")
	dev_info=$(iw dev "$wlan" info | awk '/^Interface/ {print $2}')
	#check netcard
	[ -z "$dev_info" ] && continue
	sta=$(iw dev $wlan station dump | fetch_wlan_station_info.awk)
	out="$out $sta"
	out="$out ]"
	if [ "$_vap" != "vap10" ] ;then  
	out="$out ,"  
	fi 
	done

	out="$out }"	
	echo "$out"
}

case  "$1" in
	status)
	phy_list=`iw dev`
	[ -z "$phy_list" ] && echo '{}' && exit 0
	fetch_radio
	;;
	*)
	exit 1
	;;

esac
