#!/bin/sh

. /lib/functions.sh
. /lib/dyiot/bin/get_hardware

modem=$(modem_name)
dev=$(modem_dev)

if [ -n "$dev" ]; then
    case "$modem" in
    Air720)
        gcom -d $dev -s /etc/gcom/get_lbs_air720.gcom | awk -F ',' '{print $1,$2}' >/tmp/tmplbs.txt
        cm_timeout=$(cat /tmp/tmplbs.txt | grep "timeout")
        cm_error=$(cat /tmp/tmplbs.txt | grep "error")
        if [[ "$cm_timeout" == "" && "$cm_error" == "" ]]; then
            latitude=$(cat /tmp/tmplbs.txt | awk -F ' ' '{print $1}')
            longitude=$(cat /tmp/tmplbs.txt | awk -F ' ' '{print $2}')
            echo "$latitude,$longitude" >/tmp/lbs.txt
            if [[ "$latitude" != "" && "$longitude" != "" ]]; then
                echo "$latitude,$longitude"
            fi
        fi
        ;;
    esac
fi
