#!/bin/sh  

. /usr/share/libubox/jshn.sh


function fetch_lanconfig()
{
    ip_type="$(uci get network.lan.proto 2>/dev/null)"
    ipaddr="$(uci get network.lan.ipaddr 2>/dev/null)"
    netmask="$(uci get network.lan.netmask 2>/dev/null)"
    gateway="$(uci get network.lan.gateway 2>/dev/null)"
    dnss="$(uci get network.lan.dns 2>/dev/null)"
    dhcp_server_enable="$(uci get dhcp.lan.ignore 2>/dev/null)"
    dhcp_start="$(uci get dhcp.lan.start 2>/dev/null)"
    dhcp_limit="$(uci get dhcp.lan.limit 2>/dev/null)"
    dhcp_leasetime="$(uci get dhcp.lan.leasetime 2>/dev/null)"

    if [ "$ip_type" = "dhcp" ]
    then
        ip_type=0
    elif [ "$ip_type" = "static" ]
    then
        ip_type=1
    elif [ "$ip_type" = "pppoe" ]
    then
        ip_type=2
    elif [ "$ip_type" = "none" ]
    then
        ip_type=3
    else
        echo "not support"
        return 1
    fi

    if [ -z "$dhcp_server_enable" -o "$dhcp_server_enable" = 0 ]
    then
        dhcp_server_enable=1
    else
        dhcp_server_enable=0
    fi

    json_add_int "ip_type" $ip_type
    json_add_string "ipaddr" "$ipaddr"
    json_add_string "netmask" "$netmask"
    json_add_string "gateway" "$gateway"
    json_add_string "dnss" "$dnss"
    json_add_int "dhcp_server_enable" "$dhcp_server_enable"
    json_add_int "dhcp_start" "$dhcp_start"
    json_add_int "dhcp_limit" "$dhcp_limit"
    json_add_int "dhcp_leasetime" "$dhcp_leasetime"
}

json_init
# json_add_string "netmodel" "$(uci get system.system.netmodel)"
fetch_lanconfig

echo "$(json_dump)"


