#!/bin/sh
test_lora()
{
	interfaces="lora-sx1278"
	error_code=0
	error_msg="success"
	lg02_single_rx_tx -d 1 -m 'XXXXXX' 2>&1 | tee /app/lora1_test.log
	lg02_single_rx_tx -d 2 -m 'XXXXXX' 2>&1 | tee /app/lora2_test.log
	sleep 1
	for i in 1 2
	do
		result=$(cat /app/lora${i}_test.log | awk '/XXXXXX/{print $0}')
		echo "result: $result"
		if [ -z "$result" ]
		then
			echo "LORA${i} NOT RECEIVE PACKETS, FAILED!!!" | tee -a $TEST_SUMMARY
			return 1
		fi
		echo "[+] LORA${i} PASSED" | tee -a $TEST_SUMMARY
	done
	return 0
}

test_wifi()
{
	interfaces="wlan"$1
	error_code=0
	error_msg="success"
	id="$1"
	ifconfig wlan${id} > /dev/null 2>&1
	if [ "$?" != "0" ]
	then
		echo "WIFI${id} NOT UP, FAILED!!!" | tee -a $TEST_SUMMARY
		return 1
	fi
	echo "WIFI${id} PASSED" | tee -a $TEST_SUMMARY
	return 0
}

test_hci()
{
	interfaces=$1
	error_code=0
	error_msg="success"
	hciconfig $1 > /dev/null 2>&1
	if [ "$?" != "0" ]
	then
		echo "$1 NOT UP, FAILED!!!" | tee -a $TEST_SUMMARY
		return 1
	fi
	echo "$1 PASSED" | tee -a $TEST_SUMMARY
	return 0
}

test_ble()
{
	interfaces=$1
	gpiox=$2
	echo $gpiox > /sys/class/gpio/export
	echo out > /sys/devices/platform/1e000000.palmbus/1e000600.gpio/gpiochip0/gpio/gpio$gpiox/direction
	echo 1 > /sys/devices/platform/1e000000.palmbus/1e000600.gpio/gpiochip0/gpio/gpio$gpiox/value
	sleep 1
	echo 0 > /sys/devices/platform/1e000000.palmbus/1e000600.gpio/gpiochip0/gpio/gpio$gpiox/value
	result=$(uart_test -m string -d ${interfaces} -p "AT\r\n" | grep "Receive")
	# echo "result: $result"
	if [ -z "$result" ]
	then
		echo "BLE TEST FAILED!!!" | tee -a $TEST_SUMMARY
		return 1
	fi

	echo "[+] BLE TEST PASSED" | tee -a $TEST_SUMMARY
	return 0
}

test_zigbee()
{
	interfaces=$1
	result=$(uart_test -m string -d ${interfaces} -p +++ | grep "Receive")
	# echo "result: $result"
	if [ -z "$result" ]
	then
		echo "ZIGBEE TEST FAILED!!!" | tee -a $TEST_SUMMARY
		error_code=1
		error_msg="ZIGBEE test FAILED!!!"
		return 1
	fi

	echo "[+] ZIGBEE TEST PASSED" | tee -a $TEST_SUMMARY
	return 0
}
