#!/bin/sh

test_lan() {
    echo "[*] LAN TEST START"
    error_code=0
    error_msg="success"
    sleep 2
    result=$(cat /tmp/dhcp.leases | awk '{print $3}')
    if [ -z "$result" ]; then
        result=$(ping -c 3 172.16.254.33 | grep "64 bytes from")
        if [ -z "$result" ]; then
            dst=$(cat /proc/net/arp | grep br-lan | awk '$3 == "0x2" {print $1}' | tr '\n' '\0')
            echo "dst: $dst"
            result=$(ping -c 3 $dst | grep "64 bytes from")
            if [ -z "$result" ]; then
                echo "PING HOST NOT RESOPNSE, FAILED!!!" | tee -a $TEST_SUMMARY
                return 1
            else
                echo "[+] LAN PING PASSED" | tee -a $TEST_SUMMARY
                return 0
            fi
        fi
        echo "[+] LAN PING PASSED" | tee -a $TEST_SUMMARY
        return 0
    fi
    return 0
}

test_wan() {
    interfaces=$1
    result=$(ifconfig $interfaces | awk -F'[: \t]' '/inet addr/{print $13}')
    echo "result: $result"
    if [ -z "$result" ]; then
        echo "WAN NOT HAVE CLIENT, FAILED!!!" | tee -a $TEST_SUMMARY
        return 1
    fi
    echo "[+] WAN PASSED" | tee -a $TEST_SUMMARY
    return 0
}

test_4g_modem() {
    result=$(cat /app/config/4g_modem)
    if [ "$result" == "none" ]; then
        echo "WAN NOT HAVE CLIENT, FAILED!!!" | tee -a $TEST_SUMMARY
        return 1
    fi
    echo "[+] 4G PASSED" | tee -a $TEST_SUMMARY
    return 0
}

test_net_connect() {
    result=$(ping -c 3 114.114.114.114 | grep "64 bytes from")
    if [ -z "$result" ]; then
        echo "PING HOST NOT RESOPNSE, FAILED!!!" | tee -a $TEST_SUMMARY
        return 1
    fi
    echo "[+] 4G PASSED" | tee -a $TEST_SUMMARY
    return 0
}

test_internet() {
    if [ -n "$1" ]; then
        interface="-I $1"
    fi
    result=$(ping $interface -c 3 114.114.114.114 | grep "64 bytes from")
    if [ -z "$result" ]; then
        echo "PING HOST NOT RESOPNSE, FAILED!!!" | tee -a $TEST_SUMMARY
        return 1
    fi
    echo "[+] 4G PASSED" | tee -a $TEST_SUMMARY
    return 0
}
