#!/bin/sh

test_rtc() {
        interfaces="rtc0"
        error_code=0
        error_msg="success"
        if [ ! -e "/dev/rtc0" ]; then
                echo "NO RTC0 NODE, FAILED!!!" | tee -a $TEST_SUMMARY
                error_code=1
                error_msg="NO RTC0 NODE, FAILED!!!"
                return 1
        fi
        return 0
}

test_uart() {
        diag=$1
        aux=$2
        interfaces="$diag"
        error_code=0
        error_msg="success"
        if [ -z $diag -o -z $aux ]; then
                echo "USART ARGS INVAILD!!!"
                return 3
        fi
        stty -F /dev/$diag raw 9600 cs8
        stty -F /dev/$aux raw 9600 cs8
        (cat /dev/$aux 2>&1 | tee /tmp/rs485_test_$diag.log) &
        sleep 1
        echo "XXXXXXXXXXXXXXXXXXXX" >/dev/$diag
        sleep 3
        killall cat
        result=$(cat /tmp/rs485_test_$diag.log | awk '/XXXXXX/{print $0}')
        echo "result: $result"
        if [ -z "$result" ]; then
                echo "RS485 NOT RECEIVE PACKETS, FAILED!!!" | tee -a $TEST_SUMMARY
                return 1
        fi
        echo "[+] RS485 PASSED" | tee -a $TEST_SUMMARY
        return 0
}

test_can() {
        diag=$1
        aux=$2
        interfaces="$diag"
        error_code=0
        error_msg="success"
        if [ -z $diag -o -z $aux ]; then
                echo "CAN ARGS INVAILD!!!"
                return 3
        fi
        ifconfig $diag down
        ip link set $diag type can bitrate 1000000 triple-sampling on
        ifconfig $diag up
        ifconfig $aux down
        ip link set $aux type can bitrate 1000000 triple-sampling on
        ifconfig $aux up
        (candump $aux 2>&1 | tee /app/can_test.log) &
        sleep 1
        cansend $diag 7FF#12345678
        sleep 1
        killall candump
        result=$(cat /app/can_test.log | awk '/7FF/{print $0}')
        echo "result: $result"
        if [ -z "$result" ]; then
                echo "CAN NOT RECEIVE PACKETS, FAILED!!!" | tee -a $TEST_SUMMARY
                return 1
        fi
        echo "[+] CAN PASSED" | tee -a $TEST_SUMMARY
        return 0
}

# 直连CPU串口的GPS模块
test_gps() {
        diag=$1
        interfaces="$diag"
        if [ -z $diag ]; then
                echo "USART ARGS INVAILD!!!"
                return 3
        fi
        stty -F /dev/$diag raw 9600 cs8
        (cat /dev/$diag 2>&1 | tee /app/gps_test.log) &
        sleep 5

        killall cat
        result=$(cat /app/gps_test.log | awk '/GGA/{print}')
        echo "result: $result"
        if [ -z "$result" ]; then
                echo "GPS NOT RECEIVE PACKETS, FAILED!!!" | tee -a $TEST_SUMMARY
                return 1
        fi
        echo "[+] GPS PASSED" | tee -a $TEST_SUMMARY
        return 0
}


# 检测EC200S的GNSS功能
test_gps_in_ec200s() {
        diag=$1
        interfaces="$diag"
        if [ -z $diag ]; then
                echo "USART ARGS INVAILD!!!"
                return 3
        fi
        gcom -d $diag -s /etc/gcom/EC200S_GNSS_init.gcom > /dev/null
        result=$(gcom -d /dev/ttyUSB1 -s /etc/gcom/EC200S_GNSS_get_loc.gcom | awk '/GGA/{print}')
        echo "result: $result"
        if [ -z "$result" ]; then
                echo "GPS NOT RECEIVE PACKETS, FAILED!!!" | tee -a $TEST_SUMMARY
                return 1
        fi
        echo "[+] GPS PASSED" | tee -a $TEST_SUMMARY
        return 0
}

test_sdcard() {
        interfaces="SDCard"
        error_code=0
        error_msg="success"
        if [ ! -e "/dev/mmcblk0" ]; then
                echo "NO mmcblk0 NODE, FAILED!!!" | tee -a $TEST_SUMMARY
                error_code=1
                error_msg="NO mmcblk0 NODE, FAILED!!!"
                return 1
        fi
        return 0
}
