. /lib/functions.sh
. /lib/dyiot/bin/get_hardware

help() {
    cat <<_HELP_
Setup virtual AP.
Usage: $0 -p <pin code> -a <apn>
        -p PIN Code
        -a APN
Example:
    $0 -p 1234 -a cmnet
_HELP_
}

if [ $# -lt 2 ]; then
    help
    exit 1
fi

while [ -n "$1" ]; do
    case $1 in
    -p)
        pin=$2
        shift 2
        ;;
    -a)
        apn=$2
        shift 2
        ;;
    --)
        shift
        break
        ;;
    -*)
        help
        exit 1
        ;;
    *) break ;;
    esac
done

modem=$(modem_name)
dev=$(modem_dev)

if [ -n "$pin" ]; then
    echo "$pin" >/app/config/sim_pin_code
    echo -e "AT+CLCK=\"SC\",0,\"$pin\"\r\n" >$dev
    echo "Clear PIN $pin"
fi

if [ -n "$apn" ]; then
    echo -e "AT+CGDCONT=1,\"IPV4V6\",\"$apn\"" >$dev
    echo "Set APN $apn"
fi

exit 0
