#!/bin/sh
. /lib/dyiot/bin/diag_sys.sh

json_init

# uboot_env=`fw_printenv`
uboot_env=$(factory get)
mac_addr=$(echo "$uboot_env" | awk -F'=' '/^MAC=/{print $2}')
sn=$(echo "$uboot_env" | awk -F'=' '/^SN=/{print $2}')
hwver=$(echo "$uboot_env" | awk -F'=' '/^HWVER=/{print $2}')
fdate=$(echo "$uboot_env" | awk -F'=' '/^DATE=/{print $2}')
echo "HWVER: $hwver"
echo "SN: $sn"
echo "DATE: $date"
echo "SWVER: $(cat /etc/issue)"
json_add_string "sn" "$sn"
json_add_string "product" "$PRODUCT"
json_add_int "timestamp" $(date +%s)
json_add_string "MAC" "$mac_addr"
json_add_string "HWVER": "$hwver"
json_add_string "SWVER": "$(cat /etc/issue)"

help() {
    cat <<_HELP_
diagnose devices

Usage:  $0 [COM|zigbee|ble]
           if no item given, then will diagnose all device
_HELP_
}

prepare_env

json_add_object "data"

if [ $# -ge 1 ]; then
    case "$1" in
    COM)
        json_add_array "COM"
        msg=$(test_uart ttyFTDI0 ttyFTDI1)
        ret=$?
        json_add_result_to_obj "RS485_1" "$ret" "$msg"
        msg=$(test_uart ttyFTDI1 ttyFTDI0)
        ret=$?
        json_add_result_to_obj "RS485_2" "$ret" "$msg"
        msg=$(test_uart ttyFTDI2 ttyFTDI3)
        ret=$?
        json_add_result_to_obj "RS485_3" "$ret" "$msg"
        msg=$(test_uart ttyFTDI3 ttyFTDI2)
        ret=$?
        json_add_result_to_obj "RS485_4" "$ret" "$msg"
        json_close_array
        ;;
    zigbee)
        json_add_array "zigbee"
        msg=$(test_zigbee /dev/ttyS1)
        ret=$?
        json_add_result_to_obj "zigbee" "$ret" "$msg"
        json_close_array
        ;;
    LED)
        json_add_array "Led"
        msg=$(test_led led-heart led-lora led-internet led-wlan)
        ret=$?
        json_add_result_to_obj "led" "$ret" "$msg"
        json_close_array
        ;;
    ble)
        json_add_array "BLE"
        msg=msg=$(test_ble /dev/ttyS2 3)
        ret=$?
        json_add_result_to_obj "BLE" "$ret" "$msg"
        json_close_array
        ;;
    lan)
        json_add_array "LAN"
        msg=$(test_lan)
        ret=$?
        json_add_result_to_obj "LAN" "$ret" "$msg"
        json_close_array
        ;;
    *)
        help
        exit 1
        ;;
    esac
else
    json_add_array "Led"
    msg=$(test_led led-heart led-lora led-internet led-wlan)
    ret=$?
    json_add_result_to_obj "led" "$ret" "$msg"
    json_close_array

    json_add_array "OnBoardPort"
    msg=$(test_uart ttyFTDI0 ttyFTDI1)
    ret=$?
    json_add_result_to_obj "RS485_1" "$ret" "$msg"
    msg=$(test_uart ttyFTDI1 ttyFTDI0)
    ret=$?
    json_add_result_to_obj "RS485_2" "$ret" "$msg"
    msg=$(test_uart ttyFTDI2 ttyFTDI3)
    ret=$?
    json_add_result_to_obj "RS485_3" "$ret" "$msg"
    msg=$(test_uart ttyFTDI3 ttyFTDI2)
    ret=$?
    json_add_result_to_obj "RS485_4" "$ret" "$msg"
    json_close_array

    json_add_array "Wireless"
    msg=$(test_lora)
    ret=$?
    json_add_result_to_obj "lora" "$ret" "$msg"

    msg=$(test_wifi 0)
    ret=$?
    json_add_result_to_obj "wlan0" "$ret" "$msg"

    msg=$(test_wifi 1)
    ret=$?
    json_add_result_to_obj "wlan1" "$ret" "$msg"

    msg=$(test_ble /dev/ttyS2 3)
    ret=$?
    json_add_result_to_obj "BLE" "$ret" "$msg"

    msg=$(test_zigbee /dev/ttyS1)
    ret=$?
    json_add_result_to_obj "zigbee" "$ret" "$msg"
    json_close_array

    json_add_array "NetWork"
    msg=$(test_4g_modem)
    ret=$?
    json_add_result_to_obj "4g_modem" "$ret" "$msg"

    msg=$(test_net_connect)
    ret=$?
    json_add_result_to_obj "ping" "$ret" "$msg"

    msg=$(test_wan eth0.4094)
    ret=$?
    json_add_result_to_obj "WAN" "$ret" "$msg"

    msg=$(test_lan)
    ret=$?
    json_add_result_to_obj "LAN" "$ret" "$msg"
    json_close_array
fi
json_close_object
echo ""
echo "---TEST SUMMARY---"
#cat $TEST_SUMMARY
sleep 1
json_str=$(json_dump)
echo "test_result:$json_str"

restore_env
