require "log"
require "sys"
require "utils"
require "patch"
require "pack"
require "bit"
local siganl = require 'posix.signal'
local syswait = require 'posix.sys.wait'
local unistd = require 'posix.unistd'
local lpack=require("lua_pack")
local internal_api=require("internal_api")

LOG_LEVEL = log.LOGLEVEL_DEBUG

--[[ 
# 发布日期:20221019
# 模块功能:
    - 防逆流电表通讯故障
    - BMS禁充,禁放
    
    - 交流配电总开关,闭合干接点
    - 交流配电电表功率 > 5kw
    - UPS 工作状态开断干接点
    - 消防故障开断干接点
    - 电池舱空调通讯故障
    - 电池舱空调故障反馈闭合干接点
    - 弧光检测告警开断干接点

    - 急停反馈闭合干接点
    - 喷洒状态反馈开断干接点
    - 消防火警闭合干接点
    - 安全继电器动作信号干接点
# 应用项目:
    - 清安
    堆运行温度：TAG_7686 IDENT Read100C_1016  [GW_SN]_Cluster_1
    湿度：TAG_4B2  IDENT TempHumRead  [GW_SN]_temp1
    空调:温度->[GW_SN]_aircond1   高 sethighctrltemp  低 setlowctrltemp  *10
        湿度 setctrlhumidity
    可燃气体：fire
            TAG_4D7,TAG_4D9  [GW_SN]_fire
]]
local aircond_table = {
    group1 = {"[GW_SN]_aircond1","[GW_SN]_aircond2","[GW_SN]_aircond3"},
    group2 = {"[GW_SN]_aircond4","[GW_SN]_aircond5","[GW_SN]_aircond6"},
    groupbms1 = "[GW_SN]_Cluster_1",
    groupbms2 = "[GW_SN]_Cluster_2",
    aircond_humidity_count_g1 =0,
    aircond_humidity_count_g2 =0,
    aircond_temp_count_g1 = 0,
    aircond_temp_count_g2 = 0,
    temp = {
        ident_hightemp = {
            ident = "sethighctrltemp",
            tag = "TAG_421",
            k = 10
        },
        ident_lowtemp = {
            ident = "setlowctrltemp",
            tag = "TAG_422",
            k = 10
        }
    },
    humidity={
        ident_humidity = {
            ident = "setctrlhumidity",
            tag = "TAG_423",
            k = 1
        }
    },
    setonoff ={
        setoff = {
            ident = "setoff",
            tag = "TAG_3FD",
            k = 1
        }
    }
}

local sub_nodes = {
    {
        sn_suffix = "_gridmeter",
        grp_idx = nil,--nil:不分组总数据,1:第一组,2:第二组,
        ident_list = {"yougongzongdianliang","sanxiangcv"}, --关心的采集服务
        offline_enable=false,
        timeout=600,
        common_level = 1  --1-yellow,2-red level=1 ,3,-red level=2
        
    },
    {
        sn_suffix = "_ENGASS",
        grp_idx = nil,
        ident_list = {"system_status"},
        timeout=60,
        offline_enable =false
    },
    {
        sn_suffix = "_temp1",--barometer 1
        grp_idx = nil,
        tmp_idx =1,
        ident_list = {"TempHumRead"},
        offline_enable =true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_temp2",
        grp_idx = nil,
        tmp_idx = 2,
        ident_list = {"TempHumRead"},
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_temp3",
        grp_idx = nil,
        tmp_idx = 3,
        ident_list = {"TempHumRead"},
        offline_enable =true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_temp4",
        grp_idx = nil,
        tmp_idx = 4,
        ident_list = {"TempHumRead"},
        offline_enable =true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_temp5",
        grp_idx = nil,
        tmp_idx = 5,
        ident_list = {"TempHumRead"},   --TAG_4B2 温度   TAG_4B1 温度
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_PCS1",
        grp_idx = 1,
        ident_list = {"Read32_40Data"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_PCS2",
        grp_idx = 2,
        ident_list = {"Read32_40Data"},
        offline_enable = true,
        timeout=60,
        common_level = 3  --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_Cluster_1",
        grp_idx = 1,
        ident_list = {"Read100C_1016"},
        offline_enable = true,
        timeout=10,
        common_level = 2 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_Cluster_2",
        grp_idx = 2,
        ident_list = {"Read100C_1016"},
        offline_enable = true,
        timeout= 10,
        common_level = 2  --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_DI",
        grp_idx = nil,
        ident_list = {"DIRead"},
        timeout=5,
        offline_enable = false
    },
    {
        sn_suffix = "_IO1",
        grp_idx = nil,
        ident_list = {"DIRead"},
        offline_enable = true,
        timeout=5,
        common_level = 1  --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_IO2",
        grp_idx = nil,
        ident_list = {"DIRead"},  
        offline_enable = true,
        timeout=5,
        common_level = 1  --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_fire",
        grp_idx = nil,
        ident_list = {"fire"},
        offline_enable = true,
        timeout=5,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_sj1",
        grp_idx = nil,
        sj_index = 1, --TAG_579
        ident_list = {"DIRead"},
        offline_enable = true,
        timeout=5,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_sj2",
        grp_idx = nil,
        sj_index = 2,
        ident_list = {"DIRead"},
        offline_enable = true,
        timeout=5,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_sj3",
        grp_idx = nil,
        sj_index = 3,
        ident_list = {"DIRead"},
        offline_enable = true,
        timeout=5,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_loadmeter1",
        grp_idx = nil,
        ident_list = {"sanxianggongluxinxi"},-- TAG_272F 总有功功率
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_loadmeter2",
        grp_idx = nil,
        ident_list = {"sanxiangcv"},
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_bmsmeter1",
        grp_idx = nil,
        ident_list = {"sanxiangcv"},
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_bmsmeter2",
        grp_idx = nil,
        ident_list = {"sanxiangcv"},
        offline_enable = true,
        timeout=15,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_aircond1",
        grp_idx = nil,
        ac_index = 1,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_aircond2",
        grp_idx = nil,
        ac_index = 2,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_aircond3",
        grp_idx = nil,
        ac_index = 3,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_aircond4",
        grp_idx = nil,
        ac_index = 4,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond5",
        grp_idx = nil,
        ac_index = 5,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond6",
        grp_idx = nil,
        ac_index = 6,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond7",
        grp_idx = nil,
        ac_index = 7,
        ident_list = {"readon_off"},
        offline_enable = true,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond8",
        grp_idx = nil,
        ac_index = 8,
        ident_list = {"readon_off"},
        offline_enable = false,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond9",
        grp_idx = nil,
        ac_index = 9,
        ident_list = {"readon_off"},
        offline_enable = false,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },{
        sn_suffix = "_aircond10",
        grp_idx = nil,
        ac_index = 10,
        ident_list = {"readon_off"},
        offline_enable = false,
        timeout=60,
        common_level = 3 --1-yellow,2-red level=1 ,3,-red level=2
    },
    {
        sn_suffix = "_aircond11",
        grp_idx = nil,
        ac_index = 11,
        ident_list = {"readon_off"},
        offline_enable = false,
        timeout=60,
        common_level = 1 --1-yellow,2-red level=1 ,3,-red level=2
    }
    -- _aircond1  [GW_SN]_aircond11
    -- [GW_SN]_bmsmeter1
    -- [GW_SN]_loadmeter1
    -- [GW_SN]_loadmeter2
}
local gw_sn
local nodes_info --SN:object
local g_nodes --全局node_cfg
local g_grp = {--[[{data={},ctrl={},status={},protect={},warn={}}]]}
local g_temp = {--[[{data={},ctrl={},status={},protect={},warn={}}]]}
local g_sj = {--[[{data={},ctrl={},status={},protect={},warn={}}]]}
local g_ac = {--[[{data={},ctrl={},status={},protect={},warn={}}]]}
local g_total = {data={},ctrl={},status={},protect={},warn_type={},warn={}}
local aircond_off_time = 0
-- local aircond_off_count = 0
-- local aircond_temp_count = 0
-- local aircond_humidity_count = 0
local aircond_dqc_count = 0

local function warn_report(warninfo,sig)
    local obj = {}
    if sig==1 then
        obj.info="触发故障: "..warninfo
    else
        obj.info="故障恢复: "..warninfo
    end   
    
    obj.result = 0
    internal_api.service_response(gw_sn,gw_sn .. "_EMSCTRL","VINTF_TCP","report_info",obj,0)
    -- log.info("report_info",v.sn,v.connect_port)
    log.info("report_info",cjson.encode(obj))

end
local function offline_report(infostr)
    local obj = {}
    obj.info=infostr
    obj.result = 0
    internal_api.service_response(gw_sn,gw_sn .. "_EMSCTRL","VINTF_TCP","report_info",obj,0)
    -- log.info("report_info",v.sn,v.connect_port)
    log.info("report_info",cjson.encode(obj))

end


local function aircond_temp_set(groupid,tmpval)
    local grouteinfo = nil
    --local node_cfg=nil
    local bmssn=nil
    local now = os.time()

    -- print("airtemp",now,aircond_temp_count)
    if groupid == 1 then
        if aircond_table.aircond_temp_count_g1 == 0 then
            aircond_table.aircond_temp_count_g1 = now
            return
        else
            if os.difftime(now,aircond_table.aircond_temp_count_g1) < 30 then
                return
            else
                aircond_table.aircond_temp_count_g1 = 0
            end
        end
        grouteinfo = aircond_table.group1
        --node_cfg =nodes_info[aircond_table.groupbms1]
        bmssn = aircond_table.groupbms1
    else
        if aircond_table.aircond_temp_count_g2 == 0 then
            aircond_table.aircond_temp_count_g2 = now
            return
        else
            if os.difftime(now,aircond_table.aircond_temp_count_g2) < 30 then
                return
            else
                aircond_table.aircond_temp_count_g2 = 0
            end
        end
        grouteinfo = aircond_table.group2
        --node_cfg =nodes_info[aircond_table.groupbms2]
        bmssn = aircond_table.groupbms2
    end
    

    for index,v in ipairs(grouteinfo) do
	    -- print(v,aircond_table.temp.ident_hightemp.ident)
        -- print(v,aircond_table.temp.ident_hightemp.tag,aircond_table.temp.ident_lowtemp.tag,tmpval)    
        -- bms offline or not
        print("ac name:",v,"groupid:",groupid)
        print("bms serial name",bmssn)
        print("bms offline flag",nodes_info[bmssn].overtime)        
        
        if g_ac[index+(groupid-1)*3].data.TAG_3FD == 1 and nodes_info[v].overtime == 0 and nodes_info[bmssn].overtime == 0 then
            print("bms name",bmssn," online , temperature setting value:",tmpval) 
        internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.temp.ident_hightemp.ident,{[aircond_table.temp.ident_hightemp.tag]= tmpval* aircond_table.temp.ident_hightemp.k})
        --internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.temp.ident_lowtemp.ident,{[aircond_table.temp.ident_lowtemp.tag]= tmpval* aircond_table.temp.ident_lowtemp.k})
        else
            print("bms name",bmssn,"overtime:",nodes_info[bmssn].overtime ,"no temperature setting",v,nodes_info[v].overtime)
           -- internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.temp.ident_hightemp.ident,{[aircond_table.temp.ident_hightemp.tag]= 32767})
            --internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.temp.ident_lowtemp.ident,{[aircond_table.temp.ident_lowtemp.tag]= 32767})
        end
        -- internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan1",{["TAG_79E"]= 0xff00 })
    end
end

local function aircond_humidity_set(groupid,humidval)
    local grouteinfo = nil
    local bmssn = nil
    local now = os.time()
    
    -- print("groupid:",groupid,nodes_info[aircond_table.groupbms1])
    if groupid == 1 then
        if aircond_table.aircond_humidity_count_g1 == 0 then
            aircond_table.aircond_humidity_count_g1 = now
            return
        else
            if os.difftime(now,aircond_table.aircond_humidity_count_g1) < 30 then  
                return
            else
                aircond_table.aircond_humidity_count_g1 = 0
            end
        end
        grouteinfo = aircond_table.group1
        bmssn = aircond_table.groupbms1
    else
        if aircond_table.aircond_humidity_count_g2 == 0 then
            aircond_table.aircond_humidity_count_g2 = now
            return
        else
            if os.difftime(now,aircond_table.aircond_humidity_count_g2) < 30 then
                return
            else
                aircond_table.aircond_humidity_count_g2 = 0
            end
        end
        grouteinfo = aircond_table.group2
        bmssn = aircond_table.groupbms2
    end
    for index,v in ipairs(grouteinfo) do
        -- print(nodes_info[bmssn].sn_suffix,"node_cfg.overtime,",nodes_info[bmssn].overtime,aircond_table.groupbms1)
        if g_ac[index+(groupid-1)*3].data.TAG_3FD == 1 and nodes_info[v].overtime == 0 then --and nodes_info[bmssn].overtime == 0 then
            print("humidval",humidval,"bms name",bmssn," online ,  humidity setting")
        internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.humidity.ident_humidity.ident,{[aircond_table.humidity.ident_humidity.tag]= humidval* aircond_table.humidity.ident_humidity.k})
        else
            print("bms name",bmssn,nodes_info[bmssn].overtime, v,nodes_info[v].overtim," no humidity setting")
        end
    end
end

local function aircond_dqc_process()--电气仓空调
    local aircond_dqc_sn = "[GW_SN]_aircond7"
    local tempIndex = 5
    local now = os.time()
    if aircond_dqc_count == 0 then

        aircond_dqc_count = now
        -- print("yut---------------------------")
	    --return
    else
        -- print("yut time pass:", os.difftime(now,aircond_dqc_count))
        if os.difftime(now,aircond_dqc_count) < 30 then
            return
        else
            aircond_dqc_count = now
        end
    end
    
    print("yut on off:TAG_4B1",g_temp[tempIndex].data.TAG_4B1,"TAG_4B2:",g_temp[tempIndex].data.TAG_4B2)
    print("yut g_temp overtime",g_temp[tempIndex].overtime)
    if g_ac[7].data.TAG_3FD == 1 and nodes_info[aircond_dqc_sn].overtime == 0 then
        -- print("yut ac11 setting values:",aircond_dqc_sn,aircond_table.humidity.ident_humidity.ident,aircond_table.humidity.ident_humidity.tag,g_temp[tempIndex].data.TAG_4B2*aircond_table.humidity.ident_humidity.k)
        if g_temp[tempIndex].overtime == 0 then
            if g_temp[tempIndex].data.TAG_4B2 then
            internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.humidity.ident_humidity.ident,{[aircond_table.humidity.ident_humidity.tag]= g_temp[tempIndex].data.TAG_4B2* aircond_table.humidity.ident_humidity.k})
            end
            if g_temp[tempIndex].data.TAG_4B1 then
            internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.temp.ident_hightemp.ident,{[aircond_table.temp.ident_hightemp.tag]= g_temp[tempIndex].data.TAG_4B1 * aircond_table.temp.ident_hightemp.k})
            internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.temp.ident_lowtemp.ident,{[aircond_table.temp.ident_lowtemp.tag]= g_temp[tempIndex].data.TAG_4B1 * aircond_table.temp.ident_lowtemp.k})
            end
        else
            --[[ internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.humidity.ident_humidity.ident,{[aircond_table.humidity.ident_humidity.tag]= 32767})
            internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.temp.ident_hightemp.ident,{[aircond_table.temp.ident_hightemp.tag]= 32767})
            internal_api.call_dev_service(gw_sn, aircond_dqc_sn, "NULL",aircond_table.temp.ident_lowtemp.ident,{[aircond_table.temp.ident_lowtemp.tag]= 32767}) ]]
        end
    end
end
local function get_emsctrl_mode ()    
    while(true) do
        sys.wait(3000)
        internal_api.call_dev_service(gw_sn, gw_sn .. "_EMSCTRL", "VINTF_TCP","modesel_get")
    end
end

local function  aircond_off_process()
    local grouteinfo = nil
    local now = os.time()
    local groutindex=1
    -- print("aircond_off_count:",aircond_off_count)
    if aircond_off_time == 0 then
        aircond_off_time = now
    else
        if os.difftime(now,aircond_off_time) < 30 then
            return
        end
    end
    grouteinfo = aircond_table.group1
    
    for i,v in ipairs(grouteinfo) do
        if g_ac[i+(groutindex-1)*3].data.TAG_3FD == 1 and nodes_info[v].overtime == 0 then
        -- print(v,aircond_table.setonoff.setoff.ident)
        internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.setonoff.setoff.ident)
        offline_report(v.."空调关机")
        end
    end
    groutindex = 2
    grouteinfo = aircond_table.group2
    for i,v in ipairs(grouteinfo) do
        if g_ac[i+(groutindex-1)*3].data.TAG_3FD == 1 and nodes_info[v].overtime == 0 then
        -- print(v,aircond_table.setonoff.setoff.ident)
        internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.setonoff.setoff.ident)
        offline_report(v.."空调关机")
        end
    end
    -- for _,v in ipairs(grouteinfo) do
    --     print(v,aircond_table.setonoff.setoff.ident)
    --     internal_api.call_dev_service(gw_sn, v, "NULL",aircond_table.setonoff.setoff.ident)
    -- end
    
end

local function protect_level_get(g_total ,g_grp)
    assert(g_total.protect)
    local protect_level = 0
    if g_grp and g_grp.protect and g_grp.protect.level then
        if not g_total.protect.level then
            protect_level = g_grp.protect.level
        else
            protect_level = g_total.protect.level > g_grp.protect.level and g_total.protect.level or g_grp.protect.level
        end
    else
        protect_level = g_total.protect and g_total.protect.level and g_total.protect.level or 0
    end
    return protect_level
end

local function init_grp_structure(grp_obj,sub_nodes)
    assert(grp_obj)
    assert(sub_nodes)
    local size = 0
    local tmpsize = 0
    local sjsize = 0
    local acsize = 0
    for _,v in ipairs(sub_nodes) do
        if v.grp_idx then
            if v.grp_idx > size then size = v.grp_idx end
        end
        if v.tmp_idx then
            if v.tmp_idx > tmpsize then tmpsize = v.tmp_idx end
        end
        if v.sj_index then
            if v.sj_index > sjsize then sjsize = v.sj_index end
        end
        if v.ac_index then
            if v.ac_index > acsize then acsize = v.ac_index end
        end
    end
    if size == 0 then size = 1 end

    for grp_idx = 1,size do
        local data_space
        if not grp_obj[grp_idx] then grp_obj[grp_idx] = {} end
        data_space = grp_obj[grp_idx]
        if not data_space.protect then data_space.protect = {} end
        if not data_space.data then data_space.data = {} end
        if not data_space.ctrl then data_space.ctrl = {} end
        if not data_space.status then data_space.status = {} end
        if not data_space.warn_type then data_space.warn_type = {} end
        if not data_space.warn then data_space.warn = {} end
    end
    for i=1,tmpsize do
        g_temp[i] = {}
        g_temp[i].data = {}
    end
    for i=1,sjsize do
        g_sj[i] = {}
        g_sj[i].data = {}
    end

    for i=1,acsize do
        g_ac[i] = {}
        g_ac[i].data = {}
    end
end


-- 数据采集
local function pp_msg(topic,payload)
    local currTime = os.time()
    -- print("pp2msg",topic,payload)
    local obj = cjson.decode(payload)   
    local tags = obj.tag_node and cjson.decode(obj.tag_node) or nil
    ---- 先对数据做汇聚
    if not obj.sn then
        log.error(nil,"Invalid device sn")
        return
    end
    local node_info = nodes_info[obj.sn]
    if not node_info then return end
    local found
    for _,ident in ipairs(node_info.ident_list) do
        if obj.identifier == ident then
            found = true
            break
        end
    end
    if not found then 
        log.error(nil,string.format("Invalid identifier:%s in sn:%s",obj.identifier,obj.sn))
    end

    local grp_idx = node_info.grp_idx
    local data_space
    local humidity_data = 0
    if node_info.tmp_idx == nil and node_info.sj_index == nil and node_info.ac_index == nil  then
        if grp_idx then   data_space = g_grp[grp_idx]
        else data_space = g_total
        end
    elseif node_info.sj_index  then
        data_space = g_sj[node_info.sj_index]
    elseif node_info.tmp_idx then
        -- print("recv node_info.tmp_idx",node_info.tmp_idx)
        humidity_data = 1
        data_space =  g_temp[node_info.tmp_idx]
    elseif node_info.ac_index then
        data_space = g_ac[node_info.ac_index]
    end

    if data_space then
    -- 更新数据
        for msg_field,msg_value in pairs (tags)do -- 遍历上来的变量
            local data = data_space.data
            data[msg_field] = msg_value
            -- log.debug(nil,msg_field,msg_value)
        end
    -- 更新状态
        node_info.recv_time = os.time()
        if humidity_data == 1  then
            -- print("temp sensor idx",node_info.tmp_idx)
            sys.publish("HUMIDITY_DATA_UPDATE",node_info.tmp_idx)
        else
            sys.publish("REAL_DATA_UPDATE",grp_idx)
        end
    end
    -- log.debug(nil,cjson.encode(g_grp[1]))
end

--EMSCTRL
local function ems_msg(topic,payload)
    --local currTime = os.time()
    local obj = cjson.decode(payload)
    if obj.identifier == "modesel_get" then
        print("emsctrl :",obj.tags.ctrlMode)
        g_total.data.emsctrlMode = obj.tags.ctrlMode
        g_total.data.pcsChargeOrdisCharge=obj.tags.option --1 charge 2 discharge
        print("pcsChargeOrdisCharge :",obj.tags.option)
    end
end

-- 控制命令
local function iot_msg(topic,payload)
    local currTime = os.time()
    -- print("iot 2 msg",topic,payload)
    local obj = cjson.decode(payload)   
    if obj.identifier == "protect_level_set" then
        local changed
        local last_level = g_total.protect.level
        print("-----------------------------------------")
        print(payload)
        if obj.protect_level then  g_total.protect.level = obj.protect_level end
        if last_level ~= g_total.protect.level then changed = true end
        for grp_idx = 1,#g_grp do
            local data_space = g_grp[grp_idx]
            if not data_space then break end
            -- local key = string.format("grp_protect_level",grp_idx)
            -- local key = "grps_protect_level"
            local data = data_space.protect
            -- if obj[key][grp_idx].level then data.level = obj[key][grp_idx].level end
            if obj.grps_protect_level and obj.grps_protect_level[grp_idx] then
                local grp_protect = obj.grps_protect_level[grp_idx]
                local last_level = data.level
                if grp_protect.level then data.level = grp_protect.level end
                if last_level ~= data.level then changed = true end
            end
        end
        if changed then sys.publish("PROTECT_LEVEL_CHANGED") end
        --log.debug(nil,g_total.protect.level,cjson.encode(g_grp[1]))
    end
    internal_api.pp2north(gw_sn,obj.sn,"NULL",obj.identifier,{},obj.mi)
end
local function get_timeout_ac(grp_idx)
    local grouteinfo = nil
    if grp_idx == 1 then
        grouteinfo = aircond_table.group1
    else
        grouteinfo = aircond_table.group2
    end
    for i,v in ipairs(grouteinfo) do
        if nodes_info[v].overtime == 1 then
            return true
        end
    end
    return false
end
local function total_warn_level_report()
    while true do
        sys.waitUntil("WARN_LEVEL_CHANGED",1000)
        
        local obj = {
            fault_level = g_total.warn.level and g_total.warn.level or 0,
            grps_fault_level = {}
        }
        for grp_idx,grp_obj in ipairs(g_grp) do
            
            table.insert(obj.grps_fault_level,{level = grp_obj.warn.level and grp_obj.warn.level or 0})
        end
        for i,v in ipairs(g_nodes) do
            print(cjson.encode(obj))
            internal_api.pp2north(gw_sn,v.sn,"NULL","fault_level_report",obj,0)
        end
        sys.wait(3000)
    end
end

local function total_warn_calculate()
    while true do
        local ret,grp_idx = sys.waitUntil("REAL_DATA_UPDATE",2000)
        local now = os.time()
        if not grp_idx then -- 没有grp代表总数据,或者超时
            local data_space = g_total
            if data_space then
                local last_value = data_space.warn.level
                data_space.status.offlinelevel1 = 0
                data_space.status.offlinelevel2 = 0
                for key, value in pairs(nodes_info) do
                    if value.offline_enable == true and value.grp_idx == nil then
			            if value.recv_time ~= nil then
                            if os.difftime(now,value.recv_time)>=value.timeout then
                                print("g_total over time:",value.sn_suffix)--ytprint
                                if value.ac_index==nil then
                                    if value.common_level == 1 then
                                        data_space.status.yellowled = true
                                    end
                                    if value.common_level == 2 then
                                        data_space.status.offlinelevel1 = 1
                                        -- data_space.status.redled = true
                                    end
                                    if value.common_level == 3  then
                                        data_space.status.offlinelevel2 = 1--ac is not considered as total warn
                                        -- data_space.status.redled = true
                                    end
                                    if (value.overtime ==0 or value.overtime ==nil) then--and value.offline_enable==true then
                                        print("others off line:",value.sn_suffix)--ytprint
                                        if string.find(value.sn_suffix,"fire") then
                                            offline_report( "可燃气通信故障")
                                        end
                                        if value.tmp_idx then
                                            g_temp[value.tmp_idx].overtime= 1
                                            -- aircond_humidity_set(math.ceil(value.tmp_idx/2),32767)
                                            print("temp_",value.tmp_idx,"humidity group",math.ceil(value.tmp_idx/2))
                                        end
                                    end
                                else
                                    if (value.overtime ==0 or value.overtime ==nil) then--and value.offline_enable==true then
                                        
                                            offline_report(gw_sn..value.sn_suffix .. "离线")
                                        
                                    end
                                end
                                value.overtime=1 --ytprint 
                            else
                                value.overtime=0
                                if value.tmp_idx then
                                    g_temp[value.tmp_idx].overtime= 0          
                                end        
                            end
                        end
                    end
                end
                if data_space.data.TAG_272F and  data_space.data.TAG_272F > 50 then -- org 50
                    if data_space.status.TAG_272F == 1 then
                        if os.difftime(now, data_space.status.TAG_272Ftimer)>= 25 then
                            data_space.data.TAG_272Fflag = 1
                        else
                            data_space.data.TAG_272Fflag = 0
                        end

                    else
                        data_space.status.TAG_272F = 1
                        data_space.status.TAG_272Ftimer = now
                    end
                else
                    data_space.status.TAG_272F=0
                    data_space.status.TAG_272Ftimer = 0
                end
                if data_space.data.TAG_77B ==1 and ( data_space.warn_type.TAG_77B==nil or data_space.warn_type.TAG_77B==0) then

                    warn_report("急停反馈闭合干接点",1)
                    data_space.warn_type.TAG_77B=1
                end
                if data_space.data.TAG_776 ==1 and ( data_space.warn_type.TAG_776==nil or data_space.warn_type.TAG_776==0) then

                    warn_report("消防喷洒状态反馈开断干接点",1)
                    data_space.warn_type.TAG_776=1
                end
                if data_space.data.TAG_779 ==1 and ( data_space.warn_type.TAG_779==nil or data_space.warn_type.TAG_779==0) then

                    warn_report("消防火警闭合干接点",1)
                    data_space.warn_type.TAG_779=1
                end
                if data_space.data.TAG_77A ==1 and ( data_space.warn_type.TAG_77A==nil or data_space.warn_type.TAG_77A==0) then

                    warn_report("安全继电器动作信号闭合干接点",1)
                    data_space.warn_type.TAG_77A=1
                end
                if data_space.data.TAG_780 ==1 and ( data_space.warn_type.TAG_780==nil or data_space.warn_type.TAG_780==0) then

                    warn_report("交流配电总开关位置反馈闭合干接点",1)
                    data_space.warn_type.TAG_780=1
                end
                if data_space.data.TAG_782 ==1 and ( data_space.warn_type.TAG_782==nil or data_space.warn_type.TAG_782==0) then

                    warn_report("UPS正常工作状态开断干接点",1)
                    data_space.warn_type.TAG_782=1
                end
                if data_space.data.TAG_777 ==1 and ( data_space.warn_type.TAG_777==nil or data_space.warn_type.TAG_777==0) then

                    warn_report("消防故障开断干接点",1)
                    data_space.warn_type.TAG_777=1
                end
                if data_space.data.TAG_77C ==1 and ( data_space.warn_type.TAG_77C==nil or data_space.warn_type.TAG_77C==0) then

                    warn_report("弧光检测告警开断干接点",1)
                    data_space.warn_type.TAG_77C=1
                end
                -- 急停反馈闭合干接点	DI      1915	  TAG_77B
                if data_space.data.TAG_77B  == 1 or
                -- 消防喷洒状态反馈开断干接点	DI	1910	TAG_776
                data_space.data.TAG_776 == 1  or 
                -- 消防火警闭合干接点	1913	TAG_779
                data_space.data.TAG_779 == 1 or
                -- 安全继电器动作信号闭合干接点	1914	TAG_77A
                data_space.data.TAG_77A == 1                 
                then
                    data_space.warn.level = 3


                -- 交流配电总开关位置反馈闭合干接点	1920	TAG_780   
                elseif data_space.data.TAG_780  == 1 or
                -- UPS正常工作状态开断干接点	1922	TAG_782
                    data_space.data.TAG_782 == 1 or
                -- 消防故障开断干接点	1911	TAG_777
                    data_space.data.TAG_777 == 1 or
                -- 弧光检测告警开断干接点	1916	TAG_77C
                data_space.data.TAG_272Fflag == 1 or
                data_space.data.TAG_77C == 1 or
                data_space.data.TAG_781 == 1 or
                data_space.data.TAG_783 == 1 or
                --离线设备告警长关机
                (data_space.data.TAG_4D7 and data_space.data.TAG_4D7  > 25 ) or
                (data_space.data.TAG_4D9 and data_space.data.TAG_4D9 > 25 ) or
                data_space.status.offlinelevel2 == 1
                then
                    data_space.warn.level = 2
                -- 电网电表离线
                elseif data_space.status.offlinelevel1 == 1
                then
                    data_space.warn.level = 1
                else
                    data_space.warn.level = 0
                end
                --data_space.warn.level = 2
                -- print("level:",data_space.warn.level,"offlinelevel1:",data_space.status.offlinelevel1,"offlinelevel2:",data_space.status.offlinelevel2)
		-- 状态改变通知其他模块上报
                if last_value ~= data_space.warn.level then
                    sys.publish("WARN_LEVEL_CHANGED")
                end
            end
        end
    end
end

local function  air_temp_process()
    while true do
        local ret,grp_idx = sys.waitUntil("REAL_DATA_UPDATE",2000)
        if ret and grp_idx then
            local data_space = g_grp[grp_idx] 
            if data_space and data_space.data and data_space.data.TAG_7686 then
                aircond_temp_set(grp_idx,data_space.data.TAG_7686)
            end
        end
        local data_space = g_total
	    -- print(data_space.data.TAG_4D7,data_space.data.TAG_4D9)
        --aircond_off_process()
        if(data_space.data.TAG_4D7 and data_space.data.TAG_4D7  > 25 )or (data_space.data.TAG_4D9 and data_space.data.TAG_4D9 > 25 )then
            if data_space.data.TAG_4D7  > 25 and ( data_space.warn_type.TAG_4D7==nil or data_space.warn_type.TAG_4D7==0) then

                warn_report("可燃气浓度告警",1)
                data_space.warn_type.TAG_4D7=1
            end
            if data_space.data.TAG_4D9  > 25 and ( data_space.warn_type.TAG_4D9==nil or data_space.warn_type.TAG_4D9==0 ) then

                warn_report("可燃气浓度告警",1)
                data_space.warn_type.TAG_4D9=1
            end
            aircond_off_process()
            print("aircond off process")
            -- aircond_off_process(2)
        end
        --[[ if (data_space.data.TAG_4D9 and data_space.data.TAG_4D9 > 25 ) then
	        print("aircond off process")
            aircond_off_process(2)
        end ]]
    end
end

local function grp_warn_calculate(idx)
    while true do
        local ret,grp_idx = sys.waitUntil("REAL_DATA_UPDATE",2000)
        if ret and grp_idx and grp_idx == idx then
            local data_space = g_grp[grp_idx]
            local ac_flag = 0;
            
            if data_space then

                
                for key, value in pairs(nodes_info) do
                    
                    if value.offline_enable == true and value.grp_idx== grp_idx then
                        -- print(" yut grp nodes_info:",value.sn_suffix)
			            if value.recv_time ~= nil then
                            if os.difftime(os.time(),value.recv_time)>=value.timeout then
                                print("grp warn over time:",value.sn_suffix)--ytprint
                                print("grp_idx:",grp_idx,"redled:",data_space.status.redled)
                                --[[ if value.common_level == 1 then
                                    data_space.status.yellowled = true
                                end
                                if value.common_level == 2 then
                                    data_space.status.offlinelevel1 = 1
                                    data_space.status.redled = true
                                end
                                if value.common_level == 3 then
                                    data_space.status.offlinelevel2 = 1
                                    data_space.status.redled = true
                                end ]]
                                if (value.overtime ==0 or value.overtime ==nil) and value.offline_enable==true then
                                    offline_report(gw_sn..value.sn_suffix .. "离线")
                                end
                                value.overtime = 1 --ytprint 
                                data_space.status.redled = true --may wrong warnlever and protect level should change   
                                aircond_temp_set(grp_idx,32767)  
                                print("actemp32767")                         

                            else
                                value.overtime = 0
                                data_space.status.redled = false
                                

                            end
                        end
                    end
                end


                local last_value = data_space.warn.level
                -- print("TAG_77E:",g_total.data.TAG_77E,"TAG_77F:",g_total.data.TAG_77F)
                for i = (grp_idx-1)*3+1,(grp_idx-1)*3+3 do
                    -- print("i:",i,"TAG_3FD",g_ac[i].data.TAG_3FD,"TAG_4E24:",data_space.data.TAG_4E24)
                    if g_ac[i].data.TAG_3FD == 0 and data_space.data.TAG_4E24 == 0 then
                        ac_flag = 1
                        break
                    end
                end
                
                if g_total.data[string.format("TAG_%3X",0x77D+grp_idx)] == 1   or   ac_flag == 1 or get_timeout_ac(grp_idx)==true--DI模块放在总数据，不在组数据
                -- 电堆n空调故障反馈开断干接点	1918	TAG_77E
                then
                    print("batter pile DO1:",g_total.data[string.format("TAG_%3X",0x77D+1)],"batter pile DO2:", g_total.data[string.format("TAG_%3X",0x77D+2)])
                    print("group",grp_idx,"ac_flag_grp",ac_flag)
                    print("get_timeout_ac",get_timeout_ac(grp_idx))
                    if(g_total.data[string.format("TAG_%3X",0x77D+grp_idx)] == 1) then 
                        if g_total.warn_type[string.format("TAG_%3X",0x77D+grp_idx)]==0 or g_total.warn_type[string.format("TAG_%3X",0x77D+grp_idx)]==nil then
                        warn_report(string.format("电堆:%d 空调故障干接点",grp_idx),1 )
                        g_total.warn_type[string.format("TAG_%3X",0x77D+grp_idx)]=1
                        end
                    end
                    data_space.warn.level = 2       
                elseif g_total.data.emsctrlMode == 1 and data_space.data.TAG_76FB==1 and  g_total.data.pcsChargeOrdisCharge== 2  then--data_space.data.TAG_4E64==1 then
                    --data_space.warn.level = 1
                    print("auto discharge forbidden")
                elseif g_total.data.emsctrlMode == 1 and data_space.data.TAG_76FA == 1 and g_total.data.pcsChargeOrdisCharge == 1 then
                    --data_space.warn.level = 1
                    print("auto charge forbidden")
                elseif g_total.data.emsctrlMode == 1 and data_space.data.TAG_7747 == 1 then
                    data_space.warn.level = 1
                    print("auto discharge & charge  forbidden")
                else
                    if g_total.warn_type[string.format("TAG_%3X",0x77D+grp_idx)]==1 then
                        warn_report(string.format("电堆:%d 空调故障干接点",grp_idx),0)
                        g_total.warn_type[string.format("TAG_%3X",0x77D+grp_idx)]=0
                    end
                    --print("禁充放:",data_space.data.TAG_7747,"禁充：",data_space.data.TAG_76FA, "禁放：",data_space.data.TAG_76FB,"PCS状态:",g_total.data.pcsChargeOrdisCharge )
                    data_space.warn.level = 0--wrong
                end
                -- elseif g_total.data.emsctrlMode == 1 then
                --     if data_space.data.TAG_7747 == 1 then
                --         data_space.warn.level = 1
                --     else
                --         if  data_space.data.TAG_76FB==1 and data_space.data.TAG_4E64==1 then
                --             data_space.warn.level = 1
                --         else
                --             data_space.warn.level = 0
                --         end
                --         if  data_space.data.TAG_76FA == 1 and data_space.data.TAG_4E63==1  then
                --             data_space.warn.level = 1
                --         else
                --             data_space.warn.level = 0
                --         end
                --     end
                -- else
                --     data_space.warn.level = 0
                -- end
                --print("grp_idx:",grp_idx,"TAG_7747:",data_space.data.TAG_7747,"warn.level",data_space.warn.level,"TAG_76FB:",
                --data_space.data.TAG_76FB,"TAG_76FB:",data_space.data.TAG_76FB,"TAG_4E64:",data_space.data.TAG_4E64
                --,"TAG_4E63:",data_space.data.TAG_4E63)
                -- 状态改变通知其他模块上报
                if last_value ~= data_space.warn.level then
                    sys.publish("WARN_LEVEL_CHANGED",idx)
                end
            end
        end
    end
end

local function get_grp_protect_value()
    local level = 0
    for grp_idx = 1,#g_grp do
        local data_space = g_grp[grp_idx]
        if not data_space then break end
        -- local key = string.format("grp_protect_level",grp_idx)
        -- local key = "grps_protect_level"
        local data = data_space.protect
        if data.level and level < data.level then
            level = data.level
        end
    end
    print("level:-------",level)
    return level
end

local function total_protect_process()
    local last_protect_level
    local last_warn_flag
    local action_step_idx = 0
    local do_sn = string.format("%s%s",gw_sn,"_IO1")
    local run_indicator
    local warn_indicator
    local fault_indicator
    while true do
        local now = os.time()
        local protect_level = g_total.protect.level and g_total.protect.level or 0
        print("protect_level:",protect_level,"last_protect_level:",last_protect_level)
        if last_protect_level ~= protect_level then
            action_step_idx = 0
            last_protect_level = protect_level
        end
        if action_step_idx == 0 then
            if protect_level > 0 then
                log.warn(nil,string.format("System failure, level:%d",protect_level))
                fault_indicator = 1
                run_indicator = 0
            else -- 没有保护,意味着没触发故障
                log.warn(nil,string.format("System running"))
                run_indicator = 1
                fault_indicator = 0
            end
	        g_total.status.yellowled = false
            g_total.status.redled = false
            --log.info("nodes_info",cjson.encode(nodes_info))--ytprint
            --print(cjson.encode(nodes_info))
            for key, value in pairs(nodes_info) do
                if value.offline_enable == true then
                    -- print(key,value.recv_time,now,value.offline_enable,g_total.status.yellowled,"common_level",value.common_level)
                    -- print("protect nodes_info:",value.sn_suffix)--yt print
                    if value.recv_time ~= nil and value.grp_idx == nil then
                        if os.difftime(now,value.recv_time)>=value.timeout then
                            print("protect over time:",value.sn_suffix)--yt print
                            if (value.overtime ==0 or value.overtime ==nil) and value.offline_enable==true then
                                offline_report(gw_sn..value.sn_suffix .. "离线")
                            end
                            value.overtime = 1
                            if value.common_level == 1 then
                                g_total.status.yellowled = true
                            end
                            if value.common_level == 2 then
                                g_total.status.redled = true
                            end
                            if value.common_level == 3 then
                                g_total.status.redled = true
                            end
                            
                        else
                            value.overtime = 0
                            --may wrong 
                        end
                    end
                end
            end

            for grp_idx = 1,#g_grp do
                local data_space = g_grp[grp_idx]
                if not data_space then break end--may wrong
                -- local key = string.format("grp_protect_level",grp_idx)
                -- local key = "grps_protect_level"

                local data = data_space.protect
                if data.level == 2 or (data_space.status and data_space.status.redled == true) then
                    g_total.status.redled = true
                    break
                end
            end
            if g_total.data.TAG_77E and g_total.data.TAG_77E == 1 or g_total.data.TAG_77F and g_total.data.TAG_77F == 1 then
                g_total.status.redled = true
            end
            if g_total.status.redled == true then
                fault_indicator = 1
            end
            for i, value in ipairs(g_sj) do
                -- print("i:",i,"TAG_579:",value.data.TAG_579)
                if value.data.TAG_579 == 1 then
                    g_total.status.yellowled = true
                end
            end
            -- UPS电池总压低告警开断干接点	DI			1921	TAG_781
            -- 消防预警开断干接点	DI			1912	TAG_778
            -- 弧光检测告警开断干接点	DI			1916	TAG_77C
            -- UPS旁路告警开断干接点	DI			1923	TAG_783
            local grp_flag = get_grp_protect_value()
            warn_indicator = (g_total.data.TAG_77D == 1 or g_total.data.TAG_785 == 1 or g_total.data.TAG_778 == 1 or
            g_total.data.TAG_786 == 1 or g_total.data.TAG_787==1 or g_total.data.TAG_788==1 or grp_flag == 1 or
            g_total.status.yellowled == true ) and 1 or 0
            if last_warn_flag ~= warn_indicator then
                last_warn_flag = warn_indicator
                if warn_indicator == 1 then
                    log.warn(nil,string.format("System exited warning"),g_total.data.TAG_781,g_total.data.TAG_778,g_total.data.TAG_77C,g_total.data.TAG_783)
                end
            end
        end
        if fault_indicator == 1 then
            run_indicator = 0
            warn_indicator = 0
        elseif warn_indicator == 1 then
            run_indicator = 0
            fault_indicator = 0
        else
            warn_indicator = 0
            fault_indicator = 0
        end
        --print(g_total.data.TAG_781, g_total.data.TAG_778,g_total.data.TAG_77C,g_total.data.TAG_783,g_total.status.offlinelevel2,g_total.status.offlinelevel1)
        print("run_indicatior:",run_indicator,"warn_indicator",warn_indicator,"fault_indicator",fault_indicator,"TAG_786",g_total.data.TAG_786 ,"TAG_787",g_total.data.TAG_787 ,"TAG_788", g_total.data.TAG_788,"yellow:",g_total.status.yellowled)

        if run_indicator == 1 then
            -- 储能系统运行指示干接点	DO			1963	TAG_7AB
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan1",{["TAG_79E"]= 0xff00 })
            --储能系统故障指示（声光报警）干接点	DO			1965	TAG_7AD
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan3",{["TAG_7A0"]= 0 })
        end
        if warn_indicator == 1 then
            -- 储能系统报警指示干接点	DO			1964	TAG_7AC
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan2",{["TAG_79F"]= 0xff00 })
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan1",{["TAG_79E"]= 0 })
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan3",{["TAG_7A0"]= 0 })
        else
            -- 储能系统报警指示干接点	DO			1964	TAG_7AC
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan2",{["TAG_79F"]= 0 })
        end

        if fault_indicator == 1 then
            -- 储能系统运行指示干接点	DO			1963	TAG_7AB
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan1",{["TAG_79E"]= 0 })
            --储能系统故障指示（声光报警）干接点	DO			1965	TAG_7AD
            internal_api.call_dev_service(gw_sn, do_sn, "NULL", "writexianquan3",{["TAG_7A0"]= 0xff00 })
        end
        sys.waitUntil("PROTECT_LEVEL_CHANGED",3000)--from 30000 to 3000
    end
end


local function humidity_air_process()
    while true do
    local humidity_val = 0
    local timeover = 0
        local ret,grp_idx = sys.waitUntil("HUMIDITY_DATA_UPDATE",30000)
        if grp_idx ~= nil then
            if grp_idx <= 2 then
                for i=1,2 do
                    if g_temp[i].data.TAG_4B2 and humidity_val < g_temp[i].data.TAG_4B2 then
                        humidity_val = g_temp[i].data.TAG_4B2
                    end
                    if g_temp[i].overtime == 1 then
                        timeover = 1
                    end
                end 
                if timeover == 1 then
                    --aircond_humidity_set(1,32767)
                else
                    aircond_humidity_set(1,humidity_val)
                end            
            elseif grp_idx < 5 then
                for i=3,4 do
                    if g_temp[i].data.TAG_4B2 and humidity_val < g_temp[i].data.TAG_4B2 then
                        humidity_val = g_temp[i].data.TAG_4B2
                    end
                    
                    
                end
                if timeover == 1 then
                    --aircond_humidity_set(2,32767)
                else
                    aircond_humidity_set(2,humidity_val)
                end
            else
                -- print("yut appliance cabinet",grp_idx)
                aircond_dqc_process()
            end
        else
            for i=1,2 do
                print("g_temp ----",i,"overtime:",g_temp[i].overtime)
                if g_temp[i].overtime == 1 then
                    timeover = 1
                end
                if timeover == 1 then
                   -- aircond_humidity_set(1,32767)
                end
            end
            for i=3,4 do
                print("g_temp ----",i,"overtime:",g_temp[i].overtime)
                if g_temp[i].overtime == 1 then
                    timeover = 1
                end
                if timeover == 1 then
                    --aircond_humidity_set(2,32767)
                end
            end
            aircond_dqc_process()
        end
    end
end

local function grp_protect_process(idx)
    local action_steps = {
        {
            desc = "Breaker",
            cmp_obj = g_total.data,
            cmp_tag = "pcs_run_state",
            equal_v = 0,
            send_param = {
                sn = string.format("%s%s",gw_sn,"_DI"),
                -- TODO 需要等设备配置号了修改
                identifier = "DO"..idx,
                -- 动态计算TAG号
                -- 并网点断路器1远程分闸干接点	DO			1960	TAG_7A8
                -- 并网点断路器2远程分闸干接点	DO			1961	TAG_7A9
                tag = string.format("TAG_%03X",0X7A8 + idx - 1),
                value = 0xff00,
            }
        },
        {
            desc = "Breaker",
            cmp_obj = g_total.data,
            cmp_tag = "pcs_run_state",
            equal_v = 0,
            send_param = {
                sn = string.format("%s%s",gw_sn,"_DI"),
                -- TODO 需要等设备配置号了修改
                identifier = "DO"..idx+1,
                -- 动态计算TAG号
                -- 并网点断路器1远程分闸干接点	DO			1960	TAG_7A8
                -- 并网点断路器2远程分闸干接点	DO			1961	TAG_7A9
                tag = string.format("TAG_%03X",0X7A8 + idx),
                value = 0xff00,
            }
        },
        {
            desc = "UPS",
            cmp_obj = g_total.data,
            cmp_tag = "bms_switch_on_state",
            equal_v = 0,
            send_param = {
                sn = string.format("%s%s",gw_sn,"_DI"),
                -- TODO 需要等设备配置号了修改
                identifier = "DO3",
                -- 动态计算TAG号
                -- UPS切载干接点	DO			1962	TAG_7AA 
                -- 这里放在总的保护处理函数中也可以
                tag = "TAG_7AA",
                value = 0x0000,--0xff00
            }
        }
    }

    local last_protect_level 
    local action_step_idx = 0
    while true do
        assert(idx)
        sys.waitUntil("PROTECT_LEVEL_CHANGED",3000)
        -- 执行命令的序号
        local protect_level = protect_level_get(g_total ,g_grp[idx])
        if last_protect_level ~= protect_level then
            action_step_idx = 0
            last_protect_level = protect_level
        end
        if action_step_idx<3 then
            local step_tmp=action_steps[action_step_idx+1]        
            print("xxxxxxxxxxxxxxxstep:",action_step_idx+1)
            print("xxxxxxxxxxxxxxxpcs_run_state:",step_tmp.cmp_obj[step_tmp.cmp_tag])
        end
        print("xxxxxxxxxxxxxxx:",protect_level)
        
        if protect_level == 3 then
            print("xxxxxxxxxxxxxxx level 3 shut down starts:",os.time())
            while action_step_idx < #action_steps do
                local step = action_steps[action_step_idx+1]
                assert(step.cmp_obj)
                assert(step.cmp_tag)
                assert(step.equal_v)
                assert(step.send_param)
                assert(step.send_param.sn)
                assert(step.send_param.identifier)
                assert(step.send_param.tag)
                assert(step.send_param.value)
                local last_time = os.time()
                local level_chenaged
                -- 测试代码 sys.timerStart(function () g_total.data.pcs_run_state = 0 end,3000)
                -- print("cmp_tag>:",step.cmp_tag,step.cmp_obj[step.cmp_tag],step.equal_v)
                while os.difftime(os.time(),last_time) < 90 do
                    print("cmp_tag:",step.cmp_tag,step.cmp_obj[step.cmp_tag],step.equal_v)
                    if step.cmp_obj[step.cmp_tag] and step.cmp_obj[step.cmp_tag] == step.equal_v then 
                        print("xxxxxxxxxxxxxxx level3 shut down steps:",action_step_idx+1,os.time())
                        break 
                    end
                    sys.wait(1000)
                    -- if sys.waitUntil("PROTECT_LEVEL_CHANGED",500) then level_chenaged = true break end
                end
                sys.wait(1000)
                -- 等待过程中,保护等级变更
                -- if not level_chenaged then
                internal_api.call_dev_service(gw_sn, step.send_param.sn, "NULL", step.send_param.identifier,{[step.send_param.tag]= step.send_param.value })
                action_step_idx = action_step_idx + 1
                log.info(nil,string.format("grp[%d] execute step[%d]:%s!",idx - 1,action_step_idx,step.desc));
                -- end
            end
        end
    end
end

function main(nodes_cfg,sn)
    log.info("main_loop", "=============== Guard System of EMS 1.0.0 ============")
    local bmssn
    gw_sn = sn
    if not gw_sn then
        gw_sn = io.getGatewayID()
    end

    g_nodes = cjson.decode(nodes_cfg)
    
    init_grp_structure(g_grp,sub_nodes)
    
    if not internal_api.update_nodes_info then log.error(nil, "Please upgrade package:internal_api version to 2.0.7 or higher") return end
    nodes_info = internal_api.update_nodes_info(gw_sn,sub_nodes)
    
    --[[ bmssn = aircond_table.groupbms1
    nodes_info[bmssn].recv_time=os.time()
    bmssn = aircond_table.groupbms2
    nodes_info[bmssn].recv_time=os.time() ]]

    log.info("main_loop",  string.format("Try Run At Shell\nsn='%s'\nnodes='%s'\nmain_loop(nodes,sn)",gw_sn or "NOT SN",nodes_cfg or ""))

    siganl.signal(siganl.SIGKILL,handler)
    siganl.signal(siganl.SIGHUP,handler)

    local subscribe = internal_api.get_subscribes(gw_sn,sub_nodes,g_nodes)
    table.insert(subscribe,"ipc/[GW_SN]/VINTF_TCP/device/[GW_SN]_EMSCTRL/data_filtered/service/modesel_get")
    internal_api.mqtt_session("localhost", 1883, nil, nil, subscribe, function (topic,payload)
        if string.find(topic,"/data/service/") then  pp_msg(topic,payload) --如果是原始数据一定是南向数据
        elseif string.find(topic,"/data/Set_Rglt") then iot_msg(topic,payload)
        elseif string.find(topic,"data_filtered/service/modesel_get") then ems_msg(topic,payload)
        end
    end)

    sys.taskInit(total_warn_calculate)

    sys.taskInit(total_warn_level_report)

    sys.taskInit(total_protect_process)
    sys.taskInit(humidity_air_process)
    sys.taskInit(air_temp_process)
    sys.taskInit(get_emsctrl_mode)
    sys.taskInit(grp_protect_process, 1)
    for grp_idx = 1, #g_grp do
        sys.taskInit(grp_warn_calculate, grp_idx)
    end

    -- 启动系统框架
    sys.init(0, 0)
    sys.run()
end
local nodes_cfg =
    '[{"connect_port":"VINTF_TCP","depth":0,"product_key":"206627059","sn":"[GW_SN]_GUARD","template_id":"206627059"}]'
 main(arg[1], arg[2])
 -- main(nodes_cfg,"[GW_SN]")
