#!/opt/lnxall/bin/lua
local invoker = require 'invoker'
local cjson = require("cjson")
local g_online_gw = nil
local function update_online_gwsn_port()
    local filp = io.popen("exec nc -i 1 -w 1 -v 127.0.0.1 2334 2>/dev/null", "r")
    if not filp then
        io.stderr:write("Error, failed to invoke nc.\n")
        io.stderr:flush()
        return false
    end
    for line in filp:lines() do
        local gw_info = {}
        if string.find(line, ", lastact:", 1, true) then
            local sn, lastact, online, portno = string.match(line, "ssh_(%w+), lastact: (%d+), online: (%a+), port: (%d+)")
            if sn and lastact and online and portno then
                -- lastact = tonumber(lastact) + 8 * 3600
                -- io.stdout:write(string.format("Gateway:%s last activity: %s, online: %s, port: %s\n",
                -- sn, os.date(nil, lastact), online, portno))
                -- io.stdout:flush()
                if not g_online_gw then
                    g_online_gw = {}
                end
                g_online_gw[sn] = {port = portno};
                -- print("Gateway " .. sn .. " No:", sn)
            end
        end
    end
    local rest = filp:read("*a")
    filp:close(); rest, filp = nil, nil

    return true
end


local function ssh_exc_cmd(port, cmd)
    local exc_cmd = 'ssh -oConnectionAttempts=4 -oStrictHostKeyChecking=no -oConnectTimeout=10 -oServerAliveInterval=5 -oServerAliveCountMax=3 -i /home/support/lnxall_gateway_ssh '
    ..'-p '..port..' root@127.0.0.1 '
    .."'"..cmd.."'"
    return os.execute(exc_cmd)
end

function get_file_md5(file_path)
    local cmd = "md5sum ".. file_path.." | cut -d ' ' -f1"
    local handle = io.popen(cmd)
    local output = handle:read("*a")
    handle:close()
    if (not output) or (#output < 32) then
        output = "nil"
    end
    md5 = output:gsub("%c", "")
    return md5
end


local function get_file(gw, port)

    local handle = io.popen('ls -p '..gw)
    local files = {}
    for file in handle:lines() do
        files[#files + 1] = file
    end
    handle:close()

    table.sort(files, function(a, b) return a > b end)
    if not files[1] then
        files[1] = "nilnil"
    end
    local md5 = get_file_md5(gw..'/'..files[1])
    if (ssh_exc_cmd(port, 'test -e /mnt/ssd/packdir/LNXALL_APP_EMS_*.elf') == 0) then
        if ssh_exc_cmd(port, 'md5sum /mnt/ssd/packdir/'..files[1]..'| grep '..md5) ~= 0 then
            local scp_cmd = 'scp -oConnectionAttempts=4 -oStrictHostKeyChecking=no -oConnectTimeout=10 -oServerAliveInterval=5 -oServerAliveCountMax=3 -i /home/support/lnxall_gateway_ssh '
            ..'-P '..port..' root@127.0.0.1:/mnt/ssd/packdir/LNXALL_APP_EMS_*.elf ./'..gw
            if os.execute('mkdir -p '..gw..' && '..scp_cmd) ~= 0 then
                io.stderr:write(gw..":Error, elf scp failed.\n")
                io.stderr:flush()
                return false
            end
        else
            io.stderr:write(gw..":elf already exist.\n")
            io.stderr:flush()
        end

        return true
    end

    if ssh_exc_cmd(port, 'test -e /root/packapp/packapp') ~= 0 then
        local scp_cmd = 'scp -oConnectionAttempts=4 -oStrictHostKeyChecking=no -oConnectTimeout=10 -oServerAliveInterval=5 -oServerAliveCountMax=3 -i /home/support/lnxall_gateway_ssh '
        ..'-P '..port..' ./packapp.tar root@127.0.0.1:/root/packapp.tar'
        if os.execute(scp_cmd) == 0 then
            if ssh_exc_cmd(port, 'tar -xzvf ./packapp.tar && cd packapp && ./packapp 127.0.0.1 '..gw..' start') ~= 0 then
                io.stderr:write(gw..":Error, packapp start failed.\n")
                io.stderr:flush()
                return false
            end
        else
            io.stderr:write(gw..":packapp.tar scp failed.\n")
            io.stderr:flush()
            return false
        end
    else
        if ssh_exc_cmd(port, 'cd packapp && ./packapp 127.0.0.1 '..gw..' start' .. ' >/dev/null 2>&1') ~= 0 then
            io.stderr:write(gw..":packapp start failed.\n")
            io.stderr:flush()
            return false
        end
    end
    return true
end

local function main(gw)
    gw_tb = {}
    update_online_gwsn_port()
    --
    if not g_online_gw then
        io.stderr:write("Error, no online gateway found.\n")
        io.stderr:flush()
        return false
    end
    --
    if not gw then
        io.stderr:write("Error, no gateway specified.\n")
        io.stderr:flush()
        return false
    end
    
    if gw == "all" then
        for sn, gwinfo in pairs(g_online_gw) do
            io.stdout:write('sn:' .. sn .. '------------\n')
            io.stdout:flush()
            get_file(sn, gwinfo.port);
        end
        return true
    elseif string.sub(gw, -#'.json') == '.json' then
        local file = io.open(gw, "r")
        if not file then
            io.stderr:write("Error, could not open file: " .. gw .. "\n")
            io.stderr:flush()
        end
        local content = file:read("*a")
        file:close()

        local ok, result = pcall(cjson.decode, content)
        if not ok then
            io.stderr:write("Error, could not decode json: " .. result .. "\n")
            io.stderr:flush()
            return false
        end
        gw_tb = result
    else
        gw_tb[1] = gw
    end
    --
    for i, v in ipairs(gw_tb) do
        io.stdout:write('sn:' .. v .. '------------\n')
        io.stdout:flush()
        gwinfo = g_online_gw[v]
        if not gwinfo then
            io.stderr:write("Error, no gateway found.\n")
            io.stderr:flush()
        else
            get_file(v, gwinfo.port);
        end
    end
    return true
end

if not main(arg[1]) then os.exit(1) end

os.exit(0)
