#!/bin/bash

DLURL="$1"
DLDIR="/root/upgrade_4g"

if [ "$(uname -r)" != '3.10.0-1160.88.1.el7.x86_64' ] ; then
	echo "Error, invalid gateway, connot continue." 1>&2
	exit 1
fi

if [ -z "$DLURL" ] ; then
	echo "Error, 4G download URL not specified." 1>&2
	exit 2
fi

mkdir -p ${DLDIR} && cd ${DLDIR}
[ $? -ne 0 ] && exit 3

rm -rf * # remove all files in ${DLDIR}
wget "${DLURL}" # download tarball
if [ $? -ne 0 ] ; then
	echo "Error, failed to download 4G upgrade tarball." 1>&2
	exit 4
fi

TARBALL="$(ls)"
if [ ! -f "${TARBALL}" ] ; then
	echo "Error, failed to find downloaded tarball." 1>&2
	exit 5
fi

tar -Jxf "${TARBALL}"
if [ $? -ne 0 ] ; then
	echo "Error, failed to extract from '${TARBALL}'." 1>&2
	exit 6
fi

cd ./lnxall
if [ $? -ne 0 ] ; then
	echo "Error, failed to find ./lnxall directory." 1>&2
	exit 7
fi

mkdir -p /opt/lnxall
# remove existing files in `/opt/lnxall
rm -rf /opt/lnxall/bin /opt/lnxall/CentOS7-4G /opt/lnxall/etc \
	/opt/lnxall/lib /opt/lnxall/share /opt/lnxall/systemd \
	/opt/lnxall/version
# move new files to /opt/lnxall
mv -n * /opt/lnxall/

# install new network4g.service script
cp -v -f /opt/lnxall/systemd/network4g.service /usr/lib/systemd/system/

# disable services
systemctl stop avahi-daemon
systemctl stop avahi-daemon.socket
systemctl stop ModemManager
systemctl disable avahi-daemon
systemctl disable avahi-daemon.socket
systemctl disable ModemManager

# restart network4g service
echo "Restarting network4g service..."
systemctl daemon-reload
systemctl enable network4g
systemctl restart network4g

# terminate script
echo "Upgrade OK."
exit 0

