#!/usr/bin/lua

local cjson = require "cjson"
local posix = require "posix"
local invoker = require "invoker"

local combo_4g_okay = false
local netdev_4g = "enp0s29u1u2u4"



local function check_netdev(ndev)
        local eval = invoker.invoke(invoker.NOSTDIO, "ip", "link", "show", "dev", ndev)
        return eval == 0
end

local function find_4g_netdev()
	local okay, output = invoker.invoke(invoker.OUTPUT, "ip", "link", "show")
	if okay ~= 0 or type(output) ~= "string" then
		return nil
	end
	for mdev in string.gmatch(output, "enp[^:\r\n]+:") do
		local nlen = string.len(mdev)
		if nlen >= 9 then return mdev:sub(1, nlen - 1) end
	end
	return nil
end

-- added by ghzhang
local function get_ip_addr()
	local def_ip = "172.16.38.104"
	local cmds = {"sh", "/opt/lnxall/bin/fetch_subnet_gw_ip.sh"}
	local iflags = invoker.OUTPUT + invoker.BUFSIZ + invoker.NOSTDIO;
	iflags = iflags + 0x1f0000;
	local eval, result = invoker.invoke(iflags, cmds)
	if not eval then
		io.stderr:write(string.format("%s\n", result))
		io.stderr:flush()
		return false,def_ip
	end
	if eval ~= 0 or #result == 0 then
		io.stderr:write(string.format("Error, failed to invoke remote diag: %d, output: %d\n",
			eval, string.len(result)))
		io.stderr:flush()
		return false,def_ip
	end
	return true,result
end

-- global variables
local eval,imx6ull_ipaddr = get_ip_addr()
local imx6ull_sshport = 22001
io.stderr:write("Info--", string.format("imx6ull ip:%s  port:%d\n",imx6ull_ipaddr,imx6ull_sshport))
local diag_header = "---TEST SUMMARY---\ntest_result:"

local function get_remote_diag(ipaddr, portno)
	print("get_remote_diag STRAT!!!!")
        local cmds = { "sshpass", "-p", "lnxall123", "ssh",
		"-oStrictHostKeyChecking=no", "-oUserKnownHostsFile=/dev/null", "-p", tostring(portno), "root@" .. ipaddr,
		"PATH=/lib/dyiot/bin:/usr/sbin:/usr/bin:/sbin:/bin /app/diag.sh" }
	-- local iflags = invoker.OUTPUT + invoker.BUFSIZ;
	local iflags = invoker.OUTPUT + invoker.BUFSIZ  + invoker.NOSTDIO;
	iflags = iflags + 0x1f0000;
	local eval, result = invoker.invoke(iflags, cmds)
	if not eval then
		io.stderr:write(string.format("%s\n", result))
		io.stderr:flush()
		return false
	end
	if eval ~= 0 or #result == 0 then
		io.stderr:write(string.format("Error, failed to invoke remote diag: %d, output: %d\n",
			eval, string.len(result)))
		io.stderr:flush()
		return false
	end
	local needle = diag_header
	local fidx = string.find(result, needle, 1, true)
	if not fidx then
		io.stderr:write(string.format("Error, failed to find '%s'\n", needle))
		io.stderr:flush()
		return false
	end
	fidx = fidx + #needle
	result = result:sub(fidx)

	local pre = string.find(result,"sn",1,true)
	local sn_6ul = result:sub(pre+6,pre+17)
	local pre1 = string.find(result,"6ul_date",1,true)
	local date_6ul = result:sub(pre1+13,pre1+14)
	local okay, jres = pcall(cjson.decode, result)
	if not okay then
		io.stderr:write("Error, failed to decode:\n")
		io.stderr:write(result)
		return false
	end
	--print("==========================6UL==========================")
	--print(result)
	return date_6ul,sn_6ul,jres
end

local function prepare_diag()
	posix.setenv("PATH", "/opt/lnxall/bin:/usr/sbin:/usr/bin:/sbin:/bin", 1)
	posix.chdir("/root"); posix.mkdir(".ssh"); posix.unlink(".ssh/known_hosts")
	return true
end

local function test_imx6ull(ipAddr, portNo, tres)
	local BPORT = "OnBoardPort"
	local errmsg, errcode, interf = "error_msg", "error_code", "interfaces"
	-- setup default remote diag results
	tres[BPORT] = {
		[1] = {
			[interf] = "RS485_1",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[2] = {
			[interf] = "RS485_2",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[3] = {
			[interf] = "RS485_3",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[4] = {
			[interf] = "RS485_4",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[5] = {
			[interf] = "RS485_5",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[6] = {
			[interf] = "RS485_6",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[7] = {
			[interf] = "RS485_7",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[8] = {
			[interf] = "RS485_8",
			[errmsg] = "result: RS485 NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[9] = {
			[interf] = "CAN0",
			[errmsg] = "result: CAN NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[10] = {
			[interf] = "CAN1",
			[errmsg] = "result: CAN NOT RECEIVE PACKETS, FAILED!!!",
			[errcode] = 1
		},
		[11] = {
			[interf] = "DI_TEST",
			[errmsg] = "result: FAILED!!!",
			[errcode] = 1
		},
		[12] = {
			[interf] = "DO_TEST",
			[errmsg] = "result: FAILED!!!",
			[errcode] = 1
		},
		[13] = {
			[interf] = "RTC",
			[errmsg] = "result: FAILED!!!",
			[errcode] = 1
		},
	}

	if combo_4g_okay then
		tres["NetWork"] = {
			[1] = { ["interfaces"] = "4g_modem", ["error_msg"] = "success",
				["error_code"] = 0 },
			[2] = { ["interfaces"] = "Ping with 4G",
				["error_msg"] = "success", ["error_code"] = 0 }
		}
	else
		tres["NetWork"] = {
			[1] = { ["interfaces"] = "4g_modem", ["error_msg"] = "4G MODEM TEST FAILED!!!",
				["error_code"] = 1 },
			[2] = { ["interfaces"] = "Ping with 4G",
				["error_msg"] = "PING HOST NOT RESOPNSE, FAILED!!!", ["error_code"] = 1 }
		}
	end

	print("REMOTE IOBOARD PING TEST START")
	local pres, bufres = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
		"ping", "-A", "-W", "2", "-c", "8", ipAddr)
	if not pres or string.find(bufres, "100% packet loss", 1, true) then
		print("REMOTE IOBOARD PING TEST FAILED!!!")
		return false
	end
	print("REMOTE IOBOARD PING TEST OK")
	print("REMOTE IOBOARD DIAG TEST START")
	-- set ping to success
	tres["ioDetect"][1] = { [interf] = ipAddr, [errmsg] = "success", [errcode] = 0 }

	date_6ull,sn_6ull,rdiag = get_remote_diag(ipAddr, portNo)
	print(sn_6ull)
	if date_6ull=="ok" then
        tres[BPORT][14] = { ["interfaces"] = "date_6ull",["error_msg"] = "success",["error_code"] = 0}
    else
        tres[BPORT][14] = { ["interfaces"] = "date_6ull",["error_msg"] = "6ul_date error!",["error_code"] = 1}
	end
	local typn, bports = type(rdiag), nil
	if typn == "table" then
		rdiag = rdiag["data"]
		typn = type(rdiag)
	end
	if typn == "table" then
		bports = rdiag[BPORT]
		typn = type(bports)
	end
	if typn == "table" then
		for idx, bport in ipairs(bports) do
			typn = type(bport)
			if idx >= 1 and idx <= 13 and typn == "table" then
				tres[BPORT][idx] = bport
			end
		end
		print("REMOTE IOBOARD DIAG TEST OK")
	else
		print("REMOTE IOBOARD DIAG TEST FAILED!!!")
	end

	-- add 4G network test
	typn = type(rdiag)
	if not combo_4g_okay and typn == "table" and type(rdiag["NetWork"]) == "table" then
		tres["NetWork"][1] = rdiag["NetWork"][1]
		tres["NetWork"][2] = rdiag["NetWork"][3]
	end
	return true
end

--add by qyu
local function get_moudle_info(datj)
	print("MOUDLE INFO SETTINGS TEST START!")
    local eval,finfo = invoker.invoke(invoker.OUTPUT,"troubleshooting")
	if eval and type(finfo) == "string" then
    	local IMEI = string.gsub(string.match(finfo,"IMEI and Serial Number:([^\r\n]+)"),"%s+","")
        local Producer = string.gsub(string.match(finfo,"Manufacturer:([^\r\n]+)"),"%s+","")
		if Producer == "Quectel" then
			local moudle_4G_SP = Producer
        	_,_,moudle_4G_TYPE = string.find(finfo,'Revision: (%w+)')
        	local ICCID = string.match(finfo,"+CCID: ([%d\r\n]+)")
        	start,tail,sim_Producer = string.find(finfo,'COPS:%s%d,%d,(["].-["])')
			local sim_SP = string.sub(sim_Producer,2,tail-start-10)
			datj["MOUDLE_INFO"] = {
				["IMEI"] = IMEI,
				["moudle_4G_sp"] = moudle_4G_SP,
				["moudle_4G_type"] = moudle_4G_TYPE,
				["iccid"] = ICCID,
				["sim_sp"] = sim_SP
			}
		else
			local st,en,moudle_4G_Producer = string.find(finfo,'CGMI:%s(["].-["])')
            local moudle_4G_SP = string.sub(moudle_4G_Producer,2,en-st-6)
            a,b,moudle_4G_TYPE = string.find(finfo,'(Air%d+%w+)')
            local _,_,ICCID = string.find(finfo,'iccid info:%s*(%d+)')
            local c,d,sim_Producer = string.find(finfo,'COPS:%s%d,%d,(["].-["])')
            local sim_SP = string.sub(sim_Producer,2,d-c-10)
			datj["MOUDLE_INFO"] = {
				["IMEI"] = IMEI,
				["moudle_4G_sp"] = moudle_4G_SP,
				["moudle_4G_type"] = moudle_4G_TYPE,
				["iccid"] = ICCID,
				["sim_sp"] = sim_SP
			}
		end
	else
		print("MOUDLE INFO SETTINGS TEST FAILED!!")
		return false
	end
	print("MOUDLE INFO SETTINGS TEST OK")
	return true
end

local function test_service(datj)
	print("SERVICE TEST START")
	local cmd1 = 'systemctl status iptables |grep -e "Active: active"'
	local cmd2 = 'systemctl status dhcpd |grep -e "Active: active"'
	local cmd3 = 'systemctl status network4g |grep -e "Active: active"'
	local cmd4 = 'cat /opt/lnxall/version |grep -e "RELEASE DATE: "'
	local cmd5 = "uname -r"
--	local cmd6 = 'systemctl status ntpd |grep -e "Active: active"'


	local cmd = {cmd1,cmd2,cmd3,cmd4,cmd5}
	local buf={}
	for var=1,5,1 do
		buf[var] =(io.popen(cmd[var])):read()
		print(buf[var])
	end
	if(string.len(buf[1])>0) then
		datj["NetWork"][3] = { ["interfaces"] = "iptables", ["error_msg"] = "success",["error_code"] = 0 }
	else
		datj["NetWork"][3] = { ["interfaces"] = "iptables", ["error_msg"] = "iptables service error!",["error_code"] = 1 }
	end
	if(string.len(buf[2])>0) then
		datj["NetWork"][4] = { ["interfaces"] = "dhcpd", ["error_msg"] = "success",["error_code"] = 0 }
	else
		datj["NetWork"][4] = { ["interfaces"] = "dhcpd", ["error_msg"] = "dhcpd service error!",["error_code"] = 1 }
	end
	local date = string.match(buf[4],"%d+")
	if tonumber(date)>=20231127 and string.len(buf[3])>0 then
		datj["NetWork"][5] = { ["interfaces"] = "network4g", ["error_msg"] = "success",["error_code"] = 0 }
	else
		datj["NetWork"][5] = {["interfaces"] = "network4g", ["error_msg"] = "DATE OF NETWORK4G error!",["error_code"] = 1 }
	end
	if buf[5]=="3.10.0-1160.88.1.el7.x86_64" then
		datj["NetWork"][6] = { ["interfaces"] = "kernel_version", ["error_msg"] = "success",["error_code"] = 0 }
	else
		datj["NetWork"][6] = { ["interfaces"] = "kernel_version", ["error_msg"] = "kernel version error!",["error_code"] = 1 }
	end
--  if(buf[2]~=nil) then
--      datj["SERVICE"][2] = { ["interfaces"] = "ntpd", ["error_msg"] = "success",["error_code"] = 0 }
--  end

	print("SERVICE TEST OK")
	return date
end

local function ping_host(ipAddr, datj, inde)
	print(string.format("PING TEST %s START", ipAddr))
	local pres, bufres = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
		"ping", "-A", "-W", "2", "-c", "8", ipAddr)
	if not pres or string.find(bufres, "100% packet loss", 1, true) then
		print(string.format("PING TEST %s FAILED!!!", ipAddr))
		datj["ioDetect"][inde] = { ["interfaces"] = ipAddr, ["error_msg"] = "PING HAS FAILED!!!",
			["error_code"] = 1 }
	else
		print(string.format("PING TEST %s OK", ipAddr))
		datj["ioDetect"][inde] = { ["interfaces"] = ipAddr, ["error_msg"] = "success",
			["error_code"] = 0 }
	end
	return true
end

local function check_wan4(netdev, inde, datj)
	print(string.format("CHECKING WAN %s START", netdev))
	local pres, bufres = invoker.invoke(invoker.OUTPUT,
		"ip", "addr", "show", "dev", netdev)
	local okay = true
	if not pres or pres ~= 0 then okay = false end
	if okay then
		local ipaddr = string.match(bufres, "inet%s+([%d/.]+)%s+")
		local typn = type(ipaddr)
		if typn ~= "string" or #ipaddr == 0 then
			okay = false
		else
			print(string.format("IPADDR FOUND FOR %s: %s", netdev, ipaddr))
		end
	end
	if not okay then
		print(string.format("CHECKING WAN %s FAILED!!!", netdev))
		datj["wanTest"][inde] = { ["interfaces"] = netdev,
			["error_msg"] = "CHECK IPADDR FAILED!!!", ["error_code"] = 1 }
	else
		print(string.format("CHECKING WAN %s OK", netdev))
		datj["wanTest"][inde] = { ["interfaces"] = netdev,
			["error_msg"] = "success", ["error_code"] = 0 }
	end
	return true
end

local function check_usb0(netdev, inde, datj)
	print(string.format("CHECKING 4G %s START", netdev))
	invoker.invoke(invoker.OUTPUT, "ifconfig", "enp1s0", "down")
	invoker.invoke(invoker.OUTPUT, "ifconfig", "enp2s0", "down")
	local pres, bufres = invoker.invoke(invoker.OUTPUT,
		"ip", "addr", "show", "dev", netdev)
	local okay = true
	if not pres or pres ~= 0 then okay = false end
	if okay then
		local ipaddr = string.match(bufres, "inet%s+([%d/.]+)%s+")
		local typn = type(ipaddr)
		if typn ~= "string" or #ipaddr == 0 then
			okay = false
		else
			print(string.format("IPADDR FOUND FOR %s: %s", netdev, ipaddr))
		end
	end
	if not okay then
		print(string.format("CHECKING 4G %s FAILED!!!", netdev))
		datj["wanTest"][inde] = { ["interfaces"] = netdev,
			["error_msg"] = "CHECK IPADDR FAILED!!!", ["error_code"] = 1 }
	else
		local bufout = nil
		print(string.format("CHECKING 4G %s OK", netdev))
		okay, bufout = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
			"ping", "-c5", "-I", netdev, "mqtt.lnxall.com")
		if okay ~= 0 or string.find(bufout, "100% packet loss", 1, true) then
			okay, bufout = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
				"ping", "-c5", "-I", netdev, "rathole.lnxall.cn")
			if okay ~= 0 or string.find(bufout, "100% packet loss", 1, true) then
				okay, bufout = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
					"ping", "-c5", "-I", netdev, "8.8.8.8")
				if okay ~= 0 or string.find(bufout, "100% packet loss", 1, true) then
					okay, bufout = invoker.invoke(invoker.NOSTDIO + invoker.OUTPUT,
						"ping", "-c5", "-I", netdev, "114.114.114.114")
					if okay == 0 and string.find(bufout, "100% packet loss", 1, true) then
						okay = 1
					end
				end
			end
		end
		if okay == 0 then
			combo_4g_okay = true
			datj["wanTest"][inde] = { ["interfaces"] = (netdev == "usb0") and "4G" or netdev,
				["error_msg"] = "success", ["error_code"] = 0 }
		else
			datj["wanTest"][inde] = { ["interfaces"] = netdev,
				["error_msg"] = "CHECK PING FAILED!!!", ["error_code"] = 1 }
		end
	end
	print(string.format("CHECKING 4G %s FINISH", netdev))
	invoker.invoke(invoker.OUTPUT, "ifconfig", "enp1s0", "up")
	invoker.invoke(invoker.OUTPUT, "ifconfig", "enp2s0", "up")
	return true
end

local function combo_diag()
	local dres = {
		["sn_6ul"] = "",
		["product"] = "",
		["timestamp"] = os.time(),
		["MAC"] = "",
		["HWVER"] = "",
		["date"] = "",
	}
	dres["MOUDLE_INFO"] = {
		["IMEI"] = "",
		["moudle_4G_sp"] = "",
		["moudle_4G_type"] = "",
		["iccid"] = "",
		["sim_sp"] = "",
	}
	local dataj = {}
--[[
	dataj["NetWork"] = {
   		[3] = { ["interfaces"] = "iptables", ["error_msg"] = "iptable SERVICE error!",["error_code"] = 1 },
		[4] = { ["interfaces"] = "dhcpd", ["error_msg"] = "dhcpd SERVICE error!",["error_code"] = 1 },
		[5] = { ["interfaces"] = "network4g", ["error_msg"] = "network4g SERVICE error!",["error_code"] = 1 },
		[6] = { ["interfaces"] = "kernel_version", ["error_msg"] = "kernel_version error!",["error_code"] = 1 },
--      [7] = { ["interfaces"] = "ntpd", ["error_msg"] = "ntpd SERVICE error!",["error_code"] = 1 },

	}
]]--
	print("FACTORY SETTINGS TEST START")
	dres["SWVER"] = invoker.readfile("/etc/issue", invoker.TRIMEND)
	local eval, finfo = invoker.invoke(invoker.OUTPUT, "factory", "get")
	if eval and type(finfo) == "string" then
		local tval = string.match(finfo, "SN=([^\r\n]+)")
		if tval then dres["sn"] = tval end
		tval = string.match(finfo, "PRODUCT=([^\r\n]+)")
		if tval then dres["product"] = tval end
		tval = string.match(finfo, "MAC=([^\r\n]+)")
		if tval then dres["MAC"] = tval end
		tval = string.match(finfo, "HWVER=([^\r\n]+)")
		if tval then dres["HWVER"] = tval end
		print("FACTORY SETTINGS TEST OK")
	else
		print("FACTORY SETTINGS TEST FAILED!!!")
	end

	local gcp_check = {}
	-- comment by ghzhang
	--[[
	print("GCPCOM AUTHORIZATION TEST START")
	-- check for gcpcom process for authorization
	eval, finfo = invoker.invoke(invoker.OUTPUT, "pidof", "gcpcom")
	if not eval or eval ~= 0 or type(finfo) ~= "string" or #finfo == 0 then
		gcp_check[1] = { interfaces = "gcplicense", error_msg = "result: FAILED!!!", error_code = 1 }
		print("GCPCOM AUTHORIZATION TEST FAILED!!!")
	else
		gcp_check[1] = { interfaces = "gcplicense", error_msg = "success", error_code = 0 }
		print("GCPCOM AUTHORIZATION TEST OK")
	end
	-- check for GCP connection
	print("GCP CONNECTION 3400 TEST START")
	if invoker.tcpcheck("127.0.0.1", 3400, 1000) then
		gcp_check[2] = { interfaces = "gcp3400", error_msg = "success", error_code = 0 }
		print("GCP CONNECTION 3400 TEST OK")
	else
		gcp_check[2] = { interfaces = "gcp3400", error_msg = "result: FAILED!!!", error_code = 1 }
		print("GCP CONNECTION 3400 TEST FAILED!!!")
	end
	print("GCP CONNECTION 102 TEST START")
	if invoker.tcpcheck("127.0.0.1", 102, 1000) then
		gcp_check[3] = { interfaces = "gcp102", error_msg = "success", error_code = 0 }
		print("GCP CONNECTION 102 TEST OK")
	else
		gcp_check[3] = { interfaces = "gcp102", error_msg = "result: FAILED!!!", error_code = 1 }
		print("GCP CONNECTION 102 TEST FAILED!!!")
	end
	]]
	dataj["ioDetect"] = { [1] = { ["interfaces"] = "pingio",
		["error_msg"] = "result: PING FAILED!!!", ["error_code"] = 1 } }
	-- comment by ghzhang
	--[[
	ping_host("172.16.38.211", dataj, 2)
	ping_host("172.16.38.212", dataj, 3)
	ping_host("172.16.38.213", dataj, 4)
	ping_host("172.16.38.214", dataj, 5)
	ping_host("172.16.38.215", dataj, 6)
	ping_host("172.16.38.216", dataj, 7)
	]]
	dataj["wanTest"]  = {}

        if check_netdev("enp1s0") then
          check_wan4('enp1s0', 1, dataj)
        end
        if check_netdev("enp2s0") then
          check_wan4('enp2s0', 2, dataj)
        end
        if check_netdev("enp3s0") then
          check_wan4('enp3s0', 3, dataj)
        end
        --[[if check_netdev("enp4s0") then
          check_wan4('enp4s0', 1, dataj)
        end]]

	check_usb0(netdev_4g, 4, dataj)
	test_imx6ull(imx6ull_ipaddr, imx6ull_sshport, dataj)

	dres["sn_6ul"] = sn_6ull
	get_moudle_info(dres)
	dres["date"] = test_service(dataj)
	dres["data"] = dataj
	io.stdout:write("======================================================\n")
	io.stdout:write(diag_header)
	io.stdout:write(cjson.encode(dres))
	io.stdout:write("\n")
	io.stdout:flush()
	return true
end

if arg[1] and string.len(arg[1]) > 0 then
	netdev_4g = arg[1]
end
netdev_4g = find_4g_netdev() or netdev_4g
print(string.format("Using %s 4G netdev device!", netdev_4g))

prepare_diag()
combo_diag()
os.exit(0)
