#!/bin/bash

GWSN="$1"
cd "$(dirname $0)"

. ./cmd_common.sh

stop_packer() {
	if [ ! -e "${PACKER_PID}" ] ; then
		echo "INFO: packer not running on ${GWSN}"
		exit 0
	fi

	local epath=""
	local pid=$(cat ${PACKER_PID} 2>/dev/null)
	[ -n "${pid}" ] && epath=$(readlink -f /proc/${pid}/exe)
	if [ -f "${epath}" ] ; then
		kill -KILL "${pid}"
		killall -KILL tar xz >/dev/null 2>/dev/null
		rm -rf ${PACKDIR}/*
		echo "INFO: packer has been stopped"
	else
		echo "INFO: packer not running on ${GWSN}"
	fi
	exit 0
}

get_emsip
check_gwsn "${GWSN}"
stop_packer
