#!/bin/bash

GWSN="$1"
cd "$(dirname $0)"
. ./cmd_common.sh

start_packer() {
	if [ -e "${PACKER_PID}" ] ; then
		local pid=$(cat ${PACKER_PID} 2>/dev/null)
		[ -n "${pid}" ] && pid=$(readlink -f /proc/${pid}/exe)
		if [ -f "${pid}" ] ; then
			echo "ERROR: firmware packer already running on ${GWSN}"
			exit 1
		fi
	fi

	# start packer at the background
	rm -rf ${PACKLOGF}
	nohup ./packer.sh </dev/null >/dev/null 2>/dev/null &
	echo "INFO: packer started on ${GWSN}"
	exit 0
}

get_emsip
check_gwsn "${GWSN}"
start_packer
