#!/bin/bash

# EMS_IP=
PLATFORM=UNKNOWN
PACKDIR=/root/packdir
PACK_BDIR=/root/.packapp
PACKLOGF=/tmp/.packapp.log
PACKER_PID=/tmp/.packapp-pid.txt

EMS_LOCALIP='127.0.0.1'
PACKFILE=LNXALL_APP_PACKED.tar
UPGRADE_FILE=/root/.LNXALL_APP.elf
EMS_DIR=/opt/elect_resources/resources/app/web/dist/exdata

check_gwsn() {
	if [ -z "$1" ] ; then
		echo "ERROR: gateway SN not specified."
		exit 1
	fi
	local GSN=$(factory get | awk -F= '/SN=/{print $2}')
	if [ "${GSN}" != "$1" ] ; then
		echo "ERROR: invalid GWSN specified: $1"
		exit 2
	fi
}

check_platform() {
	# determine device platform
	if [ -n "$(grep -a -i -e rk3568 /proc/device-tree/model 2>/dev/null)" ] ; then
		declare -g PLATFORM=RK3568
	elif [ -n "$(grep -a -i -e ok3568 /proc/device-tree/model 2>/dev/null)" ] ; then
		declare -g PLATFORM=RK3568_FORLINX
	elif [ -n "$(grep -a -i -e 'Freescale i.MX6 Ultralite' /proc/cpuinfo)" ] ; then
		declare -g PLATFORM=IMX6UL
	else
		return 1
	fi
	return 0
}

get_emsip() {
	if [ -z "${SSH_CLIENT}" ] ; then
		if [ -z "${EMS_IP}" ] ; then
			echo "ERROR: EMS_IP not specified."
			exit 3
		fi
	else
		local EIP=${SSH_CLIENT%% *}
		if [ -z "${EIP}" ] ; then
			echo "ERROR: cannot find EMS ip address."
			exit 4
		fi
		declare -g EMS_IP="${EIP}"
	fi
}
