#!/bin/bash

HASN=
GWSN="$1"
cd "$(dirname $0)"
. ./cmd_common.sh

ems_upgrade() {
	if [ ! -e ${UPGRADE_FILE} ] ; then
		echo "ERROR: file not found: ${UPGRADE_FILE}"
		exit 1
	fi

	cd /root
	chmod +x ${UPGRADE_FILE}
	echo "INFO: upgrading ELF package for ${GWSN}..."
	${UPGRADE_FILE} ${HASN} </dev/null >/tmp/.packapp-upgrade.log 2>&1
	if [ $? -ne 0 ] ; then
		rm -rf ${UPGRADE_FILE}
		echo "ERROR: failed to upgrade ELF package for ${GWSN}"
		exit 2
	fi

	rm -rf ${UPGRADE_FILE}
	echo "INFO: ELF package upgraded for ${GWSN}"
	sync ; exit 0
}

[ "$2" = "-n" ] && HASN="-n"

sleep 2
get_emsip
check_gwsn "${GWSN}"
check_platform || exit 1
ems_upgrade
